;============================================================
; Combination data set #2
; stack plot of the singles start, stop, and coincidences
; (from the binned data)
;============================================================

PRO l_ZC3Proc, l_setup, l_setup_file, l_pltpos, l_rgb_table
COMMON GLOBALS, g_report, g_log
COMMON PLOTDEFS, max_plots, max_web_spins, no_cnts, no_data


   year      = strmid(systime(0), 20, 23)
   hdr_title = 'LENA Browse Product'
   max_web_spins = 50L

   ;-------------------------------------------------
   ; determine the user's desired start and stop time
   ;-------------------------------------------------
   ;l_ChckUserTime, l_setup

   ;print, 'MOD l_start_dtime = ', l_setup.l_start_dtime
   ;print, 'MOD l_stop_dtime = ', l_setup.l_stop_dtime


   ;----------------------------------------
   ; get binned setup
   ;----------------------------------------
   ; start of modification by RLVW
   l_BinnedReadSetup, l_plot_setup, l_setup_file

   l_BrowseProc, binndata, mass0_bd, mass1_bd, l_setup, l_pltpos, l_rgb_table, $
                 nrec, data_during_request, req_record_start, req_record_stop, $
                 req_actual_num_spins, req_spins, $
                 req_spin_start_rec, req_spin_stop_rec
   if (data_during_request eq -1) then return

   save_year = l_setup.l_start_dtime[0]
   save_doy = l_setup.l_start_dtime[1]
   save_hr = l_setup.l_start_dtime[2]
   save_min = l_setup.l_start_dtime[3]
   save_sec = l_setup.l_start_dtime[4]
   oa_start_year = l_setup.l_start_date[0]
   oa_start_time = ConvToUtc((*binndata.timePtr)[0], 2)
   reads, format="(i3,1x,i2,1x,i2,1x,i2)", oa_start_time, doy, hr, min, sec
   l_setup.l_start_dtime[0] = oa_start_year
   l_setup.l_start_dtime[1] = fix(doy)
   l_setup.l_start_dtime[2] = fix(hr)
   l_setup.l_start_dtime[3] = fix(min)
   l_setup.l_start_dtime[4] = fix(sec)


   status = l_OARead (l_oa, l_setup.l_start_dtime, $
                      l_setup.l_stop_dtime, l_pltpos)

   l_setup.l_start_dtime[0] = save_year
   l_setup.l_start_dtime[1] = save_doy
   l_setup.l_start_dtime[2] = save_hr
   l_setup.l_start_dtime[3] = save_min
   l_setup.l_start_dtime[4] = save_sec

   ;----------------------------------------
   ; generate a spectrogram plot
   ;----------------------------------------
   nrows = 3
   npages = CEIL(nrows / max_plots)

   if (nrows - max_plots gt 0) then npages = npages + 1
   if (npages eq 0) then npages = 1
   if (npages gt 0) then windx = intarr (npages)

   l_setup.l_plot_type = 'G'

   plotted = 0L
   pages   = 0L
   web     = l_setup.l_via_web
   nplots  = 3 

   l_BrowsePlot, nrec, (*binndata.timePtr)[*], $
                 mass0_bd, mass1_bd, $
                 l_oa, l_setup, l_pltpos, $
                 l_rgb_table, $
                 req_record_start, req_record_stop, $
                 req_actual_num_spins, req_spins, $
                 req_spin_start_rec, req_spin_stop_rec

   ;----------------------------------------
   ;----------------------------------------

   l_BinnedTerm, binndata
   l_OATerm, l_oa

   ;----------------------------------------
   ;----------------------------------------

RETURN
END
