
;-------------------------------------------------------------------------------
;
;  Unit Name : l_ZC1Rtns.pro
;
;  Purpose   : This file contains the routines for reading, writing, and
;              generating plots for set 1.  Set 1 contains the singles
;              start/stop data and selected housekeeping line plots.
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;   ELH                               v1.0           Original implementation
;   ELH               05/01           v1.0           Added l_AdjPlotSize 
;
;
;  File Revision Number:   %I%
;  File Last Modified  :   %E%  %T%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;  Procedure: l_ZC1DumpData
;
;  Description: Dumps all of the health and safety data to a text
;       file.
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  l_setup               struct        I        general setup parameters
;  l_pltpos              struct        I        general plotting parameters
;  l_sngls               struct *      I        pointers to singles data
;  l_sngls_setup         struct        i        singles processing & plotting parameters
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  l_LenaPlot.pro
;     PLOTDEFS         MAX_PLOTS        int         G         max # plots per page
;                      MAX_WEB_SPINS    int         G         max # spins per plot
;                                                             when using web interface
;                      NO_CNTS          double      G         no counts indicator
;                      NO_DATA          double      G         no data indicator
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH                               v1.0             Original implementation
;-------------------------------------------------------------------------------



PRO l_ZC1DumpData, l_setup, l_pltpos, l_sngls, l_sngls_setup, $
l_hskp, l_hskp_setup
COMMON PLOTDEFS, MAX_PLOTS, MAX_WEB_SPINS, NO_CNTS, NO_DATA

   ;-------------------------------
   ; create text dump filename
   ;-------------------------------
   l_setup.l_filedesc = 'hsk'
   l_GenFileName, l_setup, '0'
   filename = l_setup.l_prod_dst + '/' + $
              l_setup.l_filename + '.dmp'

   ;-------------------------------
   ; open text dump file
   ;-------------------------------
   openw, ofd, filename, /get_lun

   ;-------------------------------
   ; write standard header info
   ; to text file
   ;-------------------------------
   l_pltpos.dmp_hdr_title = 'Health & Safety Text Dump'
   l_DumpHdrInfo, ofd, l_setup, l_pltpos, filename

   printf, ofd, 'No Data Value   = ', NO_DATA
   printf, ofd, 'No Counts Value = ', NO_CNTS
   printf, ofd, ' '

   if (l_sngls_setup.start eq 'Y') then begin
      printf, ofd, ' '
      printf, ofd, '****************** Start Singles ******************'
      printf, ofd, 'Values = Raw Counts'
      printf, ofd, 'min = ', min (where((*l_sngls.startDmpPtr)[*] ge 0, wcnt))
      printf, ofd, 'max = ', max ((*l_sngls.startDmpPtr)[*])
      printf, ofd, ' '
      nitems = n_elements ((*l_sngls.startDmpPtr)[*])/45L

      if (l_setup.l_angle_zero eq 'S') then begin
          printf, ofd, ' '
          printf, ofd, 'Sun at 0 degrees.  Each spin sector pixel replicated by 8'
          printf, ofd, 'UTC', 'Spin Sectors (0...359)', $
                  format='((A10,TR4), (A22))'
          printf, ofd, '----------','----------------------', $
                  format='((A10,TR4), (A22))'
         str = 'printf, ofd, tmestr, (*l_sngls.startDmpPtr)[*,ii], format=''((A10,TR1),360(I8))''
      endif else begin
          printf, ofd, ' '
          printf, ofd, 'UTC', 'Spin Sectors (0...44)', $
                  format='((A10,TR4), (A22))'
          printf, ofd, '----------','----------------------', $
                  format='((A10,TR4), (A22))'
          str = 'printf, ofd, tmestr, (*l_sngls.startDmpPtr)[*,ii], format=''((A10,TR1),45(I8))''
      endelse

      for ii = 0, nitems - 1L do begin
          if (((*l_sngls.filledStartUdfTimePtr)[ii].hour ne 0L) AND $
              ((*l_sngls.filledStartUdfTimePtr)[ii].min  ne 0L) AND $
              ((*l_sngls.filledStartUdfTimePtr)[ii].sec  ne 0L)) then begin
              tmestr = STRING ((*l_sngls.filledStartUdfTimePtr)[ii].hour,$
                               (*l_sngls.filledStartUdfTimePtr)[ii].min, $
                               (*l_sngls.filledStartUdfTimePtr)[ii].sec, $
                               FORMAT="(i2.2,':',i2.2,':',i2.2)")
              result = execute (str)
          endif
      endfor
      printf, ofd, ' '
   endif


   if (l_sngls_setup.stop eq 'Y') then begin
      printf, ofd, '****************** Stop Singles ******************'
      printf, ofd, 'Values = Raw Counts'
      printf, ofd, 'min = ', min (where ((*l_sngls.stopDmpPtr)[*] ge 0))
      printf, ofd, 'max = ', max ((*l_sngls.stopDmpPtr)[*])
      printf, ofd, ' '
      nitems = n_elements ((*l_sngls.stopDmpPtr)[*])/45L

      if (l_setup.l_angle_zero eq 'S') then begin
          printf, ofd, ' '
          printf, ofd, 'Sun at 0 degrees.  Each spin sector pixel replicated by 8'
          printf, ofd, 'UTC', 'Spin Sectors (0...359)', $
                  format='((A10,TR4), (A22))'
          printf, ofd, '----------','----------------------', $
                  format='((A10,TR4), (A22))'
         str = 'printf, ofd, tmestr, (*l_sngls.stopDmpPtr)[*,ii], format=''((A10,TR1),360(I8))''
      endif else begin
          printf, ofd, ' '
          printf, ofd, 'UTC', 'Spin Sectors (0...44)', $
                  format='((A10,TR4), (A22))'
          printf, ofd, '----------','----------------------', $
                  format='((A10,TR4), (A22))'
          str = 'printf, ofd, tmestr, (*l_sngls.stopDmpPtr)[*,ii], format=''((A10,TR1),45(I8))''
      endelse

      for ii = 0, nitems - 1L do begin
          if (((*l_sngls.filledStartUdfTimePtr)[ii].hour ne 0L) AND $
              ((*l_sngls.filledStartUdfTimePtr)[ii].min  ne 0L) AND $
              ((*l_sngls.filledStartUdfTimePtr)[ii].sec  ne 0L)) then begin
              tmestr = STRING ((*l_sngls.filledStartUdfTimePtr)[ii].hour,$
                               (*l_sngls.filledStartUdfTimePtr)[ii].min, $
                               (*l_sngls.filledStartUdfTimePtr)[ii].sec, $
                               FORMAT="(i2.2,':',i2.2,':',i2.2)")
              result = execute (str)
          endif
      endfor
      printf, ofd, ' '
   endif


   if (l_hskp_setup.hvps_mcp_start_vmon eq 'Y') then begin
      printf, ofd, '****************** Hvps MCP Start Vmon ******************'
      nitems = n_elements ((*l_hskp.filled_hvps_vmonsPtr[0])) 

      printf, ofd, 'UTC', 'HVPS MCP Start Vmon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")
   
          printf, ofd, tmestr, (*l_hskp.filled_hvps_vmonsPtr[0])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.hvps_mcp_stop_vmon eq 'Y') then begin
      printf, ofd, '****************** Hvps MCP Stop Vmon ******************'
      nitems = n_elements ((*l_hskp.filled_hvps_vmonsPtr[1]))

      printf, ofd, 'UTC', 'HVPS MCP Stop Vmon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")
   
          printf, ofd, tmestr, (*l_hskp.filled_hvps_vmonsPtr[1])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.hvps_collp_vmon eq 'Y') then begin
      printf, ofd, '****************** Hvps CollP Vmon ******************'
      nitems = n_elements ((*l_hskp.filled_hvps_vmonsPtr[2]))

      printf, ofd, 'UTC', 'HVPS CollP Vmon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_hvps_vmonsPtr[2])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.hvps_colln_vmon eq 'Y') then begin
      printf, ofd, '****************** Hvps CollN Vmon ******************'
      nitems = n_elements ((*l_hskp.filled_hvps_vmonsPtr[3]))

      printf, ofd, 'UTC', 'HVPS CollN Vmon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

       printf, ofd, tmestr, (*l_hskp.filled_hvps_vmonsPtr[3])[ii], $
                    format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.hvps_optics_vmon eq 'Y') then begin
      printf, ofd, '****************** Hvps Optics Vmon ******************'
      nitems = n_elements ((*l_hskp.filled_hvps_vmonsPtr[4]))

      printf, ofd, 'UTC', 'HVPS Optics Vmon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_hvps_vmonsPtr[4])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.hvps_steering_vmon eq 'Y') then begin
      printf, ofd, '****************** Hvps Steering Vmon ******************'
      nitems = n_elements ((*l_hskp.filled_hvps_vmonsPtr[5]))

      printf, ofd, 'UTC', 'HVPS Steering Vmon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_hvps_vmonsPtr[5])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.hvps_mcp_start_imon eq 'Y') then begin
      printf, ofd, '****************** Hvps MCP Start Imon ******************'
      nitems = n_elements ((*l_hskp.filled_hvps_imonsPtr[0]))

      printf, ofd, 'UTC', 'HVPS MCP Start Imon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_hvps_imonsPtr[0])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.hvps_mcp_stop_imon eq 'Y') then begin
      printf, ofd, '****************** Hvps MCP Stop Imon ******************'
      nitems = n_elements ((*l_hskp.filled_hvps_imonsPtr[1]))

      printf, ofd, 'UTC', 'HVPS MCP Stop Imon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_hvps_imonsPtr[1])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.hvps_collp_imon eq 'Y') then begin
      printf, ofd, '****************** Hvps CollP Imon ******************'
      nitems = n_elements ((*l_hskp.filled_hvps_imonsPtr[2]))

      printf, ofd, 'UTC', 'HVPS CollP Imon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")
   
          printf, ofd, tmestr, (*l_hskp.filled_hvps_imonsPtr[2])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.hvps_colln_imon eq 'Y') then begin
      printf, ofd, '****************** Hvps CollN Imon ******************'
      nitems = n_elements ((*l_hskp.filled_hvps_imonsPtr[3]))

      printf, ofd, 'UTC', 'HVPS CollN Imon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_hvps_imonsPtr[3])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.hvps_optics_imon eq 'Y') then begin
      printf, ofd, '****************** Hvps Optics Imon ******************'
      nitems = n_elements ((*l_hskp.filled_hvps_imonsPtr[4]))

      printf, ofd, 'UTC', 'HVPS Optics Imon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")
   
          printf, ofd, tmestr, (*l_hskp.filled_hvps_imonsPtr[4])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.lvps_15vp_vmon eq 'Y') then begin
      printf, ofd, '****************** Lvps 15vp Vmon ******************'
      nitems = n_elements ((*l_hskp.filled_lvps_vmonsPtr[1]))

      printf, ofd, 'UTC', 'LVPS 15vp Vmon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_lvps_vmonsPtr[1])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.lvps_15vn_vmon eq 'Y') then begin
      printf, ofd, '****************** Lvps 15vn Vmon ******************'
      nitems = n_elements ((*l_hskp.filled_lvps_vmonsPtr[2]))

      printf, ofd, 'UTC', 'LVPS 15vn Vmon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_lvps_vmonsPtr[2])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.lvps_5vp_vmon eq 'Y') then begin
      printf, ofd, '****************** Lvps 5vp Vmon ******************'
      nitems = n_elements ((*l_hskp.filled_lvps_vmonsPtr[3]))

      printf, ofd, 'UTC', 'LVPS 5vp Vmon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_lvps_vmonsPtr[3])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.lvps_5vn_vmon eq 'Y') then begin
      printf, ofd, '****************** Lvps 5vn Vmon ******************'
      nitems = n_elements ((*l_hskp.filled_lvps_vmonsPtr[4]))

      printf, ofd, 'UTC', 'LVPS 5vn Vmon', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_lvps_vmonsPtr[4])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif


   if (l_hskp_setup.temp0 eq 'Y') then begin
      printf, ofd, '****************** Temperature 0 ******************'
      printf, ofd, 'Value = Celcius'
      printf, ofd, ' '
      nitems = n_elements ((*l_hskp.filled_temp_monsPtr[0]))

      printf, ofd, 'UTC', 'Temperature 0', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_temp_monsPtr[0])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif

   if (l_hskp_setup.temp1 eq 'Y') then begin
      printf, ofd, '****************** Temperature 1 ******************'
      printf, ofd, 'Value = Celcius'
      printf, ofd, ' '
      nitems = n_elements ((*l_hskp.filled_temp_monsPtr[1]))

      printf, ofd, 'UTC', 'Temperature 1', $
                   format='((A10,TR4), (A22))'
      printf, ofd, '----------','----------------------', $
                   format='((A10,TR4), (A22))'

      for ii = 0, nitems - 1L do begin
          tmestr = STRING ((*l_hskp.filledStartUdfTimePtr)[ii].hour,$
                           (*l_hskp.filledStartUdfTimePtr)[ii].min, $
                           (*l_hskp.filledStartUdfTimePtr)[ii].sec, $
                           FORMAT="(i2.2,':',i2.2,':',i2.2)")

          printf, ofd, tmestr, (*l_hskp.filled_temp_monsPtr[1])[ii], $
                       format='((A10, TR1), (I8.2))'
      endfor
      printf, ofd, ' '
   endif


   close, ofd
   free_lun, ofd

RETURN
END


;-------------------------------------------------------------------------------
;  FUNCTION : l_ZC1Proc
;
;  Description: The main procedure which calls the necessary
;      routines to generate the health and safety plots
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  l_setup               struct        I        generic setup parameters
;  l_setup_file          string        I        setup file name
;  l_rgb_table           struct        I        generic color table parameters
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  l_LenaPlot.pro
;     PLOTDEFS         MAX_PLOTS        int         G         max # plots per page
;                      MAX_WEB_SPINS    int         G         max # spins per plot
;                                                             when using web interface
;                      NO_CNTS          double      G         no counts indicator
;                      NO_DATA          double      G         no data indicator
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH                               v1.0             Original implementation
;-------------------------------------------------------------------------------

FUNCTION l_ZC1Proc, l_setup, l_setup_file, l_pltpos, l_rgb_table
COMMON PLOTDEFS, MAX_PLOTS, MAX_WEB_SPINS, NO_CNTS, NO_DATA
COMMON ERROR_TYPES, SUCCESS, FAILURE, WARNING, INFO


   l_pltpos.plot_hdr_title = '!5Health & Safety'
   l_pltpos.X_axis_eq_time = 'Y'

   ;-------------------------------------------------
   ; read the singles data setup file
   ;-------------------------------------------------

   status = l_OARead (l_oa, $ 
                      l_setup.l_start_dtime, $
                      l_setup.l_stop_dtime, $
                      l_pltpos)
   if (status eq FAILURE) then return, FAILURE


   l_SnglsReadSetup, l_sngls_setup, l_setup_file

   status = l_SnglsGetData (l_setup, $
                            l_setup_file, $
                            l_pltpos, $ 
                            l_sngls_setup, $
                            l_sngls)
   if (status eq FAILURE) then return, FAILURE

   l_SnglsAdjExData, l_sngls_setup, l_setup.l_num_spinsec, l_sngls
   l_SnglsHndlMissData, l_sngls_setup, l_sngls, l_setup, l_oa

   status = l_HskpGetData (l_setup, $
                           l_setup_file, $
                           l_pltpos, $
                           l_hskp_setup, $
                           l_hskp)
   if (status eq FAILURE) then return, FAILURE

   l_HskpHndlMissData, l_hskp_setup, l_hskp, l_setup, l_oa


   ;-------------------------------------------------------------
   ; Determine the number of pages necessary, a maximum of
   ; 6 plots plotted per page
   ;-------------------------------------------------------------

   nloops = 1L
   if (l_setup.l_postscript eq 'Y') then nloops = 2L

   for i = 0L, nloops-1L do begin
     nrows = l_sngls_setup.nplots + l_hskp_setup.nplots
     nplots = nrows
     npages = CEIL(nrows / MAX_PLOTS)

     if (nrows - MAX_PLOTS gt 0L) then npages = npages + 1L
     if (npages eq 0L) then npages = 1L
     if (npages gt 0L) then windx = intarr (npages)

     l_setup.l_filedesc = 'hsk'

     if (i eq 1L) and (l_setup.l_postscript eq 'Y') then begin
        l_pltpos.ps = 'Y'
        l_GenFileName, l_setup, '0'
        l_pltpos.filename = l_setup.l_prod_dst + '/' + $
                            l_setup.l_filename + '.ps'
     endif

     l_SetUpZBuffer, l_pltpos, $
                     l_setup, $
                     l_rgb_table, $
                     colorbar, $
                     nplots

     plotted = 0L
     pages   = 0L
     web     = l_setup.l_via_web

     l_AdjPlotSize, l_pltpos, l_setup, nplots

     l_setup.l_line_plots = 'Y'

     l_SnglsPlot, l_sngls_setup, $
                  l_sngls, $
                  l_pltpos, $
                  nrows, $
                  windx, $
                  pages, $
                  plotted, $
                  l_setup, $
                  l_oa , $
                  l_rgb_table, $
                  colorbar, $
                  l_hskp
  

     l_HskpPlot, l_hskp_setup, $
                 l_hskp, $
                 l_pltpos, $ 
                 nrows, $
                 windx, $
                 pages, $
                 plotted, $
                 l_setup, $
                 l_oa, $
                 l_rgb_table

     if (i eq 1) and (l_setup.l_postscript eq 'Y') then begin
         l_pltpos.ps = 'N'
         device, /close_file
     endif

     if (!D.NAME eq 'Z') then begin
       if (l_setup.l_via_web eq 'Y') or (l_setup.l_gen_sum eq 'Y') then begin
          device, /close
       endif
     endif

   endfor

   if (l_setup.l_dumps eq 'Y') then begin
      l_ZC1DumpData, l_setup, l_pltpos, l_sngls, l_sngls_setup, $
                     l_hskp, l_hskp_setup
   endif
   
   l_SnglsTerm, l_sngls
   l_HskpTerm, l_hskp
   l_OATerm, l_oa


   RETURN, SUCCESS

END
