
;-------------------------------------------------------------------------------
;
;  Unit Name : l_MagField_c2idl.pro
;
;  Purpose   : Code to interface the C and IDL code.
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;   ELH               02/02         v1.0.8           Original implementation
;
;
;  File Revision Number:   %I%
;  File Last Modified  :   %E%  %T%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;  Procedure: l_CallT96Model
;  Description:
;     Prepares the variables and data types needed for call to the fortran
;  T96 model.
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;   ELH               02/02         v1.0.8           Original implementation
;-------------------------------------------------------------------------------

PRO l_CallT96Model, l_oa, l_setup
COMMON C1, ST0,CT0,SL0,CL0,CTCL,STCL,CTSL,STSL,SFI,CFI,SPS,CPS, $
SHI,CHI,HI,PSI,XMUT,A11,A21,A31,A12,A22,A32,A13,A23,A33,DS3, $
K,IY,BA

   nspins = n_elements ((*l_oa.tme_ptr))
   mag_field_lines = fltarr(nspins, 3)
   parmod = fltarr(10)
   
   iopt = 0.0

   parmod[0] = 2.0      ;--- Pdyn ---
   parmod[1] = -20.0    ;--- Dst ---
   parmod[2] = 1.0      ;--- By IMF ---
   parmod[3] = -1.0     ;--- Bz IMF ---
   parmod[4] = 0.0
   parmod[5] = 0.0
   parmod[6] = 0.0
   parmod[7] = 0.0
   parmod[8] = 0.0
   parmod[9] = 0.0

   ps = 0.0

   ext_bx = 0.0
   ext_by = 0.0
   ext_bz = 0.0

   re = 6371.0

   for ii = 0L, nspins - 1L do begin

      x = FLOAT ((*l_oa.gsm_x_pos_ptr)[ii])/re
      y = FLOAT ((*l_oa.gsm_y_pos_ptr)[ii])/re
      z = FLOAT ((*l_oa.gsm_z_pos_ptr)[ii])/re

      time_array = ConvSec2Arr ((*l_oa.tme_ptr)[ii], l_setup.l_start_dtime[0])

      RECALC,time_array[0], $
             time_array[1], $
             time_array[2], $
             time_array[3], $
             time_array[4]

      ;-------------------------------------
      ; determine internal magnetic field
      ;-------------------------------------
      DIP, PSI, x, y, z, $ 
           int_bx, int_by, int_bz

      ps = FLOAT (PSI)

      status = CALL_EXTERNAL('t96lib.so', $
                             't96_c', $
                              iopt,  $
                              parmod, $
                              ps,  $
                              x, $
                              y, $
                              z, $
                              ext_bx, $
                              ext_by, $
                              ext_bz)


      mag_field_lines[ii, 0] = int_bx + ext_bx
      mag_field_lines[ii, 1] = int_by + ext_by
      mag_field_lines[ii, 2] = int_bz + ext_bz

   endfor


   if (ptr_valid (l_oa.mag_field)) then begin
      ptr_free, l_oa.mag_field
   endif

   ptr = ptr_new (mag_field_lines, /NO_COPY)
   l_oa.mag_field = ptr

 RETURN
END

