
;-------------------------------------------------------------------------------
;
;  Unit Name : l_GenRtns.pro
;
;  Purpose   : All generic routines related to generation of filenames or
;              plot files such as GIFS, PNGS, etc...
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;   ELH               06/00          v1.0            Original Implementation
;   ELH               05/01                          Added creation of absolute 
;                                                    path and filename
;
;  File Revision Number:   %I%
;  File Last Modified  :   %E%  %T%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;  Procedure : l_GenFileName.pro
;
;  Description:
;    Generate a filename.
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  l_setup               struct       I/O       generic setup parameters
;  sn2                   string        I        page number
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  None
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH               04/23/03       v1.0.11          Original implementation
;-------------------------------------------------------------------------------

PRO l_GenFileName, l_setup, sn2

   mo = 0
   dy = 0

   l_ConvDOY2YMD, l_setup.l_start_dtime[1], l_setup.l_start_dtime[0], mo, dy
   year = string(strcompress(l_setup.l_start_dtime[0], /REMOVE_ALL))
   yr = strmid(year, 2, 2)

   l_setup.l_filename = strcompress(('l' + $
                        string(format='(A2)', yr) +  $
                        string(format='(I2.2)',mo) + $
                        string(format='(I2.2)',dy) + $
                        string(format='(I2.2)',l_setup.l_start_dtime[2]) + $
                        string(format='(I2.2)',l_setup.l_start_dtime[3]) + $
                        string(format='(I2.2)',l_setup.l_stop_dtime[2])  + $
                        string(format='(I2.2)',l_setup.l_stop_dtime[3])  + '_' + $
                        string(l_setup.l_filedesc) + $
                        string(format='(I1)',sn2))+ $
                        l_setup.l_process_id, /REMOVE_ALL)


   l_setup.l_abspathfn = l_setup.l_prod_dst + '/' + l_setup.l_filename


RETURN
END 


;-------------------------------------------------------------------------------
;  Procedure :  l_GenGif.pro
;
;  Description: Generate a GIF file.
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  data                  IDL buffer    I        actual image data
;  l_setup               struct        I        generic setup parameters
;  l_rgb_table           struct        I        color table,options      
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  None
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH               04/23/03       v1.0.11          Original implementation
;-------------------------------------------------------------------------------

PRO l_GenGif, data, ii, l_setup, l_rgb_table


   gif_filename = l_setup.l_prod_dst + '/' + l_setup.l_filename+'.gif'

   r = l_rgb_table.red[0:225]
   g = l_rgb_table.green[0:225]
   b = l_rgb_table.blue[0:225]

   if (l_setup.l_via_web eq 'N') then begin
      image = Color_Quan (data, 1, r,g, b)
      write_gif, gif_filename, image, r, g, b
   endif else begin
      write_gif, gif_filename, data, r, g, b
   endelse



RETURN
END



;-------------------------------------------------------------------------------
;  Procedure : l_GenPng
;
;  Description: Generate a PNG file.
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  data                  IDL buffer    I        actual image data
;  l_setup               struct        I        generic setup parameters
;  l_rgb_table           struct        I        color table,options      
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  None
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH               04/23/03       v1.0.11          Original implementation
;-------------------------------------------------------------------------------
PRO l_GenPng, data, ii, l_setup, l_rgb_table


   sn1 = strcompress(strtrim(string(ii), 1))
   sn2 = string(format='(I4.4)', sn1)

   l_GenFileName, l_setup, sn2
   png_filename = l_setup.l_prod_dst + '/' +  l_setup.l_filename+'.png'

   write_png, png_filename, data, l_rgb_table.red[0:225], $
              l_rgb_table.green[0:225], l_rgb_table.blue[0:225]

RETURN
END
