;-------------------------------------------------------------------------------
;
;  Unit Name : l_BinnedConvUnit.pro
;
;  Purpose   : Conversion units for binned data ONLY.
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;   John Park      01/01/00        v1.0            Original implementation
;
;
;  File Revision Number:   %I%
;  File Last Modified  :   %E%  %T%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;  Function/Procedure: l_BinnedConv2CountRate
;
;  Description: Convert the binned data counts to count rate.
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;   l_setup              struct        I        general processing & plotting
;                                               parameters
;   l_plot_setup         struct        I        plot setup parameters
;   nrec                 int           I        number of binned data records
;   binndata             struct *      I/O      pointers to binned data structures 
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  l_LenaPlot.pro
;      GLOBALS         g_report         int         G         report file descriptor
;                      g_log            int         G         log file descriptor 
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  John Park         01/01/00        v1.0            Original implementation
;-------------------------------------------------------------------------------

PRO l_BinnedConv2CountRate, l_setup, l_plot_setup, nrec, binndata
COMMON GLOBALS, g_report, g_log


    nspins = n_elements ((*binndata.m0RawPtr))/(45 * 12 * 3)

    m0cnt = fltarr(l_setup.l_num_energylev, $
                   l_setup.l_num_polarzn,   $
                   l_setup.l_num_spinsec,   $
                   nspins)
    m1cnt = fltarr(l_setup.l_num_energylev, $
                   l_setup.l_num_polarzn,   $
                   l_setup.l_num_spinsec,   $
                   nspins)

    sec_per_sample = 120.0/45.0		; (num sec per spin) / (spin sector)

    m0cnt[*,*,*,*] = (*binndata.m0RawPtr)[*,*,*,*]/(1 * sec_per_sample)
    m1cnt[*,*,*,*] = (*binndata.m1RawPtr)[*,*,*,*]/(1 * sec_per_sample)

    ptr=ptr_new(m0cnt)
    binndata.m0CntPtr=ptr

    ptr=ptr_new(m1cnt)
    binndata.m1CntPtr=ptr

    RETURN
END

