#ifndef __UTIL_STR_H__
#define __UTIL_STR_H__

/* #define abs(a)    (((a) > 0) ? (a) : -(a)) */
#define NAME_SIZE 150         /* the size of the file name arrays             */

#include "ByteDefs.h" 

struct idf_data              /* the data structure filled by READ_DREC().     */
{
   u_ByTe_4 data_key;        /* key which uniquely identifies the project,    */
                             /* mission, experiment, instrument and virtual   */
                             /* instrument associated with the data returned  */
   ByTe_2 sensor;            /* sensor or matrix of data in structure         */
   ByTe_2 column;            /* matrix column of data in structure            */
   ByTe_2 byear;             /* year associated with the first data value     */
                             /* in the data sweep (start of accumulation)     */
   ByTe_2 bday;              /* day of year associated with first data value  */
                             /* in the data sweep (start of accumulation)     */
   ByTe_4 bmilli;            /* time (msec) associated with first data value  */
                             /* in the data sweep (start of accumulation)     */
   ByTe_4 bnano;             /* time (nanoseconds) associated with first data */
                             /* value in the data sweep(start of accumulation)*/
   ByTe_2 eyear;             /* year associated with the last data value      */
                             /* in the data sweep (end of accumulation)       */
   ByTe_2 eday;              /* day of year associated with last data value   */
                             /* in the data sweep (end of accumulation)       */
   ByTe_4 emilli;            /* time (msec) associated with last data value   */
                             /* in the data sweep (end of accumulation)       */
   ByTe_4 enano;             /* time (nanoseconds) associated with last data  */
                             /* value in the data sweep (end of accumulation) */
   ByTe_4 data_accum_ms;     /* time for a single data acquisition (in msec)  */
   ByTe_4 data_accum_ns;     /* time for a single data acquisition (in nsec)  */
   ByTe_4 data_lat_ms;       /* amount of dead time between successive data   */
                             /* acquisitions (in milliseconds)                */
   ByTe_4 data_lat_ns;       /* amount of dead time between successive data   */
                             /* acquisitions (in nanoseconds)                 */
   ByTe_4 swp_reset_ms;      /* amount of dead time at the end of an inst.    */
                             /* sweep (in milliseconds)                       */
   ByTe_4 swp_reset_ns;      /* amount of dead time at the end of an inst.    */
                             /* sweep (in nanoseconds)                        */
   ByTe_4 sen_reset_ms;      /* amount of dead time between successive sensor */
                             /* sets (in milliseconds)                        */
   ByTe_4 sen_reset_ns;      /* amount of dead time between successive sensor */
                             /* sets (in nanoseconds)                         */
   ReaL_4 *start_az;         /* ptr to 1st element in starting azimuthal array*/
   ReaL_4 *stop_az;          /* ptr to 1st element in ending azimuthal array  */
   ReaL_4 *start_theta;      /* starting theta angle for sensor in question   */
   ReaL_4 *stop_theta;       /* ending theta angle for sensor in question     */
   ReaL_4 *pitch_angles;     /* ptr to 1st element in pitch angles array      */
   ByTe_2 num_swp_steps;     /* no. of elements returned in sample sequence   */
                             /* array                                         */
   u_ByTe_2 num_sample;      /* no. of elements returned in sensor data array */
   ByTe_2 TotCols;           /* total columns of data (1 if non-matrix)       */
   ByTe_4 cal_len;           /* no. of elements returned in calibration array */
   u_ByTe_2 num_angle;       /* no. of elements returned in angle array       */
   u_ByTe_2 num_pitch;       /* no. of elements returned in pitch angle array */
   ByTe_4 sun_sen;           /* time of the last 0 degree crossing            */
   ByTe_4 spin_rate;         /* the spin rate of the virtual instrument       */
   ByTe_4 *cal_data;         /* ptr to first element in the calibration array */
   ByTe_4 *sen_data;         /* ptr to first element in the sensor array      */
   ByTe_4 *swp_data;         /* ptr to first element in sample sequence array */
   ByTe_4 *mode;             /* ptr to first element in the mode flags array  */
   ByTe_4 d_qual;            /* flag that indicates the quality of the data   */
   unsigned int cal_size;    /* no. of bytes allocated for calibration array  */
   unsigned int data_size;   /* no. of bytes allocated for sensor data array  */
   unsigned int swp_size;    /* no. of bytes allocated for sample sequence    */
                             /* array                                         */
   unsigned int mode_size;   /* no. of bytes allocated for mode flags array   */
   unsigned int angle_size;  /* no. of bytes allocated for angle array        */
   unsigned int pitch_size;  /* no. of bytes allocated for angle array        */
   void *base_cal;           /* base address of memory allocated for calibra- */
                             /* tion data                                     */
   void *base_data;          /* base address of memory allocated for sensor   */
                             /* data                                          */
   void *base_swp;           /* base address of memory allocated for sample   */
                             /* sequence data                                 */
   void *base_angle;         /* base address of memory allocated for angle    */
                             /* values                                        */
   void *base_mode;          /* base address of memory allocated for mode     */
                             /* values                                        */
   void *base_pitch;         /* base address of memory allocated for pitch    */
                             /* angle values                                  */
   u_ByTe_1 mode_len;        /* no. of elements returned in mode flags array  */
   ByTe_1 hdr_change;        /* flag that indicates a header change occurred  */
   ByTe_1 exten[3];          /* filename extension of the data files          */
   ByTe_1 filled_data;       /* flag indicating data array was filled         */
   u_ByTe_2 version;         /* version number for the requested data         */
   void *base_cset;          /* base address of memory allocated for cal. set */
                             /* lengths (needed by convert_to_units)          */
   u_ByTe_2 *cset_num;       /* no. of elements in each cal. set              */
};

struct alloc_experiment
{
   void *base_hdr;           /* base address of memory allocated for the info */
                             /* read from a header record                     */
   void *base_data;          /* base address of memory allocated for the info */
                             /* read from a data record                       */
   void *base_info_ptr;      /* base address of memory allocated to hold the  */
                             /* structure of pointers to the individual data  */
                             /* elements found in the header and data records */
   void *base_sen_ptr;       /* base address of memory allocated to hold the  */
                             /* sensor table information                      */
   void *base_mode_ptr;      /* base address of memory allocated to hold the  */
                             /* mode table information                        */
   void *base_tbl_index;     /* base address of memory allocated to hold index*/
                             /* into sensor table combo for each sensor       */
   void *base_constant;      /* base address of memory allocated to hold the  */
                             /* constant ID and values for each sensor        */
   void *base_pitch_info;    /* base address of memory for pitch angle struct */
};

struct vidf_info
{
   ByTe_1 version[9];
   void *vidf_data;
   ByTe_4 info_off;
   ByTe_4 offsets[72];
   void *tbl_offs;
   void *const_offs;
   ByTe_4 TABLES;
   ByTe_4 CONSTS;
};

struct experiment_info
{
   struct alloc_experiment bmem;       /* structure that holds base memory    */
                                       /* addresses for allocated memory      */
   struct ptr_rec *info_ptr;           /* structure of pointers to the various*/
                                       /* data elements from header and data  */
   struct sensor_tables *sen_tbl_ptr;  /* ptr to array of sensor table values */
   struct mode_tables *mode_tbl_ptr;   /* ptr to array of mode table values   */
   struct vidf_info VIDF_INFO;         /* information for read_idf routine    */
   struct pitch_info *pitch_angles;    /* ptr to information for pitch angles */
   int fdh;                            /* file descriptor for header file     */
   int fdd;                            /* file descriptor for data file       */
   int fdi;                            /* file descriptor for IDF file        */
   u_ByTe_4 inh;                       /* inode for header file               */
   u_ByTe_4 ind;                       /* inode for data file                 */
   u_ByTe_4 ini;                       /* inode for IDF file                  */
   u_ByTe_4 data_key;                  /* key which uniquely identifies the   */
                                       /* project, mission, experiment,       */
                                       /* instrument and virtual instrument   */
                                       /* being processed                     */
   ByTe_4 btime_sec;                   /* beginning time requested by user in */
                                       /* sec.(may be changed for real-time)  */
   ByTe_4 btime_nsec;                  /* beginning time requested by user in */
                                       /* nanosec.                            */
   ByTe_4 btime_ms;                    /* time (msec) of 1st data value in the*/
                                       /* data sweep (start of accumulation)  */
   ByTe_4 btime_ns;                    /* time (nanoseconds) of 1st data value*/
                                       /* in the data sweep                   */
   ByTe_4 etime_ms;                    /* time (msec) of last data value in   */
                                       /* the data sweep (end of accumulation)*/
   ByTe_4 etime_ns;                    /* time (nanoseconds) of last data     */
                                       /* value in the data sweep             */
   ByTe_4 accum_ss_ms;                 /* data record sensor set time accum   */
   ByTe_4 accum_ss_ns;                 /* data record sensor set time accum   */
   ByTe_4 next_offset;                 /* starting sensor set (tabular only)  */
   ByTe_4 initial_gap;                 /* the number of pixels to be bypassed */
                                       /* from the beginning of the plot for  */
                                       /* the very first data value           */
   ByTe_4 *time_off;                   /* offset time (msec) for each sensor  */
   ByTe_4 ds_msec;                     /* start msec for current idf file     */
   ByTe_4 de_msec;                     /* end time(msec) for current idf file */
   ByTe_4 fill_value;                  /* fill value defined in VIDF file     */
   ByTe_4 accum_ss_sz;                 /* accumulation of sensor set sizes    */
                                       /* in bits                             */
   ByTe_4 accum_ms;                    /* time for a single data acquisition  */
   ByTe_4 accum_ns;                    /* time for a single data acquisition  */
   ByTe_4 lat_ms;                      /* amt of dead time between successive */
                                       /* data acquisitions                   */
   ByTe_4 lat_ns;                      /* amt of dead time between successive */
                                       /* data acquisitions                   */
   ByTe_4 swp_ms;                      /* amt of dead time at the end of an   */
                                       /* inst. sweep                         */
   ByTe_4 swp_ns;                      /* amt of dead time at the end of an   */
                                       /* inst. sweep                         */
   ByTe_4 sen_ms;                      /* amt of dead time between successive */
                                       /* sensor sets                         */
   ByTe_4 sen_ns;                      /* amt of dead time between successive */
                                       /* sensor sets                         */
   ByTe_4 time_col_ms;                 /* time between adjacent data samples  */
                                       /* in the same matrix column           */
   ByTe_4 time_col_ns;                 /* time between adjacent data samples  */
                                       /* in the same matrix column           */
   ByTe_4 time_row_ms;                 /* time between adjacent data samples  */
                                       /* in the same matrix row              */
   ByTe_4 time_row_ns;                 /* time between adjacent data samples  */
                                       /* in the same matrix row              */
   ByTe_4 time_sm_ms;                  /* total time between acquisition of   */
                                       /* two consecutive data samples        */
   ByTe_4 time_sm_ns;                  /* total time between acquisition of   */
                                       /* two consecutive data samples        */
   ReaL_4 rec_time;                    /* time per data RECORD (tabular only) */
   ReaL_4 read_cnt;                    /* used to determine when to read data */
                                       /* (tabular only)                      */
   ReaL_4 *constants;                  /* constant values (one per sensor)    */
   ReaL_4 VIDFver;                     /* current VIDF version                */
   ByTe_2 ds_year;                     /* start year for current idf file     */
   ByTe_2 ds_day;                      /* start day for current idf file      */
   ByTe_2 de_year;                     /* end year for current idf file       */
   ByTe_2 de_day;                      /* end day for current idf file        */
   ByTe_2 num_of_plots;                /* the number of plots utilizing this  */
                                       /* exper/virtual/extension combination */
   ByTe_2 swp_len;                     /* no. of elements in full sample seq. */
   ByTe_2 *CAL_USE;                    /* cal. table usage definitions        */
   u_ByTe_2 *CSET_NUM;                 /* no. of elements in each cal. set    */
   u_ByTe_2 num_sample;                /* no. of data elements returned       */
   ByTe_2 num_sensor;                  /* total no. of sensor definitions     */
   ByTe_2 num_sen_used;                /* the number of sensors being utilized*/
   ByTe_2 num_combo;                   /* number of sensor tbl combinations   */
   ByTe_2 *index_sen_tbl;              /* indexes that indicate which sensor  */
                                       /* tables combo each sensor utilizes   */
                                       /* (-1 means sensor not plotted)       */
   ByTe_2 max_nss;                     /* maximum number of sensor sets       */
   ByTe_2 btime_year;                  /* beginning year requested by user    */
   ByTe_2 btime_day;                   /* beginning day requested by user     */
   u_ByTe_2 version;                   /* version number for the combo (used  */
                                       /* to facilitate multiple opens)       */
   u_ByTe_2 pa_version;                /* version number for pitch angles     */
   ByTe_1 header_name[NAME_SIZE];      /* the name of the header file opened  */
   ByTe_1 data_name[NAME_SIZE];        /* the name of the data file opened    */
   ByTe_1 idf_name[NAME_SIZE];         /* the name of the IDF file opened     */
   ByTe_1 exten[3];                    /* filename extension of the data files*/
   ByTe_1 fnext;                       /* flag that indicates if start time   */
                                       /* file alignment has been done        */
   ByTe_1 first_open;                  /* flag that indicates if the files    */
                                       /* opened are the 1st files opened for */
                                       /* this exper/virtual/exten combo.     */
   ByTe_1 fill_flag;                   /* flag indicating if a fill value is  */
                                       /* defined by the VIDF                 */
   ByTe_1 num_tbls;                    /* the number of tables defined        */
   ByTe_1 num_consts;                  /* the number of constants defined     */
   ByTe_1 tdw_len;                     /* maximum data word length of all sen */
   ByTe_1 AncPBytes;                   /* bytes per preface anc               */
   ByTe_1 AncGBytes;                   /* bytes per general anc               */
   ByTe_1 AncSBytes;                   /* bytes per sensor anc                */
   ByTe_1 AncSBits;                    /* bits per sensor anc                 */
   ByTe_1 *sen_tdw_len;                /* array of data word lengths (bits),  */
                                       /* one per sensor                      */
   ByTe_1 *sen_status;                 /* sensor status flags - one per sensor*/
   ByTe_1 cal_sets;                    /* no. of calibration sets             */
   ByTe_1 *cal_wlen;                   /* word length of cal. data (bits)     */
   ByTe_1 smp_id;                      /* instrument sweep identifier         */
   ByTe_1 *d_type;                     /* data format - one per sensor        */
   ByTe_1 sen_mode;                    /* data matrix format                  */
   ByTe_1 TRC;                         /* indicates if time advances aByTe_4  */
                                       /* matrix rows or matrix columns       */
   ByTe_1 TRP;                         /* indicates if rows are sequential or */
                                       /* parallel (timing)                   */
   ByTe_1 TCP;                         /* indicates if columns are sequential */
                                       /* or parallel (timing)                */
   ByTe_1 *HEADER_MEM;                 /* ptr to the memory into which header */
                                       /* record information is read          */
   ByTe_1 *DATA_MEM;                   /* ptr to the memory into which data   */
                                       /* record information is read          */
   ByTe_1 first_select;                /* flag that indicates if this sensor  */
                                       /* is the first sensor selected        */
                                       /* (called SELECT_SENSOR())            */
   ByTe_1 los;                         /* flag that indicates LOS scenario    */
   ByTe_1 BswaP;                       /* BYTE ORDER switch flag              */
   ByTe_1 *sensors_needed;             /* indicates which sensors are needed  */
                                       /* for plotting requested parameters   */
   ByTe_1 drec_eof;                    /* flag that indicates if read_drec    */
                                       /* hit an eof scenario (partial file)  */
   ByTe_1 hrec_eof;                    /* flag that indicates if a fill header*/
                                       /* was read (header not yet received)  */
   ByTe_1 da_method;                   /* data accumulation code              */
   ByTe_1 *tbl_type;                   /* TBL_TYPE values for each table      */
   ByTe_1 *tbl_var;                    /* TBL_VAR values for each table       */
   ByTe_1 *tbl_expand;                 /* TBL_EXPAND values for each table    */
   ByTe_1 *cal_target;                 /* array that holds the target of the  */
                                       /* calibration sets                    */
   ByTe_1 DswaP;                       /* current sen set needs swap flat     */
                                       /* currently utilizing                 */
   ByTe_1 cal_mod_swp;                 /* flag indicating there is a cal. set */
                                       /* that modifies sweep data            */
   ByTe_1 all_or_one;                  /* flag to check pixel loc for times   */
   ByTe_1 crit_action;                 /* indicates the no. of crit. act. tbls*/
   ByTe_1 num_modes;                   /* no. of modes defined                */
   ByTe_1 pa_def;                      /* pitch angle defined? 1 = yes 0 = no */
   ByTe_1 scf_tie;                     /* flag if SCF definition, 1 = yes     */
};

struct general_info
{
   ByTe_2 nds;                         /* no. of experiment_info structures   */
                                       /* allocated                           */
   ByTe_2 pos_ex;                      /* index indicating which experiment_  */
                                       /* info structure is being utilized    */
   struct experiment_info *exbase;     /* ptr to memory allocated for all     */
                                       /* experiment_info structures (word    */
                                       /* aligned)                            */
   struct experiment_info *expt;       /* ptr to the current experiment_info  */
                                       /* structure being utilized            */
   unsigned int sexper;                /* no. of bytes allocated for all      */
                                       /* experiment_info structures          */
   void *mexper;                       /* base address of memory allocated for*/
                                       /* all experiment_info structures      */
   ByTe_1 called_locate;               /* flag set if LOCATE_EX was called    */
   u_ByTe_2 next_version;              /* the next available version number   */
   void **idf_data_ptr;                /* array of addresses for allocated    */
                                       /* idf_data structures                 */
   int num_idf_data_ptr;               /* no. of allocated idf_data structures*/
};

struct ptr_rec
{
  ByTe_4         d_size;             /* size in bytes of the data record      */
  ByTe_2         h_size;             /* size in bytes of the header record    */
  ByTe_2         *YEAR;              /* year associated with header           */
  ByTe_2         *DAYOFYEAR;         /* julian day associated with header     */
  ByTe_1         *TIME_UNITS;        /* scale factor for time base            */
  u_ByTe_1       *I_MODE;            /* number of instrument mode flags       */
  ByTe_4         *DATA_ACCUM;        /* time for a single acquisition         */
  ByTe_4         *DATA_LAT;          /* dead time between two acquisitions    */
  ByTe_4         *SWP_RESET;         /* dead time at end of instrument sweep  */
  ByTe_4         *SEN_RESET;         /* dead time between sensor sets         */
  ByTe_2         *N_SEN;             /* number of sensors in a sensor set     */
  u_ByTe_2       *N_SAMPLE;          /* number of samples for a sensor        */
  u_ByTe_2       *N_COLS;            /* number of matrix columns              */
  u_ByTe_2       *LEAD_COL;          /* column number of first column         */
  u_ByTe_2       *TOT_COLS;          /* total columns in the matrix           */
  ByTe_2         *SAMP_INDEX;        /* offsets used to create (read) sample  */
                                     /* sequence values                       */
  ByTe_2         *SENSOR_INDEX;      /* array that indicates which sensors    */
                                     /* are being returned and in what order  */
  u_ByTe_1       *DQUAL;             /* offset into data quality definition   */
                                     /* array found in IDF file               */
  u_ByTe_1       *MODE_INDEX;        /* array of instrument mode flags        */
  ByTe_4         *TIME;              /* beginning time of first element in    */
                                     /* the data matrix in the data record    */
  ByTe_4         *SPIN;              /* rotation rate of virtual instrument   */
  ByTe_4         *SUN_SEN;           /* time of last 0 degree crossing        */
  ByTe_4         *HDR_OFF;           /* offsets into the header file for each */
                                     /* sensor set found in the data record   */
  ByTe_4         *NSS;               /* number of sensor sets found in the    */
                                     /* current data matrix                   */
  u_ByTe_1       *DATA;              /* ptr to the sensor set data            */
  u_ByTe_1       *CAL_GENERAL;       /* ptr to the general calibration data   */
  u_ByTe_1       *CAL_SENSOR;        /* ptr to the sensor calibration data    */
  u_ByTe_1       *CAL_PREFACE;       /* ptr to the preface calibration data   */
  ByTe_1         reset_hdr;          /* tells if a new header has been read   */
  ByTe_1         chg_sen_set;        /* flag indicating if a sensor set was   */
                                     /* previously crossed                    */
  ByTe_4         prev_hd;            /* offset to the previous header record  */
  ByTe_2         cur_sen_set;        /* the current sensor set being processed*/
  ByTe_4         time_row;           /* the matrix row being processed        */
  ByTe_2         time_col;           /* the matrix column being processed     */
  ByTe_4         NumSenAnc;          /* no. of sensor ancillary elements      */
  ByTe_4         NumGenAnc;          /* no. of general calibration elements   */
  ByTe_4         NumPreAnc;          /* no. of preface calibration elements   */
                                     /* cal. data for the sensor data         */
};

struct sensor_tables
{
   ReaL_4 *tbls;                     /* the tables                            */
   ReaL_4 **tbl_ptr;                 /* an array of pointers to each of the   */
                                     /* tables defined                        */
   ByTe_4 *tbl_size;                 /* an array of sizes for tables          */
   ByTe_1 *tbl_expand;               /* an array of flags that indicate if the*/
                                     /* table is expanded or has poly coeff.  */
   ByTe_1 *tbl_var;                  /* an array that indicates the functional*/
                                     /* dependence of the table               */
   ByTe_1 *tbl_fmt;                  /* an array that indicates the format of */
                                     /* the table                             */
   ByTe_1 num_tbls;                  /* the number of integer tables          */
   void *base_tbls;                  /* base address of memory allocated for  */
                                     /* the integer tables defined in VIDF    */
   void *base_misc_tbls;             /* base address of memory allocated for  */
                                     /* misc. info. for integer tables        */
   ByTe_1 max_tdw_len;               /* the largest TDW_LEN value of all the  */
                                     /* sensors that use the same table combo.*/
   struct crit_action_info *act_ptr; /* ptr to array of sensor table values */
   void *base_crit_action;           /* base address of memory allocated for  */
                                     /* the critical action structures (1 per */
                                     /* table)                                */
};

struct mode_tables
{
   ReaL_4 *tbls;                     /* the tables                            */
   ReaL_4 **tbl_ptr;                 /* an array of pointers to each of the   */
                                     /* tables defined                        */
   ByTe_4 *tbl_size;                 /* an array of sizes for tables          */
   ByTe_1 *tbl_expand;               /* an array of flags that indicate if the*/
                                     /* table is expanded or has poly coeff.  */
   ByTe_1 *tbl_var;                  /* an array that indicates the functional*/
                                     /* dependence of the table               */
   ByTe_1 *tbl_fmt;                  /* an array that indicates the format of */
                                     /* the table                             */
   ByTe_1 *tbl_num;                  /* an array that holds the table number  */
   ByTe_1 num_tbls;                  /* the number of mode tables             */
   void *base_tbls;                  /* base address of memory allocated for  */
                                     /* the mode tables defined in VIDF       */
   void *base_misc_tbls;             /* base address of memory allocated for  */
                                     /* misc. info. for mode tables           */
};

struct pitch_times
{
   ByTe_2 byear;              /* from read_drec call for 1st pitch component */
   ByTe_2 bday;               /* from read_drec call for 1st pitch component */
   ByTe_4 bmilli;             /* from read_drec call for 1st pitch component */
   ByTe_4 bnano;              /* from read_drec call for 1st pitch component */
   ByTe_2 eyear;              /* from read_drec call for 1st pitch component */
   ByTe_2 eday;               /* from read_drec call for 1st pitch component */
   ByTe_4 emilli;             /* from read_drec call for 1st pitch component */
   ByTe_4 enano;              /* from read_drec call for 1st pitch component */
};

struct pitch_info
{
   struct pitch_times ptimes; /* structure that holds time for current sample*/
   ReaL_8 *data_val;         /* data values for bx, by and bz for whole sweep*/
   ReaL_8 *unit_normals;     /* unit normals to the detector apertures       */
   ReaL_8 *mag_normal;       /* the magnitude of the unit normal             */
   ReaL_4 *time_frac;        /* normalization for bx, by and bz for sweep    */
   u_ByTe_4 data_key;        /* key for the data source for the pitch angles */
   u_ByTe_2 version;         /* version number for the requested data        */
   ByTe_4 *btime_ms;         /* milliseconds start time of each sample       */
   ByTe_4 *etime_ms;         /* milliseconds end time of each sample         */
   ByTe_4 stop_milli;        /* end time used for parent in FILE_OPEN call   */
   ByTe_4 stop_nano;         /* end time used for parent in FILE_OPEN call   */
   ByTe_2 stop_year;         /* end time used for parent in FILE_OPEN call   */
   ByTe_2 stop_day;          /* end time used for parent in FILE_OPEN call   */
   ByTe_2 sensor[3];         /* sensor numbers for bx, by and bz             */
   ByTe_2 pa_format;         /* format for algorithm                         */
   ByTe_2 file_status;       /* status from call to FILE_SETUP for pa IDFS   */
   ByTe_2 *tbl_oper;         /* the table operators to apply                 */
   void *idf_data_ptr[3];    /* ptr to the idf_data structure for each sensor*/
   void *base_tbls;          /* ptr to memory for table information          */
   void *base_time;          /* ptr to time values                           */
   ByTe_1 *tbl_apply;        /* the tables to apply                          */
   void *base_normal;        /* ptr to memory for unit normal information    */
   void *base_data;          /* ptr to memory for data and normalization     */
   ByTe_1 num_tbls;          /* the number of tables to convert to units     */
   ByTe_1 next_data[3];      /* flag indicating if data needs to be read     */
   ByTe_1 all_done[3];       /* processing flag for current sample           */
   ByTe_1 exten[3];          /* filename extension of the data files         */
   ByTe_1 get_pa_data;       /* flag indicating if pitch angle data is to be */
                             /* retrieved                                    */
};

struct def_oper
{
  void (*_math_drv) (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4,
                     ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
};

struct crit_action_info
{
   ByTe_4 *crit_action;              /* ptr to 1st element in the critical   */
                                     /* status action array                  */
   ByTe_4 crit_offset;               /* offset into critical status table    */
   ByTe_2 crit_flag;                 /* holds the current contents of the    */
                                     /* critical status byte                 */
   ByTe_1 crit_status;               /* sensor critical status byte          */
   ByTe_1 crit_tbl;                  /* the table that has a critical action */
   void *base_action;                /* base address of memory allocated for */
                                     /* the critical status action array     */
};

struct MatrixData {
  void   *Data;                      /* data matrix                          */
  void   *Alg;                       /* algorithm data                       */
  ByTe_2 NAS;                        /* number of algorithm steps            */
  ByTe_1 *Tbls;                      /* pointer to the table array           */
  ByTe_2 *Ops;                       /* pointer to the ops array             */
  ByTe_4 Sz;                         /* malloced byte size of *Data          */
  ByTe_4 TCols;                      /* number of matrix columns             */
  ByTe_4 TRows;                      /* number of matrix rows                */
  ByTe_2 BYr;
  ByTe_2 BDy;
  ByTe_4 BMs;
  ByTe_4 BNs;
  ByTe_2 EYr;
  ByTe_2 EDy;
  ByTe_4 EMs;
  ByTe_4 ENs;
};

#endif
