/* guard against multiple inclusion */
#ifndef __USER_DEFS_H
#define __USER_DEFS_H

#define SENSOR 1
#define SCAN_INDEX 2
#define ANCILLARY 3
#define MODE 4
#define D_QUAL 5
#define PITCH_ANGLE 6
#define START_AZ_ANGLE 7
#define STOP_AZ_ANGLE 8
#define DSENSOR -1
#define DSCAN_INDEX -2
#define DANCILLARY -3
#define DMODE -4

#define OUTSIDE_MIN -3.4e38
#define OUTSIDE_MAX 3.4e38
#define VALID_MIN -3.0e38
#define VALID_MAX 3.0e38

#define UNTOUCHED_BUFFER -2
#define FREE_BUFFER -1
#define PARTIAL_WORKING 0
#define BUFFER_READY 1

#define NUM_BUFFERS 5
#define LEADING_EDGE 1
#define TRAILING_EDGE 0

#define MASS_DIMEN 1
#define PHI_DIMEN 2
#define THETA_DIMEN 3
#define SCAN_DIMEN 4
#define DATA_DIMEN 5
#define NO_DIMEN 6
#define CHARGE_DIMEN 7

#define NO_AVG 1
#define STRAIGHT_AVG 2
#define STRAIGHT_INT 3
#define SPHERICAL_INT 4
#define STRAIGHT_AVG_AZ 5

#define POINT_INT 1
#define BAND_INT 2

#define FIXED_SWEEP 1
#define VARIABLE_SWEEP 2

#define ZERO_SPACING 0
#define LIN_SPACING 1
#define LOG_SPACING 2
#define VARIABLE_SPACING 3

#define POINT_STORAGE 1
#define BAND_STORAGE 2

#define NO_BIN_FILL 1
#define LIN_ROW_COL 2
#define LIN_COL_ROW 3
#define CON_ROW_COL 4
#define CON_COL_ROW 5
#define LEAST_SQ_FIT 6

#define VIDF_FROM_MEMORY 0
#define VIDF_FROM_DISC 1

#define TORAD  0.017453292519943

#define PA_NOT_APPLICABLE 0
#define PA_READY 1
#define PA_DB_ERROR 2
#define PA_DATA_MISSING 3
#define PA_IR_ERROR 4

#endif
