/*
 * @(#)StrHier.h   1.3 93/01/29 SwRI
 * 
 * StrHier.h -- interface to string hierarchies
 */

#ifndef STR_HIER_H
#define STR_HIER_H
#include <stdio.h>
#include "Destroy.h"
#include "LinkList.h"

/**
 ** types
 **/

typedef struct StrHier_s
{
   DestroyObj_t *Destroy;

   ByTe_1         *str;        /* allocated string */
   int          number;
   struct StrHier_s *parent; /* pointer to previous StrHier_s in tree */
   LinkList     sublist;     /* more LinkLists to more StrHier */
   void         *info;       /* a place to store stuff*/
   LinkList     (*GetNextItems)(struct StrHier_s *S);

}  StrHierNode, *StrHier;

typedef void (*StrHierFun)(StrHier);

/**
 ** functions
 **/

StrHier StrHierCreateNodes( int n );
void DestroyStrHier( void *V );


/**********/
/* macros */
/**********/

#define StrHierOnList(list) ((StrHier)LinkData(list))
#define StrHierName(s) ((s)->str)
#define StrHierVal(s) ((s)->number)
#define StrHierChildren(s) ((s)->sublist)
#define StrHierParent(s) ((s)->parent)
#define StrHierInfo(s) ((s)->info)

#define SNAME(s) ((s)->str)
#define SNUM(s) ((s)->number)
#define SUBLIST(s) ((s)->sublist)
#define SUBINFO(s) ((s)->info)

#endif
