#ifndef __LIBBASE_IDFS_H
#define __LIBBASE_IDFS_H

#include <stdlib.h>
#include "util_str.h"
#include "ByteDefs.h"

/* declarations for libbase_udf */

#if defined(__cplusplus)
extern "C" {
#endif

/*****************************************************************************/
void   adjust_time (ByTe_2 *, ByTe_2 *, ByTe_4 *, ByTe_1);
/*****************************************************************************/
ByTe_2 BuildBins (ByTe_4, ByTe_4, ByTe_4, ByTe_4, ByTe_2);
/*****************************************************************************/
void   ir_advance_time_pointers (ByTe_1);
/*****************************************************************************/
ByTe_2 ir_alloc_exp_once (void *);
/*****************************************************************************/
ByTe_2  ir_alloc_swp_data (u_ByTe_2, void *);
/*****************************************************************************/
ByTe_2 ir_assign_pointers (ByTe_1, ByTe_1, void *);
/*****************************************************************************/
ByTe_2 BuildImage (u_ByTe_4, ByTe_1 *, u_ByTe_2, void *, 
                   struct MatrixData *, ByTe_1);
/*****************************************************************************/
ByTe_2 BuildMatrix (u_ByTe_4, ByTe_1 *, u_ByTe_2, void *, ByTe_2, 
                    ByTe_1, struct MatrixData *);
/*****************************************************************************/
ByTe_2 ir_check_cal_size (void *);
/*****************************************************************************/
ByTe_2 ir_check_critical_status (void);
/*****************************************************************************/
ByTe_2 ir_check_dependent_on_header (void *);
/*****************************************************************************/
ByTe_2 ir_check_idf_data_memory (u_ByTe_4, ByTe_1 *, u_ByTe_2, void *);
/*****************************************************************************/
void   CombineOp (ReaL_8 *, ReaL_8 *, ByTe_4, ByTe_2);
/*****************************************************************************/
void   ir_combine_add (ReaL_4 *, ReaL_4 *, ByTe_4);
/*****************************************************************************/
void   ir_combine_divide (ReaL_4 *, ReaL_4 *, ByTe_4);
/*****************************************************************************/
void   ir_combine_multiply (ReaL_4 *, ReaL_4 *, ByTe_4);
/*****************************************************************************/
void   ir_combine_subtract (ReaL_4 *, ReaL_4 *, ByTe_4);
/*****************************************************************************/
ByTe_2 ir_convert_cal_data (ByTe_1, ByTe_1, ByTe_1 *, ByTe_2 *, 
                            ReaL_4 *, ByTe_1, ByTe_1, ByTe_4, void *);
/*****************************************************************************/
ByTe_2 ir_convert_mode_data (ByTe_1, ByTe_1, ByTe_1 *, ByTe_2 *, ReaL_4 *, 
                             ByTe_1, void *);
/*****************************************************************************/
ByTe_2 ir_convert_sensor_data (ByTe_1, ByTe_1 *, ByTe_2 *, ReaL_4 *, 
                               ByTe_1, ByTe_1, ByTe_4, void *);
/*****************************************************************************/
ByTe_2 ir_convert_sweep_data (ByTe_1, ByTe_1 *, ByTe_2 *, ReaL_4 *, 
                              ByTe_1, void *);
/*****************************************************************************/
ByTe_2 convert_to_units (u_ByTe_4, ByTe_1 *, u_ByTe_2, void *, ByTe_1, 
                         ByTe_1, ByTe_1, ByTe_1 *, ByTe_2 *, ReaL_4 *, ByTe_1, 
                         ByTe_4);
/*****************************************************************************/
ByTe_2 ir_count_combo (ByTe_1 *, ByTe_1 *, ByTe_4 *, ByTe_1 *);
/*****************************************************************************/
ByTe_2 CreateMatStruc (struct MatrixData *, ByTe_2, ByTe_1 *, ByTe_2 *);
/*****************************************************************************/
ByTe_2 create_idf_data_structure (void **);
/*****************************************************************************/
ByTe_2 ir_create_tbl (ByTe_2, ReaL_4 *, ByTe_4, ByTe_1, ByTe_2, ByTe_1, ByTe_4);
/*****************************************************************************/
ByTe_2 ir_create_rval (ByTe_4);
/*****************************************************************************/
void   fields_to_key (ByTe_2 *, u_ByTe_4 *);
/*****************************************************************************/
ByTe_2 FileLength( ByTe_1 *, ByTe_4 *);
/*****************************************************************************/
ByTe_2 file_open (u_ByTe_4, ByTe_1 *, u_ByTe_2, ByTe_2, ByTe_2, ByTe_4, 
                  ByTe_4, ByTe_2, ByTe_2, ByTe_4, ByTe_4, ByTe_1);
/*****************************************************************************/
ByTe_2 file_pos (u_ByTe_4, ByTe_1 *, u_ByTe_2, void *, ByTe_2, ByTe_2, 
                 ByTe_4, ByTe_4, ByTe_2, ByTe_2, ByTe_4, ByTe_4);
/*****************************************************************************/
ByTe_2 FilePosRec (u_ByTe_4, ByTe_1 *, u_ByTe_2, void *, ByTe_2, ByTe_2, 
                 ByTe_4, ByTe_4, ByTe_2, ByTe_2, ByTe_4, ByTe_4);
/*****************************************************************************/
void   ir_fill_angle_array (ByTe_1, void *);
/*****************************************************************************/
void   ir_fill_cal_array_bit (ByTe_4, void *);
/*****************************************************************************/
void   ir_fill_cal_array_byte (ByTe_4, void *);
/*****************************************************************************/
void   ir_fill_data_array (ByTe_4, ByTe_1, void *);
/*****************************************************************************/
ByTe_2 ir_fine_search (u_ByTe_4, ByTe_1 *, u_ByTe_2, void *, ByTe_2, ByTe_2, 
                       ByTe_4, ByTe_4);
/*****************************************************************************/
ByTe_2 ir_fix_pointers (void *);
/*****************************************************************************/
void   free_experiment_info (void);
/*****************************************************************************/
void   ir_free_ex_structure (struct experiment_info *);
/*****************************************************************************/
void   ir_free_idf_data_ptr (void *);
/*****************************************************************************/
void   free_version_info (u_ByTe_2);
/*****************************************************************************/
void   ir_free_vidf_structure (struct experiment_info *);
/*****************************************************************************/
void  FreeTblSen (struct experiment_info *);
/*****************************************************************************/
ByTe_2 ir_get_constants (void);
/*****************************************************************************/
ByTe_2 ir_get_const_rval (ByTe_4);
/*****************************************************************************/
ByTe_2 ir_get_critical_info (ByTe_2, ByTe_2, ByTe_1, ByTe_2);
/*****************************************************************************/
ByTe_2 ir_get_crit_rval (ByTe_4);
/*****************************************************************************/
ByTe_2 get_data_key (ByTe_1 *, ByTe_1 *, ByTe_1 *, ByTe_1 *, ByTe_1 *, 
                     u_ByTe_4 *);
/*****************************************************************************/
ByTe_2 ir_get_mode_info (void);
/*****************************************************************************/
ByTe_2 ir_get_mode_tbl (ByTe_2);
/*****************************************************************************/
ByTe_2 ir_get_new_tbl (ByTe_2, ByTe_2, ByTe_1, ByTe_1, ReaL_4 *, ByTe_4, 
                       ByTe_4);
/*****************************************************************************/
ByTe_2 ir_get_new_rval (ByTe_4);
/*****************************************************************************/
ByTe_2 ir_get_sensor_tables (ByTe_1 *, ByTe_1 *, ByTe_4 *, ByTe_1 *);
/*****************************************************************************/
ByTe_2 ir_get_tbl_info (ByTe_2, ByTe_2);
/*****************************************************************************/
void   get_version_number (u_ByTe_2 *);
/*****************************************************************************/
void   ir_idf_add (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                   ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_and (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                   ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_divide (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                      ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_ex_func (ByTe_2, ReaL_8 *, ByTe_4, void *);
/*****************************************************************************/
void   ir_idf_exor (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                    ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_inv (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                   ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_look_up (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                       ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_mod (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                   ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_multiply (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                       ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_or (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                  ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_shiftl (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                     ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_shiftr (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                     ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_subtract (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                       ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_idf_power (ReaL_8 *, ByTe_1 *, ByTe_4, ReaL_4 *, ByTe_4, ByTe_4, 
                    ByTe_1, ByTe_1, ByTe_4, ByTe_1, ByTe_1, void *, ByTe_2);
/*****************************************************************************/
void   ir_init_experiment_info (ByTe_2);
/*****************************************************************************/
void   init_udf (void);
/*****************************************************************************/
ByTe_2 ir_init_sensor_ptr (ByTe_2, ByTe_1 *, ByTe_1, ByTe_1 *);
/*****************************************************************************/
void   ir_init_struct (void);
/*****************************************************************************/
ByTe_4 init_vidf (u_ByTe_4, ByTe_1 *, u_ByTe_2, ByTe_1);
/*****************************************************************************/
ReaL_8 ir_intfp2fp (u_ByTe_4, ByTe_1);
/*****************************************************************************/
void   key_to_fields (u_ByTe_4, ByTe_2 *);
/*****************************************************************************/
ReaL_8 RawToFloat (ByTe_4 *, ByTe_1);
/*****************************************************************************/
ReaL_8 ir_tento (ByTe_1);
/*****************************************************************************/
ByTe_2 ir_locate_ex (u_ByTe_4, ByTe_1 *, u_ByTe_2, ByTe_1);
/*****************************************************************************/
ByTe_2 ir_mode_tbl_size (ByTe_2, size_t *);
/*****************************************************************************/
ByTe_2 ir_mode_tbl_size_rval (ByTe_4);
/*****************************************************************************/
ByTe_2 ir_new_data_record (ByTe_1);
/*****************************************************************************/
ByTe_2 ir_new_header_record (ByTe_1, void *);
/*****************************************************************************/
ByTe_2 NewVidf (void *);
/*****************************************************************************/
ByTe_2 ir_next_idf_file (void *);
/*****************************************************************************/
ByTe_2 ir_number_of_cal_elements (void *);
/*****************************************************************************/
void   ir_oper_asgn (void);
/*****************************************************************************/
void PaFormat0 (struct pitch_info *, void *, ByTe_2, u_ByTe_2);
/*****************************************************************************/
void PaFormat1 (struct pitch_info *, void *, ByTe_2, u_ByTe_2);
/*****************************************************************************/
ByTe_2 ir_playback_data_files (u_ByTe_4, ByTe_2, ByTe_2, ByTe_4, ByTe_4, 
                               ByTe_2, ByTe_2, ByTe_4, ByTe_4, ByTe_1 *);
/*****************************************************************************/
ReaL_8 ir_poly_expand (ByTe_4 *, ReaL_4 *, ByTe_4, ByTe_1);
/*****************************************************************************/
ByTe_2 ir_position_real_time (ByTe_4, void *);
/*****************************************************************************/
ByTe_2 read_drec (u_ByTe_4, ByTe_1 *, u_ByTe_2, void *, ByTe_2, ByTe_2,
                  ByTe_1, ByTe_1);
/*****************************************************************************/
ByTe_2 ir_read_header (void *);
/*****************************************************************************/
ByTe_4 read_idf (u_ByTe_4, ByTe_1 *, u_ByTe_2, ByTe_1 *, ByTe_2, ByTe_2,
                 ByTe_4, ByTe_2);
/*****************************************************************************/
ByTe_4 ir_read_idf_disk (ByTe_1 *, ByTe_2, ByTe_2, ByTe_4, ByTe_2);
/*****************************************************************************/
ByTe_4 ir_read_idf_memory (ByTe_1 *, ByTe_2, ByTe_2, ByTe_4, ByTe_2);
/*****************************************************************************/
ByTe_2 ir_read_idf_once (void);
/*****************************************************************************/
ByTe_2 ir_once_rval (ByTe_4);
/*****************************************************************************/
ByTe_2 ir_read_in_tbl (ByTe_2, ReaL_4 *, ByTe_4, ByTe_4, ByTe_2);
/*****************************************************************************/
ByTe_2 ir_read_in_rval (ByTe_4);
/*****************************************************************************/
ByTe_2 reset_experiment_info (u_ByTe_4, ByTe_1 *, u_ByTe_2, ByTe_2, ByTe_2, 
                              ByTe_4, ByTe_4, ByTe_2, ByTe_2, ByTe_4, ByTe_4);
/*****************************************************************************/
ByTe_2 ir_reset_header (void *);
/*****************************************************************************/
void   ir_reset_sen_set_time (void);
/*****************************************************************************/
ByTe_2 ir_realtime_data_files (ByTe_2, ByTe_2, ByTe_4, ByTe_4, ByTe_2, ByTe_2, 
                               ByTe_4, ByTe_4, u_ByTe_4, ByTe_1 *);
/*****************************************************************************/
void   ir_sample_time (u_ByTe_2, void *, u_ByTe_2, ByTe_2, ByTe_4 *, ByTe_4 *, 
                      ByTe_4 *, ByTe_4 *, ByTe_1 *, ByTe_1 *);
/*****************************************************************************/
ByTe_2 select_sensor (u_ByTe_4, ByTe_1 *, u_ByTe_2, ByTe_2);
/*****************************************************************************/
ByTe_2 ir_sensor_combo (void);
/*****************************************************************************/
void   ir_sensor_set_time (ByTe_4 *, ByTe_4 *, ByTe_4 *, ByTe_4 *);
/*****************************************************************************/
void   ir_set_fd_limit (void);
/*****************************************************************************/
void   ir_set_time (ByTe_1, void *, ByTe_1 *, ByTe_1 *);
/*****************************************************************************/
ByTe_2 start_image (u_ByTe_4, ByTe_1 *, u_ByTe_2, void *);
/*****************************************************************************/
void   ir_tbl_size (ByTe_2, size_t *);
/*****************************************************************************/
ReaL_4 TimeTblVal (ReaL_4 *, void *);
/*****************************************************************************/
ByTe_2 ToThisTime (u_ByTe_4, ByTe_1 *, u_ByTe_2, void *, ByTe_2, ByTe_2, 
                   ByTe_4, ByTe_4, ByTe_2, ByTe_2, ByTe_4, ByTe_4);
/*****************************************************************************/
ByTe_2 ReOpenFile (u_ByTe_4, ByTe_1 *, u_ByTe_2, void *, ByTe_2, ByTe_2, 
                   ByTe_4, ByTe_4, ByTe_2, ByTe_2, ByTe_4, ByTe_4, ByTe_2);
/*****************************************************************************/
void   ir_get_time_components (void);
/*****************************************************************************/
void   ir_to_sign (ByTe_4 *, u_ByTe_2, ByTe_1);
/*****************************************************************************/
void   ir_transfer_data (ReaL_8 *, ByTe_1 *, ByTe_4, ByTe_1, ByTe_4);
/*****************************************************************************/
ByTe_2 ir_get_pitch_info (ByTe_2, ByTe_2, ByTe_4, ByTe_4, ByTe_2, ByTe_2, 
                          ByTe_4, ByTe_4);
/*****************************************************************************/
ByTe_2 ir_get_pinfo_rval (ByTe_4);
/*****************************************************************************/
ByTe_2 ir_file_setup (u_ByTe_4, ByTe_1 *, u_ByTe_2, ByTe_2, ByTe_2, ByTe_4, 
                      ByTe_4, ByTe_2, ByTe_2, ByTe_4, ByTe_4);
/*****************************************************************************/
ByTe_2 ir_fill_pitch_angles (ByTe_1, ByTe_1, void *);
/*****************************************************************************/
ByTe_2 ir_acquire_pitch_data (struct pitch_times, struct pitch_info *,
                             u_ByTe_2, ByTe_1);
/*****************************************************************************/
void   ir_same_pitch_time (struct pitch_info *, ByTe_1, ByTe_2);
/*****************************************************************************/
ByTe_2 ir_process_pitch_data (struct pitch_info *, struct pitch_times, ByTe_2,
                              u_ByTe_2);
/*****************************************************************************/
ByTe_2 ir_pitch_los_next_file (struct pitch_info *, ByTe_2);
/*****************************************************************************/
ReaL_4 ir_pitch_time_frac (struct pitch_info *, struct pitch_times, ByTe_2);
/*****************************************************************************/
void   ir_pitch_end_time (struct pitch_info *, struct pitch_times,
                          ByTe_2, ByTe_2, ByTe_4, ByTe_2);
/*****************************************************************************/
ByTe_1 ir_pitch_start_time (struct pitch_times, ByTe_2, ByTe_2, ByTe_4);
/*****************************************************************************/
void ir_compute_pitch_angle (struct pitch_info *, void *, ByTe_2, u_ByTe_2);
/*****************************************************************************/
ByTe_2 ir_alloc_pitch_info (ByTe_2, ByTe_2, ByTe_4, ByTe_4);
/*****************************************************************************/
ByTe_4 ir_get_unit_normals (void);
/*****************************************************************************/
ByTe_2 ir_pitch_angle_data_src (void);
/*****************************************************************************/
ByTe_2 ir_pitch_angle_tbl_info (void);
/*****************************************************************************/
void ir_pitch_angle_sweep_times (struct experiment_info *, struct ptr_rec *,
                                 struct pitch_info *, u_ByTe_2, void *,
                                 ByTe_1 *, ByTe_1 *);
/*****************************************************************************/
ByTe_2 pitch_angle_source_status (u_ByTe_4, ByTe_1 *, u_ByTe_2, ByTe_2 *,
                                  u_ByTe_4 *);
/*****************************************************************************/
ByTe_2 PromoteFile (ByTe_1 *, u_ByTe_4,  ByTe_2, ByTe_2, ByTe_4, ByTe_2, 
                            ByTe_2, ByTe_4, ByTe_2); 
/*****************************************************************************/
ByTe_2 next_file_start_time (u_ByTe_4, ByTe_1 *, u_ByTe_2, ByTe_1, ByTe_2 *,
                             ByTe_2 *, ByTe_4 *, ByTe_4 *);
/*****************************************************************************/
void   ir_copy_pitch_angle (struct pitch_info *, u_ByTe_2);
/*****************************************************************************/
void   idfs_error_message_str (ByTe_2, ByTe_1 *);
/*****************************************************************************/
void   ir_read_drec_times (void *, ByTe_1);
/*****************************************************************************/
ByTe_2 ir_read_drec_time_advance (void *, ByTe_1, ByTe_1);
/*****************************************************************************/
ByTe_2 ir_read_drec_data_values (void *, ByTe_1, ByTe_1, ByTe_4);
/*****************************************************************************/
void   ReOrderBytes (ByTe_4, u_ByTe_1 *, ByTe_4);
/*****************************************************************************/
void   ReOrderUdf (ByTe_2);
/*****************************************************************************/
void   ThetaConing (void *);
/*****************************************************************************/
ByTe_2 GetOrdering (u_ByTe_4);
/*****************************************************************************/

#if defined(__cplusplus)
}
#endif
#endif
