#ifndef _loc_ParseConfig_h

/*
   Definitions for using the Pconfig function set.
*/
#define T_CHAR 1
#define T_SHORT 2
#define T_INT 3
#define T_FLOAT 4
#define T_DOUBLE 5
#define T_STRING 6
#define T_STRPTR 7

#define T_SHORT_ARRY 8
#define T_INT_ARRY 9
#define T_FLOAT_ARRY 10
#define T_DOUBLE_ARRY 11
#define T_STRING_ARRY 12
#define T_STRPTR_ARRY 13

#define IS_OPTIONAL 1
#define IS_REQUIRED 2

#define SYMBOLSIZE 256

#ifndef NULL
#define NULL 0x0
#endif

#define CONFIG_TABLE_WIDTH 128
#define ALLOC_ATOM 60
#ifndef CNULL
#define CNULL (config_t *)0x0
#endif
#define SNULL (symb_t *)0x0

/*
   Structures for using the Pconfig function set.
*/
typedef struct symb_s
{
   ByTe_2 referenced; /* Indicates if this element has been used. */
   ByTe_1  *param;     /* The name of a config parameter.          */
   ByTe_1  *value;     /* The value of a config parameter.         */
} symb_t;

typedef struct config_s
{
   int    elements[CONFIG_TABLE_WIDTH]; /* The length of each symbol array.   */
   int    used[CONFIG_TABLE_WIDTH];     /* The number of array elements used. */
   symb_t *symbols[CONFIG_TABLE_WIDTH]; /* Array of pointers to symbol arrays.*/
} config_t;

typedef struct def_s
{
   ByTe_1 *param;            /* Name of the parameter in the config file.      */
   int  type;              /* Type of input to use for the value.            */
   void *value;            /* Pointer to the storage location for the value. */
   int  required;          /* Flag for optional or required parameter.       */
   int  n_values;          /* number of values for param.                    */
} def_t;

#define _loc_ParseConfig_h
#endif /* _loc_ParseConfig_h */
