/*
@(#)DbMesgs.h	1.2 96/04/01 SwRI
   DbMesgs.h
*/

#ifndef DbMesgs_h
#define DbMesgs_h

#include "DbDefs.h"
#include "ByteDefs.h"

/*
 |
 || include file for messages from error/message numbers
 |
 */

struct db_messages
{
   int  mesg_no;       /* error/message number */

   ByTe_1 message[50];   /* message              */

} db_mesg[] =

  {
    { NO_DATA,      "NO DATA AVAILABLE" },
    { PBS_DOWN,     "DHS NOT RESPONDING" },
    { RETRIEVING,   "RETRIEVING DATA FROM DHS" },
    { PBS_PROBLEMS, "RETRIEVING DATA FROM DHS" },
    { NO_DATA_AOS,  "NO DATA - AOS" },

    { INDEX_OPEN_ERROR,   "OPENING INDEX FILE" },
    { INDEX_CLOSE_ERROR,  "CLOSING INDEX FILE" },
    { INDEX_READ_ERROR,   "READING FROM INDEX FILE" },
    { INDEX_WRITE_ERROR,  "WRITING TO INDEX FILE" },

    { DBF_OPEN_ERROR,     "OPENING DATABASE FILE" },
    { DBF_CLOSE_ERROR,    "CLOSING DATABASE FILE" },
    { DBF_READ_ERROR,     "READING FROM DATABASE FILE" },
    { DBF_WRITE_ERROR,    "WRITING TO DATABASE FILE" },
    { DBF_FIND_ERROR,     "DATABASE FIND ERROR" },
    { DBF_EMPTY,          "DATABASE EMPTY" },
    { DBF_LSEEK_ERROR,    "DATABASE LSEEK ERROR" },
    { DBF_REPLACE_ERROR,  "DATABASE REPLACE ERROR" },
    { DBF_APPEND_ERROR,   "DATABASE APPEND ERROR" },

    { NO_VIDF_MATCH,      "VIDF MATCH ERROR" },
    { NO_VIDF_FILE,       "NO VIDF FILE" },
    { VIDF_OPEN_ERROR,    "OPENING VIDF FILE" },

    { NO_DATA_FILE,       "NO DATA FILE" },
    { DATA_OPEN_ERROR,    "DATA FILE OPEN ERROR" },
    { DATA_READ_ERROR,    "DATA FILE READ ERROR" },

    { NO_HEADER_FILE,     "NO HEADER FILE" },
    { HEADER_OPEN_ERROR,  "HEADER FILE OPEN ERROR" },
    { HEADER_READ_ERROR,  "HEADER FILE READ ERROR" },
    
    { TIMES_NOT_FOUND,    "TIMES NOT FOUND" },
    { BAD_START_TIME,     "INVALID START TIME" },
    { BAD_END_TIME,       "INVALID END TIME" },

    { SOCKET_OPEN_ERROR,  "SOCKET OPEN ERROR" },
    { SOCKET_BIND_ERROR,  "SOCKET BIND ERROR" },
    { SENDTO_ERROR,       "SENDTO() ERROR" },
    { RECVFROM_ERROR,     "RECVFROM() ERROR" },
 
    { TAR_ZERO_LEN_FILE,  "TAR ZERO LENGTH FILE" },
    { TAR_SHORT_READ,     "TAR SHORT READ ERROR" },
    { TAR_UNKNOWN_FILE_TYPE, "TAR UNKNOWN FILE TYPE" },
    { TAR_EXTRACT_DIR,    "TAR ERROR - EXTRACT DIRECTORY" },
    { TAR_MKDIR_ERROR,    "TAR ERROR - MAKE DIRECTORY" },
    { TAR_CHMOD_ERROR,    "TAR ERROR - CHANGE MODE" },
    { TAR_BAD_HEADER,     "TAR ERROR - BAD HEADER" },
    { TAR_EOA,            "TAR ERROR - END OF ARCHIVE" },
    { TAR_SHORT_WRITE,    "TAR ERROR - SHORT WRITE" },
    { TAR_MULTI_LINK,     "TAR ERROR - MULTI LINK" },

    { FIRST_ARCHIVE_FILE, "FIRST ARCHIVE FILE" },
    { READ_LABEL_ERROR,   "TAR - READ LABEL ERROR" },

	 { ALLOC_ERROR,         "MEMORY ALLOCATION ERROR" },

    { NO_ARCHIVE_LABEL,    "TAR - NO ARCHIVE LABEL" },
    { NEED_NEW_LABEL,      "TAR - SAME LABEL" },
    { TAPE_PROBLEM,        "TAR - TAPE ERROR" },
    { ARCHIVE_WRITE_ERROR, "TAR - ARCHIVE WRITE ERROR" },
    { CHANGE_MEDIA,        "TAR - CHANGE MEDIA" },
    { NEW_TAPE,            "TAR - NEW TAPE" },
    { ARCHIVE_OPEN_ERROR,  "TAR - ARCHIVE OPEN ERROR" },

	 { NO_DATA_AVAILABLE,   "NO DATA AVAILABLE" },
	 { CONFIG_FILE_ERROR,   "CONFIG FILE ERROR" },
    { VINST_ERROR,         "UNKNOWN VIRTUAL INSTRUMENT NUMBER"}
  };


#endif
