#include <stdlib.h>
#include "ByteDefs.h"
#ifndef __DB_H__
#define __DB_H__

#ifndef NULL
#define NULL 0
#endif

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define DB2File 2
#define DB3File 3
#define DB3WithMemo 4

/*
 | field types
 */
#define CHARACTER 'C'
#define NUMERIC 'N'
#define DATE 'D'
#define MEMO 'M'
#define LOGICAL 'L'
/*
 * Set Commands
 */
enum SetCommands {
   /*
    | dbSet() commands
    */
    DATE_
};
/*
 * Set Values
 */
enum DateValues {
   /*
    | date formats
    */
   AMERICAN=0, MDY=0,                 /* mm/dd/yy */
   ANSI = 1,                          /* yy.mm.dd */
   BRITISH = 2, FRENCH = 2, DMY = 2,  /* dd/mm/yy */
   GERMAN = 3,                        /* dd.mm.yy */
   ITALIAN = 4,                       /* dd-mm-yy */
   JAPAN = 5, YMD = 5,                /* yy/mm/dd */
   USA = 6,                           /* mm-dd-yy */
   RAW = 7                            /* yyyymmdd  as stored in the file */
};
/*
 | return values from dbFind() routine
 */
#define EXACT_MATCH 10
#define NO_MATCH    11
#define MATCH_LESS  12
#define MATCH_GREATER 13
#define FIND_ERROR 14

/*
 | return values from routines
 */
#ifndef SUCCESS
#define SUCCESS 1
#endif
#ifndef FAILURE
#define FAILURE 0
#endif

/*
 *  dbf_code values.  Since errno values range from 1 to 151 for safety sake
 *  we'll start db error numbers at 500.
 */
#define FULL          500 /* allocated database records full */
#define NOT_DB_FILE   501 /* first byte was not a $3 or $83 or a $2 (dBASE II)*/
#define REC_TOO_HIGH  502 /* tried to read a record beyond the correct range */
#define REC_TOO_LOW   503 /* tried to read a record beyond the correct range */
#define PARTIAL_READ_ 504 /* only a partial record was read */
#define LSEEK_ERROR   505 
#define READ_ERROR    506 
#define WRITE_ERROR   507 
#define OPEN_ERROR    508
/*
 * field related errors
 */
#define UNKNOWN_FIELD_TYPE 520
#define UNKNOWN_FIELD      521
#define FIELD_VALUE_ERR    522
#define FIELD_ERROR        523

#define NO_SUCH_HANDLE    530 
#define EMPTY_HANDLE      531
#define NO_AVAIL_HANDLES  532
#define UNKNOWN_HANDLE    533

#define INVALID_SET_CMD      540
#define INVALID_SET_VALUE   541


#define ALIGNMENT 4
#define ALIGN(a) ((a % ALIGNMENT) ? (ALIGNMENT - (a % ALIGNMENT)) : 0)

#define FIELD_NAME_LEN 10
#define FILE_NAME_LEN 256
#define MAX_HEADER 4129
#define MAX_BYTES_IN_RECORD 4000
#define MAX_FIELDS_IN_RECORD 128
#define BYTES_IN_MEMO_RECORD 512
#define MAX_INDEX_FIELDS 5
#define INDEX_LENGTH 25

typedef ByTe_1 Header_t[MAX_HEADER];
typedef ByTe_1 HeaderProlog_t[32];
typedef ByTe_1 FieldDesc_t[32];
typedef ByTe_1 DataRecord_t[MAX_BYTES_IN_RECORD];

typedef struct FieldRecord_s {
   ByTe_1 Name[FIELD_NAME_LEN+1];
   ByTe_1 Typ;
   ByTe_1 Len;
   ByTe_1 Dec;
   ByTe_1 *Parm;
} FieldRecord_t;

typedef FieldRecord_t FieldArray_t[MAX_FIELDS_IN_RECORD];
typedef ByTe_1 MemoRecord_t[BYTES_IN_MEMO_RECORD];

typedef enum {NotOpen=0, NotUpdated, Updated} Status_t;

typedef struct ndxRecord_s
{
   int handle;

   /*
    *index information
    */
   ByTe_1        IndexName[FILE_NAME_LEN]; /* index file name          */

   int           IndexRec;          /* current index record            */
   int           NextFreeIndexRec;
   int           MAXIndexRecs;      /* maximum number of index records */
   Status_t      iStatus;           /* index status                    */
   int           NumIndexFields;    /* number of index fields          */
   FieldRecord_t *IndexFields;      /* pointer to the index fields     */
   int           KeyLen;            /* index key length in bytes       */
   ByTe_1        *Index;            /* pointer to index                */

   struct ndxRecord_s *next;
} ndxRecord_t;

typedef struct dbfRecord_s
{
   int handle;

   /*
    * File Information
    */
   ByTe_1  FileName[FILE_NAME_LEN];  /* database file name */
   int   dFile;                    /* file descriptor    */

   /*
    * Header Information
    */
   HeaderProlog_t    HeadProlog;
   Status_t          hStatus;          /* header status */
   ByTe_1            WithMemo;
   ByTe_1            DateOfUpdate[8];  /* current date of modififed database */
   ByTe_4            NumRecs;          /* number of record in database */
   int               HeadLen;          /* header (prolog) length in bytes */
   int               RecLen;        
   int               NumFields;        /* number of fields */
   FieldRecord_t     *Fields;          /* pointer to fields */

   /*
    * Current record
    */
   int          CurRec;        /* current record number      */
   Status_t  rStatus;          /* record status              */
   DataRecord_t  *CurRecord;   /* pointer to currnect record */

   ndxRecord_t *ndxRecords;    /* pointer to index structure  */

   struct dbfRecord_s *next;
} dbfRecord_t;

typedef struct SetValues_s
{
   enum DateValues Date;
} SetValues_t;

/*
 * prototypes
 */

ByTe_1 *dbf_msg();

int AppendBlank(int);
int AppendDbf(int);
int CloseDbf(int);
int CloseNdx(int, int);
int CreateDbf(int *, ByTe_1 *, int, FieldRecord_t *);
int CreateNdx(int, ByTe_1 *, ByTe_1 **FieldNames, int, int *);
int dbFind(int, int, ByTe_1 *, int);
int FieldGet(int, int, void *);
int FieldGetN(int, ByTe_1 *, void *);
int FieldNo(int, ByTe_1 *);
int FieldPut(int, int, void *);
int FieldPutN(int, ByTe_1 *, void *);
int GetDbfRecord(int, int);
int GoTo(int, int);
int GoToBottom(int, int);
int GoToTop(int, int);
int InitHandle(int);
int InitDbfHandle(dbfRecord_t *);
int InitNdxHandle(ndxRecord_t *);
int ItoR(ndxRecord_t *, int);
int OpenDbf(int *, ByTe_1 *, int);
int OpenNdx(int, ByTe_1 *, int *);
void PercentDone (int, int);
int PutDbfRecord(int, int);
void QSORT (void *, size_t, size_t, int (*cmp)(const void *, const void *));
void db_Qsort(ByTe_1 *, int, int, int);
int ReIndex(int, int);
int Replace(int, ByTe_1 *, void *);
int ReplaceFn(int, int, void *);
int Skip(int, int ndx, int);
int dbSet(enum SetCommands, int);
int DeleteRec(int, int, int);
int DeleteNdxRec(ndxRecord_t *N, int);
int UnDeleteRec(int, int, int);
int AddIndexRec(dbfRecord_t *, ndxRecord_t *);
int RecNo(int);
int UpdateHeader(dbfRecord_t *);
int MakeOneFieldDesc(dbfRecord_t *, FieldDesc_t *, FieldRecord_t *);
int MakeFieldDescs(dbfRecord_t *, FieldRecord_t *);
int MakeHeader(dbfRecord_t *, FieldRecord_t *);
ByTe_4 MakeLong(ByTe_1 *);
int MakeInt(ByTe_1 *);
int GetOneFieldDesc(dbfRecord_t *, FieldDesc_t *, FieldRecord_t *, int *);
int ProcessHeader(dbfRecord_t *, Header_t, int);
int GetHeader(dbfRecord_t *);

void DateFormat(ByTe_1 *, ByTe_1 *);

dbfRecord_t *GetOldDbfHandle(int);
dbfRecord_t *GetNewDbfHandle(int *);
dbfRecord_t *dbfHandle(int);

ndxRecord_t *GetOldNdxHandle(int, int);
ndxRecord_t *GetNewNdxHandle(int, int *);
ndxRecord_t *ndxHandle(int, int);

FieldRecord_t *dbField(int, ByTe_1 *);

ByTe_1 *rtrim(ByTe_1 *);
ByTe_1 *ltrim(ByTe_1 *);
void to_upper(ByTe_1 *);

/*
 >>>>> Macros <<<<<
*/

#define mDbfFileName(a)  (dbfHandle(a))->FileName
#define mNumRecs(a)      (dbfHandle(a))->NumRecs
#define mDateOfUpdate(a) (dbfHandle(a))->DateOfUpdate
#define mNumFields(a)    (dbfHandle(a))->NumFields
#define mRecLen(a)       (dbfHandle(a))->RecLen
#define mCurRec(a)       (dbfHandle(a))->CurRec
#define mRecord(a)       (dbfHandle(a))->CurRecord
#define mDelFlag(a)      (dbfHandle(a))->CurRecord[0][0]
#define mField(a,b)      (dbfHandle(a))->Fields+b

#define mFieldName(a,b) (mField(a,b))->Name
#define mFieldType(a,b) (mField(a,b))->Typ
#define mFieldLen(a,b)  (mField(a,b))->Len
#define mFieldDec(a,b)  (mField(a,b))->Dec
#define mFieldParm(a,b) (mField(a,b))->Parm

#define mIndexRec(a, b)  ((ndxHandle(a,b))->IndexRec)

#define dbf_msg_clr   memset(msg,0,128)

#ifdef _INIT_
   dbfRecord_t *dbfRecords = NULL;
   SetValues_t SET = { AMERICAN };
   ByTe_1 msg[128];
   int dbf_code = 0;
#else
   extern dbfRecord_t *dbfRecords;
   extern SetValues_t SET;
   extern ByTe_1 msg[];
   extern int dbf_code;
#endif

#endif
