/*
   @(#)DbDefs.h	1.1 95/09/08 SwRI
*/
#ifndef DbDefs_h
#define DbDefs_h

/*
 |
 || This include file defines ALL error/non-error messages
 |
 */

#ifndef NULL
#define NULL 0x0
#endif

/*
 | define the stream numbers
 */
#define _HEADER 1
#define _DATA 2
#define _VIDF 4
/*********
#define _SCF 8
**********/

#define LONG 0
#define SHORT 1
#define ALL_ENTRIES 0
#define ONLINE_ENTRIES 1
#define OFFLINE_ENTRIES 2

/*
 | define the status that is returned from the pbr() routine
 */
#define ALL_OK 1
#define PBS_DOWN 2
#define PBS_PROBLEMS 8
#define NEED_PROMOTE 30

#define DB_START_plus  1000
#ifndef NO_DATA
#define NO_DATA          DB_START_plus+200
#endif
#define RETRIEVING       DB_START_plus+201
#define NO_DATA_AOS      DB_START_plus+202
#define RETRIEVING_DATA  DB_START_plus+203

/******************************************************************************/
/******************************************************************************/

#define DB_START_neg  -1000

#define INDEX_OPEN_ERROR  DB_START_neg-1
#define INDEX_CLOSE_ERROR DB_START_neg-2
#define INDEX_READ_ERROR  DB_START_neg-3
#define INDEX_WRITE_ERROR DB_START_neg-4

#define DBF_OPEN_ERROR  DB_START_neg-10
#define DBF_CLOSE_ERROR DB_START_neg-11
#define DBF_READ_ERROR  DB_START_neg-12
#define DBF_WRITE_ERROR DB_START_neg-13
#define DBF_FIND_ERROR  DB_START_neg-14
#define DBF_EMPTY       DB_START_neg-15
#define DBF_LSEEK_ERROR DB_START_neg-16
#define DBF_REPLACE_ERROR DB_START_neg-17
#define DBF_APPEND_ERROR DB_START_neg-18

#define NO_VIDF_MATCH   DB_START_neg-20
#define NO_VIDF_FILE    DB_START_neg-21
#define VIDF_OPEN_ERROR DB_START_neg-22

#define NO_DATA_FILE    DB_START_neg-40
#define DATA_OPEN_ERROR DB_START_neg-41
#define DATA_READ_ERROR DB_START_neg-42

#define NO_HEADER_FILE    DB_START_neg-50
#define HEADER_OPEN_ERROR DB_START_neg-51
#define HEADER_READ_ERROR DB_START_neg-52

#define TIMES_NOT_FOUND DB_START_neg-70
#define BAD_START_TIME  DB_START_neg-71
#define BAD_END_TIME  DB_START_neg-72

#define SOCKET_OPEN_ERROR DB_START_neg-80
#define SOCKET_BIND_ERROR DB_START_neg-81
#define SENDTO_ERROR      DB_START_neg-82
#define RECVFROM_ERROR    DB_START_neg-83

#define TAR_ZERO_LEN_FILE     DB_START_neg-90
#define TAR_SHORT_READ        DB_START_neg-91
#define TAR_UNKNOWN_FILE_TYPE DB_START_neg-92
#define TAR_EXTRACT_DIR       DB_START_neg-93
#define TAR_MKDIR_ERROR       DB_START_neg-94
#define TAR_CHMOD_ERROR       DB_START_neg-95
#define TAR_BAD_HEADER        DB_START_neg-96
#define TAR_EOA               DB_START_neg-97
#define TAR_SHORT_WRITE       DB_START_neg-98
#define TAR_MULTI_LINK        DB_START_neg-99

#define FIRST_ARCHIVE_FILE DB_START_neg-110
#define READ_LABEL_ERROR   DB_START_neg-111

#define ALLOC_ERROR DB_START_neg-130

#define NO_ARCHIVE_LABEL    DB_START_neg-150
#define NEED_NEW_LABEL      DB_START_neg-151
#define TAPE_PROBLEM        DB_START_neg-152
#define NEW_TAPE            DB_START_neg-153
#define ARCHIVE_WRITE_ERROR DB_START_neg-154
#define CHANGE_MEDIA        DB_START_neg-155
#define ARCHIVE_OPEN_ERROR  DB_START_neg-156

#define NO_DATA_AVAILABLE  0
#define CONFIG_FILE_ERROR  DB_START_neg-170
#define KEY_ERROR          DB_START_neg-171
#define VINST_ERROR        DB_START_neg-172
#define DB_FIELD_ERROR     DB_START_neg-173

#define DB_STOP_neg        DB_START_neg-173
#endif
