#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: text_lab.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 text_lab (ByTe_1 gn, ByTe_1 axis, ReaL_4 pos, ByTe_2 level, 
                 ByTe_1 *text, ByTe_1 hv, ByTe_1 just, ByTe_1 io, 
                 ReaL_4 phi, ReaL_4 rot, ByTe_2 color)
{
   extern struct config parm;
   struct graph    *gf;
   struct window   *wn;
   struct labels   *lb;
   struct numbers  *nm;
   register ByTe_2 i,j;
   register ReaL_4 *fpt;
   ReaL_4 plt[6], ch_sz[2];
   ReaL_4 spacing,t_axis,offset,clen;
   ReaL_4 tic[3],depth[10],sgn;
   ByTe_2 sav_csize;
   ByTe_2 rx,nx,sx;  
   ByTe_1 sav_font,sav_clip;
   ByTe_1 off[2],vp,save[3]; 
   ReaL_4 labelbase;
   ReaL_4 xx,yy;
   ByTe_1 base;
 
   if (plotnm (gn,"TEXT_LAB",1) != 1 )
   {
      g_error ("TEXT_LAB","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }

   if (level < 0 || level > 9)
   {
      g_error ("TEXT_LAB","ILLEGAL TEXT LEVEL -- SET TO 1",0);
      level = 1;
   }

   gf = parm.grf;
   vp = gf->window;
   lb = gf->lab;
   nm = gf->num;
   wn = gf->gwn;

   sav_clip = wn->clip;
   sav_font = parm.font;
   sav_csize = parm.csize;

   font (lb->font);
   chr_size (lb->size);
   clip (vp,0);

   rx = axis/4;
   nx = axis%4;
   sx = axis/2;
   off[0] = nm->base_set[axis]%2;
   off[1] = nm->base_set[axis]/2;

/*** save the current window scaling                        ***/

   if (!gf->plot)
   {
      for (i=0,j=3; i<3; ++i,++j) 
      {
         save[i] = wn->axis[i];
         wn->axis[i] = 0;
         plt[i] = wn->plot[i];
         plt[j] = wn->plot[j];
         wn->plot[i] = 0.0;
         wn->plot[j] = 1.0;
      }
      wn->axis[rx] = gf->scale[sx];
      wn->plot[rx]   = gf->mn_sca[sx];
      wn->plot[rx+3] = gf->mx_sca[sx];

      scale_win (2);
   }

/*** get current character scaling ***/
   
   base = (rx == 0) ? 1 : 0;
   get_chsz (ch_sz);
   clen =  ch_sz[base];

   tic[2] = 0.0;

   if (rx == 1)
      phi += (nx/2) ? 270.0 : 90.0;

   spacing = lb->spacing * clen;
   offset = (.5 + lb->offset) * clen;

   sgn = ((io && nx/2) || (!io && !(nx/2))) ? 1 : -1;
   if (gf->plot && rx == 1)
      sgn = -sgn;
 
   t_axis = (io) ? lb->obase[axis] : lb->ibase[axis];

   for (fpt = depth, j = 0; j < 10; ++j)
       *fpt++ = t_axis + sgn * (offset + j * (spacing +  clen));

   tic[rx] = pos; 

   switch (rx) 
   {         
      case 0:
         tic[1] =  depth[level];
         break;
      case 1:
         tic[0] =  depth[level];
         break;
      case 2:
         tic[1] =  depth[level];
         break;
   }
   
   if (gf->plot)
   {
      if (rx == 1)
      {
          xx = tic[0] * cosin(pos);
          yy = tic[0] * sine(pos);
          phi = (pos >= 0. && pos<= 180.) ? pos - 90. : pos + 90. ;
          chr_dspl (vp,xx,yy,0.0,phi,0.0,rot,hv,0,text,-1,color);
      }
      else
      {
         xx = tic[0] * cosin(pos) + tic[1] * cosin(pos + 90.0);
         yy = tic[0] * sine(pos) + tic[1] * sine(pos + 90.0);  
         phi = gf->mn_sca[2];
         chr_dspl (vp,xx,yy,0.,phi,0.0,rot,hv,just,text,-1,color);
       }
   }
   else
      chr_dspl (vp,tic[0],tic[1],tic[2],phi,0.0,rot,hv,just,text,-1,color);

   if ((io && !off[1]) || (io && !off[0]))
   {
      fpt = (io) ? &nm->obase[axis] : &nm->ibase[axis];
      labelbase = depth[level] + sgn * .5 * clen;
      if (wn->dimen == 2) 
      {
         if (rx == 1)
         {
            if ((io && axis == 7) || (!io && axis == 4)) 
            {
                if (nm->obase[axis] < labelbase)
                   nm->obase[axis] = labelbase;
             }
             else
             {
                if (nm->ibase[axis] > labelbase)
                   nm->ibase[axis] = labelbase;
             }
          }
          else
             *fpt = depth[level];
      }
      else
      {
         if (rx != 1)
         {
            if ((io && nx/2) || (!io && !(nx/2)))
            {
               if (nm->obase[axis] < labelbase)
                  nm->obase[axis] = labelbase;
            }
            else
            {
               if (nm->ibase[axis] > labelbase)
                   nm->ibase[axis] = labelbase;
            }
         }
         else
            *fpt = depth[level];
      }
   }

   RestoreSet (save, plt, sav_clip, sav_font, sav_csize);
   return(1);
} 
