#include <string.h>
#include <math.h>
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: num_lab2.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 num_lab (ByTe_1 gn, ByTe_1 axis, ReaL_4 pos, ByTe_2 level, 
                ByTe_1 *nlabel, ByTe_1 *fmt, ByTe_1 hv, ByTe_1 io, 
                ReaL_4 phi, ReaL_4 rot, ByTe_2 color)
{
  extern struct config parm;
  extern struct memory minfo;
  extern struct init_val ival;
  struct window   *wn;
  struct graph    *gf;
  struct labels   *lb;
  struct numbers  *nm;
  ByTe_1 sav_font;
  ByTe_1 base,vp;
  register ByTe_2 i,j;
  register ReaL_4 *fpt;
  ReaL_4 tmp,plt[6],clen,tic_majs;
  ReaL_4 ch_sz[2],offset,taxis,spacing,labelbase;
  ReaL_4 tic[3],tic_sep,lev[10],sgn;
  ByTe_2 first,last,labs;
  ByTe_2 prnt,sav_csize,just = 0,sx,nx,rx;
  ReaL_4 max_ch,c_len;
  ByTe_2 skp,row,length;
  ReaL_4 str_size;
  ByTe_1 *label,save[3];
  ByTe_1 off[2],sav_clip;
  ReaL_4 st,ct,up_dn[2];
  ReaL_4 r,thcnt,pa[2],inc=0.0;
  ByTe_1 intlv;
  ByTe_1 err_code;
 
  plotnm (gn,"NUM_LAB",0);

  gf = parm.grf;
  lb = gf->lab;
  nm = gf->num;

/*** make initial checks on input variables ***/

  if (level < 0 || level > 9)
  {
     g_error ("NUM_LAB","ILLEGAL LEVEL -- SET TO 1",0);
     level = 1;
  }

/*** check to see if graph has a valid window assigned to it ***/
/*** and if so then save the window number                   ***/

  vp = gf->window;
  err_code =  (vp != parm.wn_num) ? window (vp,"NUM_LAB") : parm.win->open;
  if (!err_code)
  {
     g_error ("NUM_LAB","REQUESTED PLOT HAS NOT BEEN DEFINED",0);
     return (0);
  }
  wn = parm.win;

  rx = axis/4;
  nx = axis%4;
  sx = axis/2;

  sav_clip = wn->clip;
  sav_font = parm.font;
  sav_csize = parm.csize;

  clip (vp,0);
  font (nm->font[sx]);
  chr_size (nm->size[sx]);

  off[0] = lb->base_set[axis]%2;
  off[1] = lb->base_set[axis]/2;

/*** get current character scaling ***/

  base = (rx == 1) ? 0:1;
  get_chsz (ch_sz);
  clen = ch_sz[base];

  tic[2] = 0.0;

  labs = auto_tic (gn,axis,up_dn);
  if (gf->plot && up_dn[0] > up_dn[1]) up_dn[0] -= 360;
  if (up_dn[0] > up_dn[1])
  {
     tmp = up_dn[0];
     up_dn[0] = up_dn[1];
     up_dn[1] = tmp;
  }

  intlv = (rx == 1) ? 1 : nm->interleave[sx];

  r = gf->mx_sca[0]  + .5 * clen + nm->offset[2];
  pa[0] = gf->mn_sca[2];
  pa[1] = gf->mx_sca[2];
  if (pa[0]>pa[1]) 
     pa[0] -= 360;
  inc = (pa[1] - pa[0]) / gf->mj_tcs[2] * (1 + nm->skip[2]);

  if (rx == 1)
     just = (sx == 2) ? 1 : -1;

  spacing = nm->spacing[sx] * clen;
  offset = (rx != 1 ) ? (.5 + nm->offset[sx]) * clen : nm->offset[sx] * clen;

  sgn = ((io && nx/2) || (!io && !(nx/2))) ? 1 : -1;
  
  taxis  = (io) ? nm->obase[axis] : nm->ibase[axis];

  for (fpt = lev, j = 0; j < 10; ++j)
      *fpt++ = taxis + sgn * (offset + j * (spacing + clen));

/**********************************************************************/
/*            Begin auto labeling portion of code                     */
/**********************************************************************/

  if (*nlabel == '\0') 
  {

/**********************************************************************/
/*    Compute the total number of labels to be put along the axis     */
/**********************************************************************/

     if (gf->scale[sx])
        tic_sep = 1.0;
     else
     {
        tic_majs = (up_dn[1] - up_dn[0])/gf->mj_tcs[sx];
        tic_sep = tic_majs;
     }
     if (tic_sep < 0)
	tic_sep = -tic_sep;


     label = (ByTe_1 *)minfo.mxyz + parm.cl_ofst - labs * 50;
     max_ch = 0;
     tic[rx] = (zc == 1) ? 0.0 : up_dn[0];

     for (j=0; j<labs; ++j) 
     {
        if (tic[rx] > up_dn[1])
           continue;

        if ((c_len = pr_fmt (fmt,label,tic[rx])) < 0)
           return (0);
        if (c_len > max_ch)
           max_ch = c_len;
        label += 50;

        tic[rx] = (gf->scale[sx]) ? tic[rx]*10. : tic[rx] + tic_majs;
     }

     if (zc == 1)
     {
        tic[rx] = 0.0;
        for (j=0; j<labs; ++j) 
        {
           if (tic[rx] < up_dn[0])
              continue;

           if ((c_len = pr_fmt (fmt,label,tic[rx])) < 0)
              return (0);

           if (c_len > max_ch)
              max_ch = c_len;
           label += 50;

           tic[rx] = tic[rx] - tic_majs;
        }
     }
          
     if (just == 1 && strcmp (fmt,"log") == 0 )
     {
        for (fpt = lev, j = 0; j < 10; ++j)
             *fpt++ -= (max_ch - 1.0)*clen;
     }

/**********************************************************************/
/*    Compute the pixel length of the largest output numerical        */
/*    label and use that to compute when labels should be             */
/*    interleaved (skip)                                              */
/**********************************************************************/

     if (wn->dimen == 2)
        c_len = (rx == 0) ? max_ch : 1;
     else
        c_len = (rx == 1) ? max_ch : 1;

     str_size = ch_sz[rx] * (c_len + nm->gap[sx]/2.0);
     skp = str_size / (tic_sep * (nm->skip[sx] + 1)) + 1.0;

     if ((io && !off[1]) || (!io && !off[0]))
     {
        fpt = (io) ? &lb->obase[axis] : &lb->ibase[axis];
        if (wn->dimen == 2)
        {
           if (rx == 0)
	   {
              *fpt  = (intlv) ? lev[skp +level - 1] : lev[level];
	      *fpt += sgn * .5 * clen;
           }
           else
              *fpt = sgn * max_ch * clen + lev[level];
        }
        else
        { 
           if (rx == 1)
	   {
              *fpt  = (intlv) ? lev[skp +level - 1] : lev[level];
	      *fpt += sgn * .5 * clen;
           }
           else
              *fpt = sgn * max_ch * clen + lev[0];
        }
     }

     if (gf->plot)
        thcnt = (rx==1 || (rx==0 && !(pa[0]<=0 && pa[1]>=0))) ? pa[0] : 0.0;
     else
        thcnt = 0.0;
     
     last = labs;
     first = 0;
     tic[rx] = up_dn[0];
     label = (ByTe_1 *)minfo.mxyz + parm.cl_ofst - labs * 50;
     switch (nm->ends[sx])
     {
        case 0:
           break;
        case 1:
           last = labs - 1;
           break;
        case 2:
           first = 1;
           thcnt += inc;
           break;
        case 3:
           first = 1;
           last = labs - 1;
           thcnt += inc;
           break;
     }

     tmp = up_dn[0];
     if (zc == 1)
     {
        first = 1;
        tic[rx] = tic_majs;
        tmp = 0.0;
        label += 50;
     }
     else
     {
        if (first)
        { 
           tic[rx] = (gf->scale[sx]) ? tic[rx] * 10 : up_dn[0] + tic_majs;
           label += 50;
        }
     }

     for (j=first,i=0; j<last; ++j, ++i) 
     {
        if (tic[rx] > up_dn[1])
           continue;

        row  = i%skp;
        prnt = i%(nm->skip[sx] + 1);

        if ((row == 0 || intlv) && prnt == 0) 
        {
           tic[base] = lev [level + row]; 
	   st = sine(thcnt);
	   ct = cosin(thcnt);
           if (gf->plot && rx == 1)
           {
              sprintf(label,fmt,thcnt);
              if (axis==4)
              {
                 if (thcnt>=0 && thcnt<=180)
                 {
                    chr_dspl(vp,r*ct,r*st,0.0,thcnt-90,0.0,
                       rot,hv,0,label,-1,color);
                 }
                 else
                 {
                    chr_dspl(vp,r*ct,r*st,0.0,thcnt+90,0.0,
                       rot,hv,0,label,-1,color);
                 }
              }
              else
                 chr_dspl(vp,r*ct,r*st,0.0,0.0,0.0,rot,hv,
                       0,label,-1,color);
              thcnt += inc;
           }
           else
              chr_dspl (vp, tic[0]*ct - tic[1]*st, tic[0]*st + tic[1]*ct,
		   tic[2],phi,0.0,rot,hv,just,label,-1,color);
        }

        tic[rx] = (gf->scale[sx]) ? tic[rx] * 10 : tmp + (j+1)*tic_majs;
        label += 50;
     } 

     if (zc == 1)
     {
        tic[rx] = -tic_majs;
        label += 50;

        for (j=first,i=0; j<last; ++j,++i) 
        {
           if (tic[rx] < up_dn[0])
                 continue;

           row  = i%skp;
           prnt = i%(nm->skip[sx] + 1);

           if ((row == 0 || intlv) && prnt == 0) 
           {
              tic[base] = lev [level + row]; 

              chr_dspl (vp, tic[0], tic[1], tic[2],phi,0.0,rot,hv,just,
                      label,-1,color);
           }

           tic[rx] = tmp - (j+1)*tic_majs;
           label += 50;
        }
     }
  }
  else 
  {
     length = strlen(nlabel);
     offset = length * clen;
     labelbase = lev[level] + sgn*offset;
     fpt = (io) ? &lb->obase[axis] : &lb->ibase[axis];

     if ((io && !off[1]) || (!io && !off[0]))
     {
        if (wn->dimen == 2) 
        {
           if (rx == 1)
           {
              if ((io && axis == 7) || (!io && axis == 4)) 
              {
                  if (lb->obase[axis] < labelbase)
                     lb->obase[axis] = labelbase;
              }
              else
              {
                 if (lb->ibase[axis] > labelbase)
                        lb->ibase[axis] = labelbase;
              }
           }
           else
              *fpt = lev[level+1];
        }
        else
        {
           if (rx != 1)
           {
              if ((io && nx/2) || (!io && !(nx/2)))
              {
                 if (lb->obase[axis] < labelbase)
                    lb->obase[axis] = labelbase;
              }
              else
              {
                 if (lb->ibase[axis] > labelbase)
                     lb->ibase[axis] = labelbase;
              }
           }
           else
              *fpt = lev[level+1];
        }
     }

     tic[base] = lev[level];
     tic[rx] = pos;       

     if (tic[rx] <= gf->mx_sca[sx])
     {
        if (gf->plot && rx == 1)
        {
           st = sine(pos);
           ct = cosin(pos);
           if (axis==4)
           {
              if (thcnt>=0 && thcnt<=180)
              {
                  chr_dspl(vp,r*ct,r*st,0.0,pos-90,0.0,
                          rot,hv,0,nlabel,-1,color);
              }
              else
              {
                  chr_dspl(vp,r*ct,r*st,0.0,pos+90,0.0,
                          rot,hv,0,nlabel,-1,color);
              }
           }
           else
              chr_dspl(vp,r*ct,r*st,0.0,0.0,0.0,rot,hv,
                          0,label,-1,color);
        }
        else
           chr_dspl (vp, tic[0], tic[1], tic[2],phi,0.0,rot,hv,just,
                                nlabel,-1,color);
     }
  }

  if (!gf->plot)
  {
     for (j=3,i=0; i<3; ++i,++j) 
     {
        wn->axis[i] = save[i];
        wn->plot[i] = plt[i];
        wn->plot[j] = plt[j];
     }

     scale_win ();
  }

  font (sav_font);
  clip (vp,sav_clip);
  chr_size (sav_csize);
  return (1);
}
