#include "gph_str.h"
#include "gph_ansi.h"
#define sign(a) (((a)>0) ? 1 : -1)

static ByTe_1 rcsid[] = "$Id: init_plot.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 init_plot (ByTe_1 gn, ByTe_1 x, ByTe_1 y, ByTe_1 z)
{
   extern struct config   parm;
   struct graph    *gf;
   struct numbers  *nm;
   struct labels   *lb;
   ReaL_4 val,r[6];
   register ReaL_4 *fpta,*fptb,*fptc,*fptd;
   register ByTe_2 i;
   ByTe_1 ma,mb,mc;
   ReaL_4 temp,mxmn[8],theta[2],rad[2],scale[4];
   ReaL_4 dx,dy,delta;
   int j,start;

   plotnm (gn,"INIT_PLOT",0);
   if (parm.grf->defsca == 0)
   {
      g_error ("INIT_PLOT","AXIS SCALING NOT DEFINED YET",0);
      return (0);
   }

   gf = parm.grf;
   nm = gf->num;
   lb = gf->lab;
   gf->window = -gn - 1;

   if (x < 0 || x > 3)
   {
      g_error ("INIT_PLOT","UNDEFINED X AXIS - SET TO 0",0);
      x = 0;
   }

   if (y < 4 || y > 7)
   {
      g_error ("INIT_PLOT","UNDEFINED Y AXIS - SET TO 4",0);
      y = 4;
   }

   if (z < 8 || z > 11)
   {
      g_error ("INIT_PLOT","UNDEFINED Z AXIS - SET TO 8",0);
      z = 8;
   }

   for (fpta = r, fptb = gf->loc; fpta < r+6;)
         *fpta++ = *fptb++;

   gf->axis[0] = x;
   gf->axis[1] = y;
   gf->axis[2] = z;
    
   x = x/2;
   y = y/2;
   z = z/2;
  
   if (gf->plot)
   {
      rad[0]   = gf->mn_sca[0];
      rad[1]   = gf->mx_sca[0];
      theta[0] = gf->mn_sca[2];
      theta[1] = gf->mx_sca[2];
      if (theta[0] > theta[1])
         theta[0] -= 360.;

      /* Fill max-min array */

      for (i=0 ; i<2 ; ++i)
         for (j=0 ; j<2 ; ++j)
         {
            mxmn[j+i*2] = rad[i] * cosin (theta[j]);
            mxmn[4+j+i*2] = rad[i] * sine (theta[j]);
         }

      /* If section includes an axis then scaling boundary in that          
         direction is the outer radius in that direction.  Otherwise,
         the boundary is the respective maximum or minimum value of the
         four possible combinations of radius times theta for that direction */

      for (i=0 ; i<=3 ; ++i)
         if (((theta[0] <= i*90) && (theta[1] >= i*90))
              || ((theta[0] < 0) && ((theta[0]+360) <= i*90)))
         {
            temp = i-1.5;
            scale[i] = -sign(temp) * rad[1];
         }
         else
         {
            start = i%2 * 4;
            scale[i] = mxmn[start];
            for (j=start ; j<=(start+3) ; ++j)
               if (i/2 == 0)
               {
                  /* MAXIMUM */
                  if (scale[i] < mxmn[j])
                     scale[i] = mxmn[j];
               }
               else
               {
                  /* MINIMUM */
                  if (scale[i] > mxmn[j])
                     scale[i] = mxmn[j];
               }
         }

      dx = scale[0] - scale[2];    dy = scale[1] - scale[3];      
      if (dx>dy)
      {
         delta = (dx-dy)/2.;
         scale[1] += delta;
         scale[3] -= delta;
      }
      else
      {
         delta = (dy-dx)/2.;
         scale[0] += delta;
         scale[2] -= delta;
      }

      ma = (gf->mode % 2 == 1) ? 1 : 0; 
      mb = gf->mode / 4; 
      set_wn_def (gf->window,1,ma,mb);
      axis_scale(gf->window,0,0,0);

      set_rsqwin (gf->window,gf->baswin,r[0],r[1],r[2],r[3],scale[2],
                  scale[3],0.0,scale[0],scale[1],0.0);
   }
   else
   {
      ma = (gf->mode % 4 == 3) ? 1 : 0; 
      mb = gf->mode / 4; 
      mc = (gf->mode % 4 == 0) ? 0 : 1;
      set_wn_def (gf->window,mc,ma,mb);

/*** set axis scaling to linear in case window is already open and  ***/
/*** we are just rescaling window - scaling will be set later       ***/

      axis_scale(gf->window,0,0,0);

      if ((gf->mode / 2) % 2 == 1)
         set_rsqwin (gf->window,gf->baswin,r[0],r[1],r[2],r[3],
                    gf->mn_sca[x],gf->mn_sca[y],gf->mn_sca[z],
                    gf->mx_sca[x],gf->mx_sca[y],gf->mx_sca[z]);
      else
         set_relwin (gf->window,gf->baswin,r[0],r[1],r[2],r[3],r[4],
                    r[5],gf->mn_sca[x],gf->mn_sca[y],gf->mn_sca[z],
                    gf->mx_sca[x],gf->mx_sca[y],gf->mx_sca[z]);
   }

   axis_scale(gf->window,gf->scale[x],gf->scale[y],gf->scale[z]);

   fpta = lb->ibase;
   fptb = lb->obase;
   fptc = nm->ibase;
   fptd = nm->obase;
   for (i=0; i<6; ++i)
   {
       if (gf->plot == 1)
             val = (i/2) ? gf->mx_sca[0] : 0.0;
       else
       {
          if (gf->format == 1 && gf->tstyle < 2)
             val = (i/2) ? gf->mn_sca[0] / (gf->mn_sca[0] - gf->mx_sca[0]) :
                           gf->mn_sca[2] / (gf->mn_sca[2] - gf->mx_sca[2]);
          else
             val = (i%2) ? 1.0 : 0.0;
       }
       *fpta++ = val;
       *fpta++ = val;
       *fptb++ = val;
       *fptb++ = val;
       *fptc++ = val;
       *fptc++ = val;
       *fptd++ = val;
       *fptd++ = val;
   }
   return (1);
}
