/**************************************************************/
/*  Draw tick marks along the axis of polar plot.             */
/**************************************************************/

#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: dr_tic2.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 dr_tic2 (ByTe_1 gn, ByTe_1 axis, ByTe_1 mjmntic, ReaL_4 pos)
{
   extern struct config parm;
   struct graph    *gf;
   struct window   *wn;
   struct labels   *lb;
   struct numbers  *nm;
   ByTe_1 mntics;
   ByTe_1 sav_clip;
   ReaL_4 conv,tot_len;
   ReaL_4 tic_majs,tic_mins;
   register ByTe_1 *c1;
   register ByTe_2 j,k;
   ReaL_4 tic_len;
   ReaL_4 len[2], x[2], y[2], v[2];
   ReaL_4 xx, yy;
   ByTe_1 tdir,vp;
   ReaL_4 up_dn[2];
   ReaL_4 tmp[2], A1, A2;
   ByTe_2 last,rx,sx,nx,ox,mjtics;
   ReaL_4 smax,smin;
   ByTe_1 twn;
   ByTe_1 full[2];
 
   gf = parm.grf;                                  /* ptr to graph struct   */
   lb = gf->lab;                                   /* ptr to label struct   */
   nm = gf->num;                                   /* ptr to number struct  */
   vp = gf->window;                                /* plot window number    */

   wn = parm.win;                                  /* ptr to window struct  */                                  
   sav_clip = wn->clip;                            /* save cur clip info    */
   clip (vp,0);                                    /* turn clipping off     */

   rx = axis/4;                                    /* axis X, Y, or Z       */
   nx = axis%4;                                    /* which X, Y, or Z axis */
   sx = axis/2;                                    /* which pair X,Y,Z asis */
   ox = (rx == 1) ? 0 : 1; 

            
   mntics = gf->mn_tcs[sx];                        /* number of minor ticks */
   tdir = (rx == 1) ? 'X' : 'Y';                   /* tick lie in this dir  */

     /**************************************************************/
     /* Derive factor which will allow us to convert the requested */
     /* tick length to absolute plotting units (0 to 32767)        */
     /**************************************************************/

   conv = 32.0 / wn->slope[ox];                          
   if (gf->tstyle % 2 == 1)
   {
       twn = gf->t_win;
       if (window (twn,"DR_TIC") == 0)
          g_error ("DR_TIC","ALTERNATE TIC WINDOW HAS NOT BEEN OPENED",0);
       else
       {
          conv /= wn->real[4] - wn->real[1];
          conv *= parm.win->real[4] - parm.win->real[1];
       }

       parm.win = wn;
   }
   else
      twn = gf->window;

   mjtics = auto_tic (gn,axis,up_dn);          /* how many mj ticks?    */
   if (up_dn[0] > up_dn[1])                    /* increasing in mag?    */
   {                                           /* NO!                   */
      tmp[0]   = up_dn[0];                     /* reverse direction     */
      up_dn[0] = up_dn[1];
      up_dn[1] = tmp[0];
      smax     = gf->mn_sca[sx];               /* max value of tick     */
      smin     = gf->mx_sca[sx];               /* min value of tick     */
   }
   else                                        /* YES!                  */
   {
      smin     = gf->mn_sca[sx];               /* min value of tick     */
      smax     = gf->mx_sca[sx];               /* max value of tick     */
   }

   tot_len = up_dn[1] - up_dn[0];              /* total distance ticked */
   tic_majs = tot_len/(gf->mj_tcs[sx]);        /* dis between mj ticks  */
   tic_mins = tic_majs/mntics;                 /* dis between mn ticks  */
   last = mntics - 2;                          /* num of mn tics drawn  */

   if (rx == 0)
   {
      x[0] = gf->mn_sca[0];
      x[1] = gf->mn_sca[0];
    
      for (j=0; j<2; ++j) 
      {
         full[j] = 0;
         tic_len = (j == 0) ? gf->mj_tc_len[sx] : gf->mn_tc_len[sx];
         tic_len *= conv;
         if (tic_len > 32767.0)
            tic_len = 32767.0;

         c1 = (j== 0) ? gf->mj_tc_fmt : gf->mn_tc_fmt;

         switch (*c1) 
         {
            case 1:
               tmp[j] = tic_len;
               len[j] = tic_len;
               if (lb->ibase[(ByTe_2)axis] < tic_len)
                  lb->ibase[(ByTe_2)axis] = tic_len;
               if (nm->ibase[(ByTe_2)axis] < tic_len)
                  nm->ibase[(ByTe_2)axis] = tic_len;
               break;
            case 2:
               tmp[j] = -tic_len;
               len[j] = tic_len;
               if (lb->obase[(ByTe_2)axis] > -tic_len)
                  lb->obase[(ByTe_2)axis] = -tic_len;
               if (nm->obase[(ByTe_2)axis] > -tic_len)
                  nm->obase[(ByTe_2)axis] = -tic_len;
               break;
            case 3:
               tmp[j] = -tic_len;
               len[j] = 2 * tic_len;
               if (lb->ibase[(ByTe_2)axis] < tic_len)
                  lb->ibase[(ByTe_2)axis] = tic_len;
               if (nm->ibase[(ByTe_2)axis] < tic_len)
                  nm->ibase[(ByTe_2)axis] = tic_len;
               if (lb->obase[(ByTe_2)axis] > -tic_len)
                  lb->obase[(ByTe_2)axis] = -tic_len;
               if (nm->obase[(ByTe_2)axis] > -tic_len)
                  nm->obase[(ByTe_2)axis] = -tic_len;
               break;
            case 4:
               full[j] = 1;
               x[j] = gf->mn_sca[2];               /* set min theta         */
               y[j] = gf->mx_sca[2];               /* set max theta         */
               if (x[j] > y[j])                    /* make max > min        */
                   x[j] -= 360;
               break;
         }
      }

      A1 = gf->mn_sca[2];
      A2 = A1 + 90.0;
      switch (mjmntic) 
      {
         case 1:
            v[0] = up_dn[0]; 
            for (j=0; j<mjtics; ++j) 
            {
               if (full[0] == 1)
                  arc (vp,0.0,0.0,0.0,v[0],x[0],y[0],1.0,0);
               else
               {
	          xx = v[0] * cosin(A1) + tmp[0] * cosin(A2);
	          yy = v[0] * sine(A1) + tmp[0] * sine(A2);
                  VecTor (vp, xx, yy, 0.0, len[0], A2, 90.0);
               }
                              
               v[1] = v[0];
               for (k = 0; k <= last; ++k) 
               {
                  v[1] += tic_mins;

                  if (v[1] > smax)
                     continue;

                  if (full[1] == 1)
                     arc (vp,0.0,0.0,0.0,v[1],x[1],y[1],1.0,0);
                  else
                  {
	             xx = v[1] * cosin(A1) + tmp[1] * cosin(A2);
	             yy = v[1] * sine(A1) + tmp[1] * sine(A2);
                     VecTor (vp, xx, yy, 0.0, len[1], A2, 90.0);
                  }
               }
   
               v[0] += tic_majs; 
            }
          break;
   
          case 2:
             v[0] = pos;             
             if (v[0] > smax)
                break;

             if (full[0])
                arc (vp,0.0,0.0,0.0,v[0],x[0],y[0],1.0,0);
             else
             {
	         xx = v[0] * cosin(A1) + tmp[0] * cosin(A2);
	         yy = v[0] * sine(A1) + tmp[0] * sine(A2);
                 VecTor (vp, xx, yy, 0.0, len[0], A2, 90.0);
             }

             break;

          case 3:
             v[1] =  pos;         
             if (v[1] > smax)
                break;

             if (full[1])
                arc (vp,0.0,0.0,0.0,v[1],x[1],y[1],1.0,0);
             else
             {
	        xx = v[1] * cosin(A1) + tmp[1] * cosin(A2);
	        yy = v[1] * sine(A1) + tmp[1] * sine(A2);
                VecTor (vp, xx, yy, 0.0, len[1], A2, 90.0);
             }
             break;
      }    
   }
   else
   {
      for (j=0; j<2; ++j) 
      {
         tic_len = (j == 0) ? gf->mj_tc_len[sx] : gf->mn_tc_len[sx];
         tic_len *= conv;
         if (tic_len > 32767.0)
            tic_len = 32767.0;

         c1 = (j== 0) ? gf->mj_tc_fmt : gf->mn_tc_fmt;

         switch (*(c1+sx)) 
         {
            case 1:
               x[j] = gf->mx_sca[0];
               y[j] = gf->mx_sca[0] + tic_len;
               len[j] = tic_len;
               if (lb->ibase[(ByTe_2)axis] < y[1])
                  lb->ibase[(ByTe_2)axis] = y[1];
               if (nm->ibase[(ByTe_2)axis] < y[1])
                  nm->ibase[(ByTe_2)axis] = y[1];
               break;
            case 2:
               x[j] = gf->mx_sca[0] - tic_len;
               y[j] = gf->mx_sca[0] - tic_len;
               len[j] = tic_len;
               if (lb->obase[(ByTe_2)axis] > y[1])
                  lb->obase[(ByTe_2)axis] = y[1];
               if (nm->obase[(ByTe_2)axis] > y[1])
                  nm->obase[(ByTe_2)axis] = y[1];
               break;
            case 3:
               x[j] = gf->mx_sca[0] - tic_len;
               y[j] = gf->mx_sca[0] - tic_len;
               len[3] = 2.0 * tic_len;
               if (lb->ibase[(ByTe_2)axis] < y[1])
                  lb->ibase[(ByTe_2)axis] = y[1];
               if (nm->ibase[(ByTe_2)axis] < y[1])
                  nm->ibase[(ByTe_2)axis] = y[1];
               if (lb->obase[(ByTe_2)axis] > y[1])
                  lb->obase[(ByTe_2)axis] = y[1];
               if (nm->obase[(ByTe_2)axis] > y[1])
                  nm->obase[(ByTe_2)axis] = y[1];
               break;
            case 4:
               len[j] = gf->mx_sca[0]; 
               x[j] = 0.0;
               break;
         }
      }

      switch (mjmntic) 
      {
         case 1:
            v[0] = up_dn[0]; 
            for (j=0; j<mjtics; ++j) 
            {
               xx = x[0] * cosin(v[0]);
               yy = x[0] * sine(v[0]);
               VecTor(vp, xx, yy, 0.0, len[0], v[0], 90.0);
                              
               v[1] = v[0];
              
               for (k = 0; k <= last; ++k) 
               {
                  v[1] += tic_mins;
                  if (v[1] > smax)
                     continue;

                  xx = x[1] * cosin(v[1]);
                  yy = x[1] * sine(v[1]);
                  VecTor (vp, xx, yy, 0.0, len[1], v[1], 90.);

                }
   
                v[0] += tic_majs; 
             }
             break;
   
          case 2:
             v[0] = pos;             
             if (v[0] > smax)
                break;

             xx = x[0] * cosin(v[0]);
             yy = x[0] * sine(v[0]);
             VecTor(vp, xx, yy, 0.0, len[0], v[0], 90.0);

             break;

          case 3:
             v[1] =  pos;         
             if (v[1] > smax)
                break;

             xx = x[1] * cosin(v[1]);
             yy = x[1] * sine(v[1]);
             VecTor (vp, xx, yy, 0.0, len[1], v[1], 90.);
             break;
      }    
   }

   clip (vp, sav_clip);
   return (1);
} 
