/**************************************************************/
/*  Draw tick marks along the axis of cartesian plot where    */
/*  the tick marks are drawn along the outer rectangular      */
/*  boarder.                                                  */
/**************************************************************/

#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: dr_tic1.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 dr_tic1 (ByTe_1 gn, ByTe_1 axis, ByTe_1 mjmntic, ReaL_4 pos)
{
   extern struct config parm;
   struct graph    *gf;
   struct window   *wn;
   struct labels   *lb;
   struct numbers  *nm;
   ByTe_1 loc,ofset,chk,mntics;
   ReaL_4 conv,sgn,tot_len;
   ReaL_4 tic_majs,tic_mins;
   register ReaL_4 *f1;
   register ByTe_1 *c1,*c2;
   register ByTe_2 i,j,k;
   ReaL_4 plt[6],tic[12],tic_len, *f2[4];
   ReaL_4 taxis;
   ByTe_1 tdir,off[4],vp,save[3];
   ReaL_4 up_dn[2];
   ReaL_4 tmp;
   ByTe_2 beg,first,last,skip,sx,rx,nx,ox,mjtics;
   ReaL_4 smax,smin;
   ByTe_1 twn;
 
   gf = parm.grf;                                  /* ptr to graph struct   */
   lb = gf->lab;                                   /* ptr to label struct   */
   nm = gf->num;                                   /* ptr to number struct  */
   vp = gf->window;                                /* plot window number    */

   wn = parm.win;                                  /* ptr to window struct  */                                  
   rx = axis/4;                                    /* axis X, Y, or Z       */
   nx = axis%4;                                    /* which X, Y, or Z axis */
   sx = axis/2;                                    /* which pair X,Y,Z asis */
   ox = (rx == 1) ? 0 : 1; 
   off[0] = lb->base_set[axis] % 2;                /* inside labels?        */
   off[1] = nm->base_set[axis] % 2;                /* inside numbers?       */
   off[2] = lb->base_set[axis] / 2;                /* ouside labels?        */
   off[3] = nm->base_set[axis] / 2;                /* outside numbers?      */

   for (k=0,j=3; k<3; ++k,++j)                     /* save axis info        */
   {
      save[k] = wn->axis[k];                       /* save axis format      */
      wn->axis[k] = 0;                             /* set format to linear  */
      plt[k] = wn->plot[k];                        /* save XYZ mins         */
      plt[j] = wn->plot[j];                        /* save XYZ maxs         */
      wn->plot[k] = 0.0;                           /* XYZ mins to 0         */
      wn->plot[j] = 1.0;                           /* XYZ maxs to 0         */
   }

   wn->axis[rx] = gf->scale[sx];                   /* reset ticked axis fmt */
   wn->plot[rx]   = gf->mn_sca[sx];
   wn->plot[rx+3] = gf->mx_sca[sx];

   scale_win (2);                                  /* rescale window        */
            
   mntics = gf->mn_tcs[sx];                        /* number of minor ticks */
   tdir = (rx == 1) ? 'X' : 'Y';                   /* tick lie in this dir  */
   sgn = (nx/2) ? -1.0 : 1.0;                      /* set sense             */
   if (parm.ostyle == 1 && rx == 1)                /* y axis and portrait   */
      sgn = -sgn;                                  /* reverse sign          */

     /**************************************************************/
     /* Derive factor which will allow us to convert the requested */
     /* tick length to absolute plotting units (0 to 32767)        */
     /**************************************************************/

   conv = 32.0 / wn->slope[ox];                          
   if (gf->tstyle % 2 == 1)
   {
       twn = gf->t_win;
       if (window (twn,"DR_TIC") == 0)
          g_error ("DR_TIC","ALTERNATE TIC WINDOW HAS NOT BEEN OPENED",0);
       else
       {
          conv /= wn->real[4] - wn->real[1];
          conv *= parm.win->real[4] - parm.win->real[1];
       }

       parm.win = wn;
   }
   else
      twn = gf->window;

   mjtics = auto_tic (gn,axis,up_dn);             /* how many mj ticks?    */
   if (up_dn[0] > up_dn[1])                       /* increasing in mag?    */
   {                                              /* NO!                   */
      tmp      = up_dn[0];                        /* reverse direction     */
      up_dn[0] = up_dn[1];
      up_dn[1] = tmp;
      smax     = gf->mn_sca[sx];                  /* max value of tick     */
      smin     = gf->mx_sca[sx];                  /* min value of tick     */
    }
    else                                           /* YES!                  */
    {
       smin     = gf->mn_sca[sx];                  /* min value of tick     */
       smax     = gf->mx_sca[sx];                  /* max value of tick     */
    }
    
    if (gf->scale[sx])                             /* this is a log axis?   */
    {                                              /* YES!                  */
       if (mntics > 9)                             /* max 9 ticks/division  */
           mntics = 9; 
       first = 2;                                  /* begin mntic 2*10**?   */
       skip = 10/mntics;
       last = (mntics == 3) ? 5 : mntics * skip;  
       if (last >= 10)
          last = 9;
       else
          if (mntics == 1)
             last = 1;
    }
    else
    {
       tot_len = up_dn[1] - up_dn[0];              /* total distance ticked */
       tic_majs = tot_len/(gf->mj_tcs[sx]);        /* dis between mj ticks  */
       tic_mins = tic_majs/mntics;                 /* dis between mn ticks  */
       skip = 1;                                   /* skip no ticks         */
       first = 0;                                  /* no offset for ticks   */
       last = mntics - 2;                          /* num of mn tics drawn  */
    }
    
    for (f1 = tic + rx; f1 < tic+12; f1 += 3)
        *f1 = gf->mn_sca[sx];
    
    taxis = (nx/2) ? 1.0 : 0.0;
    tmp = (nx==0 || nx == 3) ? 0.0 : 1.0;
  
    beg = (rx == 2) ? 0 : 2;
    for (f1 = tic+beg; f1 < tic+12; f1 += 3)
         *f1 = tmp;

    for (j=0,f1=tic+ox; j<2; ++j,f1+=6) 
    {
       tic_len = (j == 0) ? gf->mj_tc_len[sx] : gf->mn_tc_len[sx];
       tic_len *= conv;
       if (tic_len > 32767.0)
          tic_len = 32767.0;

       c1 = (j== 0) ? gf->mj_tc_fmt : gf->mn_tc_fmt;
       ofset = (*(c1+sx) == 2) ? 2 : 0;
       c2 = off + ofset;

       tic_len = get_sqln (twn,tdir,tic_len);

       switch (*(c1+sx)) 
       {
          case 1:
             *(f1+3) = taxis + sgn*tic_len;
             *f1 = taxis;
             break;
          case 2:
             *(f1+3) = taxis - sgn*tic_len;
             *f1 = taxis;
             break;
          case 3:
             *(f1+3) = taxis - tic_len;
             *f1 = taxis + tic_len;
             break;
          case 4:
             *f1 = 0.0;
             *(f1+3) = 1.0;
             break;
       }

       f2[0] = &lb->ibase[axis];
       f2[1] = &nm->ibase[axis];
       f2[2] = &lb->obase[axis];
       f2[3] = &nm->obase[axis];

       if (*(c1+sx) != 4)
       {
          if (*(c1 + sx) == 2)
             chk = (nx/2 == 0) ? 0 : 1;
          else
             chk = (nx/2 == 0) ? 1 : 0;

          for (i = ofset; i < 2 + ofset; ++i)
          {
             if (!(*c2++))
             {
                if (chk)
                {
                   if (*f2[i] < *(f1+3))
                      *f2[i] = *(f1+3);
                }
                else
                {
                   if (*f2[i] > *(f1+3))
                      *f2[i] = *(f1+3);
                }

                if (*(c1 + sx) == 3)
                {
                   loc = ((*c1+sx) == 3) ? i%2 + 2 : i;
                   if (chk)
                   {
                       if (*f2[loc] > *(f1+3))
                          *f2[loc] = *(f1+3);
                   }
                   else
                   {
                      if (*f2[loc] < *(f1+3))
                         *f2[loc] = *(f1+3);
                   }
                }
             }
          }
       }
    }

    switch (mjmntic) 
    {
       case 1:
          if (up_dn[0] > smin)
          {
             tic[rx]=(gf->scale[sx]) ? up_dn[0]/10.0 : up_dn[0] - tic_majs;
             tic[rx+6] = tic[rx];
             for (j=first; j<=last; j+=skip) 
             {
                if (gf->scale[sx]) 
                   tic[rx+6] = tic[rx]*j;
                else
                   tic[rx+6] += tic_mins;
                if (tic[rx+6] < smin)
                   continue;
                tic[rx+9] = tic[rx+6];
                line (vp,tic[6],tic[7],tic[8],tic[9],tic[10],tic[11]);
             }
          } 
          

          tic[rx] = up_dn[0]; 
          for (j=0; j<mjtics; ++j) 
          {
             tic[rx+3] = tic[rx];
             line (vp,tic[0],tic[1],tic[2],tic[3],tic[4],tic[5]);

             tic[rx+6] = tic[rx];
              
             for (k=first; k<=last; k+=skip) 
             {
                if (gf->scale[sx])
                   tic[rx+6] = tic[rx]*k;
                else 
                   tic[rx+6] += tic_mins;

                if (tic[rx+6] > smax)
                   continue;

                tic[rx+9] = tic[rx+6];
                
                line (vp,tic[6],tic[7],tic[8],tic[9],tic[10],tic[11]);
             }
   
             if (gf->scale[sx])
                tic[rx] *= 10;
             else
                tic[rx] += tic_majs; 

          }
          break;
   
       case 2:
          tic[rx] = pos;             
          if (tic[rx] > smax)
             break;
          tic[rx+3] = tic[rx];

          line (vp,tic[0],tic[1],tic[2],tic[3],tic[4],tic[5]);

          break;

       case 3:
          tic[rx+6] =  pos;         
          if (tic[rx+6] > smax)
             break;
          tic[rx+9] = tic[rx+6];

          line (vp,tic[6],tic[7],tic[8],tic[9],tic[10],tic[11]);

          break;
   }

   RestoreSet (save, plt, -1, 100, -1);

   return (1);
} 
