#include "gph_str.h"
#include "gph_ansi.h"

ByTe_4 edges[11] = {5,10,15,20,25,30,40,50,75,100,150};

static ByTe_1 rcsid[] = "$Id: auto_scale.c,v 1.1 1999/11/21 07:58:16 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 auto_scale(ByTe_1 gn, ByTe_1 axis, ReaL_4 *data, ByTe_2 ele, 
                  ReaL_4 *min, ReaL_4 *max, ReaL_4 intvl)    
{
   extern struct config parm;
   register struct graph *gf;
   register ByTe_4  *l1;
   register ByTe_2 side;
   ReaL_4  totlen;
   ReaL_4  base,val,slip;
   ReaL_4  ratio;
   ReaL_4  frac,mx,mn;
   ByTe_4   diff,inc,rmd,tics;
   ByTe_1   expon;
   ByTe_1   ok = 1, mjtic,error;

/*********************************************************************/
/*  Check to see if the plot has been defined                        */
/*********************************************************************/

   plotnm (gn,"AUTO_SCALE",0);  

/*********************************************************************/
/*  Set pointer to the plot information structure                    */
/*********************************************************************/

   gf = parm.grf;              
                              
/*********************************************************************/
/*  If a legal axis number was not selected then return an error     */
/*********************************************************************/

   if (axis < 0 || axis > 11)
   {
      g_error ("AUTO_SCALE","ILLEGAL AXIS NUMBER -- NO SCALING DONE",0);
      *max = 1.0;
      *min = 0.1;
      return (-3);
   }
 
/*********************************************************************/
/*  Determine if this is the left, right, top or bottom axes         */
/*********************************************************************/

   side = axis/2;

/*********************************************************************/
/*  Find the maximum and minimum data value.  An error can occur in  */
/*  this search for several reasons, eg axis is log scaled and all   */
/*  of the data are less than or equal to 0.  When no max and min    */
/*  can be found - return an error.                                  */
/*********************************************************************/

   if ((error = auto_mxmn (gn,axis,data,ele,&mn,&mx)) < 0)
   {
      *max = 1.0;
      *min = 0.1;
      return (error);
   }

/*********************************************************************/
/*  Check the relationship between the max and min value, basically  */
/*  we want to know if the values are the same or different. This is */
/*  done by finding the aboslute value of the ratio of the 2 values  */
/*********************************************************************/

   ratio = (mn != 0.0) ? mx / mn : (mx != 0.0) ? mn / mx : 1.0;
   if (ratio < 0.0)
      ratio = -ratio;

/*********************************************************************/
/*  This is code used if the data max and min are the same (within   */
/*  some round off error)                                            */
/*  If they are the same then separate them slightly so that the     */
/*  autoscael code will have no problem                              */
/*  1.  Determine if the axis is linear of log scaled                */
/*      A) Log scaled                                                */
/*         i) center line about +- .01 of value                      */
/*      B) Linear scaled                                             */
/*         i) if not zero set center line about +- .01 of value      */
/*            otherwise center about -.1 and .1                      */
/*********************************************************************/

   if (ratio < 1.00001 && ratio > .99999)
   {
      if (gf->scale[side])
      {
         mx /= 0.1;
         mn *= 0.1;
      }
      else
      {
         if (mn != 0.0)
         { 
            mx += (mx > 0.0) ? 0.01 * mx : -0.01 * mx;
            mn -= (mn > 0.0) ? 0.01 * mn : -0.01 * mn;
         }
         else
         {
            mn = -0.1;
            mx = 0.1;
         }
      }
   }

/*********************************************************************/
/*  How many major ticks are there along the axis                    */
/*********************************************************************/

   mjtic = gf->mj_tcs[side];

/*********************************************************************/
/*  If intvl is <= to zero then this is a free form auto scale -     */
/*  there is no user restrictions and we can do what we think is     */
/*  best.  This is only important if the axis is linear scaled.  Log */
/*  scaled axes ignore intvl altogether                              */
/*********************************************************************/

   if (intvl <= 0.0 && gf->scale[side] == 0)
   {

/*********************************************************************/
/*  Determine the following                                          */
/*  totlen - the interval between each major tick mark               */
/*  base   - 10**x which will reduce totlen to value between 0 & 10  */
/*  expon  - the exponent of base (x)                                */
/*  totlen - interval between each major tic marks between 0 & 100   */
/*  inc    - integer portion of totlen                               */
/*********************************************************************/

      totlen = (mx - mn) / mjtic;
      base   = base_log (totlen, 0, &expon);
      totlen = totlen * 10 / base; 
      inc    = totlen;

/*********************************************************************/
/*  Using inc determine the best interval between tick marks from a  */
/*  small subset of predetermined values                             */
/*********************************************************************/

      l1 = edges;
      while ((inc > *l1) && (l1 < edges + 9))
         ++l1;

/*********************************************************************/
/*  At this point we begin to find the best max and min value.  This */
/*  may take a couple of iterations so we do it in a loop            */
/*********************************************************************/

      while (ok)
      {

/*********************************************************************/
/*  1. Get the interval to used between the tick marks (add back the */
/*     factor of 10**x we removed and remove factor of 10 built into */
/*     edges array).                                                 */
/*  2. Get half the distance normalized to the tic interval.         */
/*********************************************************************/
     
         val   = *l1 * base / 10.0;
         diff  = (val*mjtic - mx + mn) / val / 2.0;

/*********************************************************************/
/*  Compute the minimum and maximum values.                          */
/*********************************************************************/

         *min  = ((ByTe_4)(mn / val) - diff)  * val;
         *max  = *min + mjtic * val;

/*********************************************************************/
/*  If the minimum is not small enough can we just shift it down and */
/*  still cover the max data.  If not then go to the next edge value */
/*  Make similar check for maximim if minimum is ok                  */
/*********************************************************************/

         if (*min > mn )
         {
            *min -= val; 
            *max -= val; 
            if (*max < mx)
            {
               ++l1;
               continue;
            }
         }
         else
         {
            if (*max < mx )
            {
               *min += val; 
               *max += val; 
               if (*min > mn)
               {
                  ++l1;
                  continue;
               }
            }
         }

/*********************************************************************/
/*  If the value we have chosen between tick marks ends in a five    */
/*  then decrease the value of expon which will be used to indicate  */
/*  the number of decimal places needed to fully state value at each */
/*  tick mark                                                        */
/*********************************************************************/

         if (((*l1 / 5) % 2) == 1) 
            --expon;

         expon = (expon >= 0) ? 0 : -expon;
         ok = 0;
      }
      return (expon); 
   }

/*********************************************************************/
/*  If we got here either we have log scaling or we have linear      */
/*  scaling were the person selected his own fractional resolution   */
/*  for the major tick values                                        */
/*********************************************************************/

   expon = 0;
   switch(gf->scale[side]) 
   {
      case 0:
         totlen = (mx - mn)/intvl;             
         frac   = totlen - (ByTe_4)totlen;      
         tics   = (frac > .001) ? totlen + 1 : totlen;
         inc    = tics/mjtic;
         rmd    = tics % mjtic;

         while (ok)
         {
            if (rmd == 0 && frac == 0.0)
            {
               *min = mn;
               *max = mn + intvl * tics;
            }
            else
            {
               ++inc;
               val   = inc * intvl;
               diff  = (val * mjtic - mx + mn) / val / 2.0;

               *min  = ((ByTe_4)(mn / val) - diff)  * val;
               *max  = *min + mjtic * val;

               if (*min > mn )
               {
                  slip  = (ByTe_4)((*min - mn) / intvl + 1.0) * intvl;
                  *max -= slip;
                  if (*max > mx )
                    *min -= slip;
                  else
                     continue;
               }
               else
               {
                  if (*max > mx )
                  {
                     slip  = (ByTe_4)((mx - *max) / intvl + 1.0) * intvl;
                     *min += slip;
                     if (*min < mn )
                        *max += slip;
                     else
                        continue;
                  }
               }
            }

            ok = 0;
         }

         base   = base_log (intvl,0,&expon);
         expon = (expon >= 0) ? 0 : -expon;

         break;

      case 1:

         *min = base_log (mn,0,&expon);
         *max = base_log (mx,1,&expon);
         break;
   }

   return (expon);
}

#include <math.h>
ReaL_4 base_log (ReaL_4 value, ByTe_1 ceiling, ByTe_1 *expon)
{
    ReaL_4 log_val;
    ReaL_4 ret_val;
    ReaL_4 rem;
    ByTe_4  exponet;

    log_val = log10((ReaL_8)value);
      
    exponet = log_val;
    rem = log_val - exponet;
    if (rem < 0.0)
       rem = -rem;

    if (!ceiling)
    {
       if (log_val < 0.0)
          exponet = (rem > .001) ? exponet - 1 : exponet;
       else
          exponet = (rem > .999) ? exponet + 1 : exponet;
    }
    else
    {
       if (log_val < 0.0)
          exponet = (rem > .999) ? exponet - 1 : exponet;
       else
          exponet = (rem > .001) ? exponet + 1 : exponet;
    }
   
    ret_val = pow_ten(exponet);
    *expon = exponet;

    return (ret_val);
}
