#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: auto_mxmn.c,v 1.1 1999/11/21 07:58:16 chris.gurgiolo.b2r Stab chrisg $";

/*********************************************************************
*                                                                    *
*                        MAXMIN  SUBROUTINE                          *
*                                                                    * 
*  DESCRIPTION                                                       * 
*    This routine searches for the biggest and smallest number       * 
*    in an array. If the axis scale is logarithmic then and          *
*    the minimum or maximum is <= 0.0 then the routine will          *
*    return a negative one indicating that the scaling will          *
*    will not work on the axis requested.  The routine returns       *
*    the maximum and minimum values in the data array even           *
*    when the values will not work on the requested axis.            *
*                                                                    * 
*  INPUT VARIABLES                                                   * 
*    char             gn            graph number                     *
*    char             axis          axis against which the data is   *
*                                   is to be plotted                 *
*    short register   ele           size of the array                * 
*    float           *data          pointer to the array containing  *
*                                   the numbers to be used           * 
*    float           *max           pointer to the maximum number    * 
*    float           *min           pointer to the minimum number    * 
*                                                                    * 
*  USAGE                                                             * 
*    char maxmin(gn,axis,data,ele,&max,&min)                         * 
*                                                                    * 
*  NECESSARY SUBPROGRAMS                                             * 
*    none                                                            * 
*                                                                    * 
*  EXTERNAL VARIABLES                                                * 
*    none                                                            * 
*                                                                    * 
*  INTERNAL VARIABLES                                                * 
*    float register  *da            pointer to the first element     * 
*                                   in the y array.                  * 
*                                                                    * 
*  BUGS                                                              * 
*                                                                    * 
*********************************************************************/

ByTe_1 auto_mxmn (ByTe_1 gn, ByTe_1 axis, ReaL_4 *data, register ByTe_2 ele,
                ReaL_4 *min, ReaL_4 *max)
{
   extern struct config parm;
   struct graph *gf;
   register ReaL_4 *da;
   register ReaL_4 omit;
   register ByTe_1 bad;
   ByTe_1 sc;
   ByTe_1 error = 1;
   ByTe_1 go = 1;

   plotnm (gn,"AUTO_MXMN",0);

   gf = parm.grf;

   if (axis < 0 || axis > 11)
   {
      g_error ("AUTO_MXMN","ILLEGAL AXIS - NO SCALING DONE",0);
      return (-3);
   }
  
   bad = gf->bad_data[axis/4];
   if (bad != 'O')
      omit = gf->exclude[axis/4];

   sc = gf->scale[axis/2];
   da  = data;

   /*** storing the first element of the array in max and min  ***/
 
   if (bad != 'O')
   {
      while (go)
      {
         switch (bad)
         {
            case 'L':
               do
               {
                  *max = *da++;
               } while (*max < omit && da < data + ele);
               break;
            case 'E':
               do
               {
                  *max = *da++;
               } while (*max != omit && da < data + ele);
               break;
            case 'G':
               do
               {
                  *max = *da++;
               } while (*max > omit && da < data + ele);
               break;
         }

         if (*max <= 0.0 && sc == 1)
            error = 0;
         else
            go = 0;
      }

      if (da >= data + ele)
      {
         if (error == 0)
            g_error ("AUTO_MXMN","ALL VALUES <= 0 WITH LOG SCALING",0);
         return (-1);
      }
     
      *min = *max;

   /*** searching for the biggest number in the array  ***/
 
      switch (bad)
      {
         case 'L':
            for ( ; da < data+ele; ++da)
	        if (*da >= omit)
	        {
	           if (*max < *da)
	              *max = *da;
                   if (sc == 0 || *da > 0.0)
	           {
                      if (*min > *da)
                         *min = *da;
                   }
                   else 
	              error = 0; 
                }
            break;
         case 'E':
            for ( ; da < data+ele; ++da)
	        if (*da != omit)
	        {
	           if (*max < *da)
	              *max = *da;
                   if (sc == 0 || *da > 0.0)
	           {
                      if (*min > *da)
                         *min = *da;
                   }
                   else 
	              error = 0; 
                }
                break;
         case 'G':
            for ( ; da < data+ele; ++da)
	        if (*da <= omit)
	        {
	           if (*max < *da)
	              *max = *da;
                   if (sc == 0 || *da > 0.0)
	           {
                      if (*min > *da)
                         *min = *da;
                   }
                   else 
	              error = 0; 
                }
            break;
      }
   }
   else
   {
      if (sc == 1)
      {
         while (*da <= 0.0)
           ++da;
      }

      if (da >= data + ele)
         error = -1;
      else
      {
         *max = *da;
         *min = *da;

         for ( ; da < data+ele; ++da)
         {
             if (*max < *da)
                *max = *da;
             if (sc == 0 || *da > 0.0)
	     {
                if (*min > *da)
                   *min = *da;
             }
             else 
	        error = 0; 
         }
      }
   }
 
   if (error == 0)
   {
      g_error ("AUTO_MXMN","SOME OR ALL VALUES <= 0 WITH LOG SCALING",0);
      return (error);
   }
   else
      if (error == -1)
      {
          g_error ("AUTO_MXMN","ALL VALUES <= 0 WITH LOG SCALING",0);
          return (error);
      }

   if (gf->plot == 1 && axis/4 == 1)
   {
      if (*max > 360.0)
         *max = 360.0;
      if (*min < 0.0)
      {
         *min += 360.0;
         if (*min < *max)
         {
            *min = 0.0;
            *max = 360.0;
         }
      }
   }
 
   return (1);
}
