#include <math.h>
#include <string.h>
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: pr_fmt.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

ReaL_4 pr_fmt (ByTe_1 *fmt, ByTe_1 *text, ReaL_4 V)
{
   extern struct config parm;

   register ByTe_2 loop;
   register ByTe_1  *c1, *c2, *c3;

   ReaL_4 nchr, E;
   ReaL_4 FY = 0.0;
   ReaL_4 FD = 0.0;
   ReaL_4 FH = 0.0;
   ReaL_4 FM = 0.0;
   ReaL_4 FS = 0.0;
   ReaL_4 Fm = 0.0;
   ReaL_4 Fu = 0.0;
   ReaL_4 Fn = 0.0;
   ReaL_4 F;

   ByTe_4  X;
   ByTe_4  year = 0;
   ByTe_4  day = 0;
   ByTe_4  hour = 0;
   ByTe_4  minute = 0;
   ByTe_4  second = 0;
   ByTe_4  msec = 0;
   ByTe_4  usec = 0;
   ByTe_4  nsec = 0;

   ByTe_2 pfmt = -1;

   ByTe_1  *format;
   ByTe_1  newfmt[80], hold[20];
   ByTe_1  S;

   ByTe_1 *name = "PR_FMT"; 
   ByTe_1 *error1 = "UNKNOWN FORMAT";
   ByTe_1 *error2 = "NO INPUT UNITS WITH TIME FORMAT";
   ByTe_1 *error3 = "UNKNOWN INPUT UNITS WITH TIME FORMAT";

   ByTe_1 *LOGfmt = ".3E";
   ByTe_1 *logfmt = ".3e";
   ByTe_1 *expfmt = "x'10 sup { %%d } '";

   /**************************************************************************/
   /*  Strip off the leading spaces and get down to just the format command  */
   /**************************************************************************/

   c1 = fmt;                                     /* ptr to format            */
   while (*c1 == ' ')                            /* loop over fmt to         */
       ++c1;                                     /* remove leading spaces    */

   format = c1;                                  /* ptr to de-spaced fmt     */
      
   /**************************************************************************/
   /*  The type of format command - that is how the input value must be      */
   /*  processed, can be determined by the first character in the format     */
   /*  command.  Determine the format command here and classify it           */
   /**************************************************************************/

   switch (*c1)                                  /* 1st char determines fmt  */
   {
      case '%':                                  /* normal C fomat cmd       */
         pfmt = 0;                               /* set fmt cmd type flag    */
         break;                                  /* to end of switch         */

      case '.':                                  /* following chars for fmt  */ 
      case 'E':                                  /* of A.BBBx10 sup Z        */
         pfmt = 1;                               /* set fmt cmd type flag    */
         break;                                  /* to end of switch         */

      case 'e':                                  /* fmt of exponent only?    */
         if (strcmp (format,"expon") == 0)       /* format is expon?         */
            pfmt = 2;                            /* set fmt cmd type flag    */
         else
            pfmt = 4;
         break;                                  /* to end of switch         */

      case 'l':                                  /* log fmt?                 */
         if (strcmp (format,"log") == 0)         /* format is log?           */
            pfmt = 3;                            /* set fmt cmd type flag    */
         break;                                  /* to end of switch         */

      case 'Y':                                  /* the following leading    */ 
      case 'D':                                  /* characters indicate a    */
      case 'H':                                  /* time format              */
      case 'M':
      case 'S':
      case 'm':
      case 'u':
      case 'n':
         pfmt = 5;                               /* set fmt cmd type flag    */
         break;                                  /* to end of switch         */
   }

   /**************************************************************************/
   /*  Now that we have the type of output expected, we must cast the input  */
   /*  value into that format.  Some are easy - some convoluted.             */
   /*                                                                        */
   /*  Start out with a little common preprocessing for those output formats */
   /*  deal with exponents                                                   */
   /**************************************************************************/

   if (pfmt > 0 && pfmt < 5)                     /* fmt use exponents?       */
   {                                             /* yes - preprocess         */
      if (V != 0.0)                              /* do we have exponent?     */
      {                                          /* yes!                     */
         if (V > 0.0)                            /* is value positive?       */
         {                                       /* yes!                     */
            E = log10(V);                        /* int part of log is expon */
            S = 1.0;                             /* set sign to 1.0          */ 
         }
         else                                    /* negative value!          */
         {
            E = log10(-V);                       /* int part of log is expon */
            S = -1.0;                            /* set sign to -1.0         */
         }
         X = (E < 0.0) ? E - .0005 :  E + .0005; /* round exponent           */
      }
      else                                       /* value is 0.0             */
         X = 1000;                               /* set exponent out of rng  */
   }

   switch (pfmt)                                 /* switch by format type    */
   {
      case -1:                                   /* unrecognized format      */
         g_error (name, error1, 0);              /* indicate error           */
         return (-1.0);                          /* return error status      */

      case 0:                                    /* normal C format          */
         while (*c1 != '\0' && *c1 != 'd')       /* look for 'd' in fmt str  */
             ++c1;                               /* next character           */

         if (*c1 == 'd')                         /* found a 'd'?             */
            sprintf (text, format, (ByTe_4)V);   /* yes - val output as int  */
         else                                    /* no 'd'                   */
            sprintf (text,format,V);             /* val output as is         */

         nchr = strlen (text);                   /* how many char to output  */
         break;                                  /* to end of switch         */

      case 1:                                    /* fmt is val x power ten   */
      case 4:                                    /* fmt is val x power ten   */
         c2 = newfmt;                            /* put mantissa fmt here    */
         c3 = (*c1 == 'E') ? LOGfmt : 
                  (*c1 == 'e') ? logfmt : c1;    /* requested mantissa fmt   */
         *c2++ = '%';                            /* lead off with % sign     */ 
         while (*c3 != 'E' && *c3 != 'e')        /* loop over the format     */
             *c2++ = *c3++;                      /* get mantissa format      */
         *c2++ = 'f';                            /* end with 'f' (float)     */

         if (X < 1000)                           /* valid exponent?          */
         {                                       /* yes!                     */
            loop = 0;                            /* initialize loop          */
            if (X > 0)                           /* exponent > 0?            */
               while (loop++ < X)                /* loop over exponent       */
                   V /= 10.0;                    /* remove it from value     */
            else                                 /* exponent < 0             */
               while (loop-- > X)                /* loop over value          */
                   V *= 10.0;                    /* remove it from value     */

            if (*c3 == 'E')
               sprintf (c2, expfmt);             /* form total format        */
            else
            {
               pfmt = 4;
               sprintf (c2, "E%%d");             /* form total format        */
            }

            sprintf (text, newfmt, V,X);         /* form output string       */

            if (pfmt == 1)
               nchr = strlen(text) - 12;         /* this many characters     */
            else
               nchr = strlen(text);              /* this many characters     */
         }
         else
         {
            *c2 = 0;                             /* terminate mantissa fmt   */
            sprintf (text, newfmt, V);           /* form output string       */
            nchr = strlen(text);                 /* this many characters     */
         }
         break;                                  /* to end of switch         */

      case 2:                                    /* process exponent format  */
         if (X < 999)                            /* valid exponent?          */
         {                                       /* yes                      */
            if (S == 1)                          /* positive value?          */
               sprintf (text, "%d", X);          /* form output text         */
            else                                 /* negative value           */
               sprintf (text, "(-) %d", X);      /* form output text         */
         }
         else
            sprintf (text, "(0)");               /* form output string       */

	 nchr = strlen(text);                    /* this many characters     */
         break;                                  /* to end of switch         */

      case 3:                                    /* process 10 to power      */
         if (X < 999)                            /* valid exponent?          */
         {                                       /* yes                      */
            c2 = newfmt;                         /* ptr to new format        */
            if (S == 1)                          /* positive value?          */
            {                                    /* yes!                     */
               *c2++ = 39;                       /* leading negative sign    */
               sprintf (c2, &expfmt[2]);         /* form format              */
            }
            else                                 /* negative value           */
            {
               *c2++ = '-';                      /* leading negative sign    */
               sprintf (c2, &expfmt[1]);         /* form format              */
            }

            sprintf (text, newfmt, X);           /* form output string       */
            nchr = strlen(text);                 /* this many characters     */
            nchr -= 12; 
         }
         else
         {
            sprintf (text, "0.0");               /* form output string       */
            nchr = 3;                            /* three char for 0.0       */
         }
         break;                                  /* leave switch             */
      case 5:                                    /* time                     */
         c3 = c1;                                /* ptr to user format       */
         while (*c3 != 0 && *c3 != '/')          /* loop over format         */
            c3++;                                /* next character           */

         if (*c3++ == '/')                       /* beg input value units?   */
         {                                       /* yes - get them           */
            switch (*c3)                         /* switch on input units    */
            {
                case 'Y':                        /* input is years           */
                   year = (ByTe_4)V;             /* set year                 */
                   FY = V - year;                /* fractional years         */
                   V = FY * 365.0;               /* reset input to days      */
                case 'D':                        /* input is days            */
                   day = (ByTe_4)V;              /* set day                  */
                   FD = V - day;                 /* fractional days          */
                   V = FD * 24.0;                /* reset input to hours     */
                case 'H':                        /* input is hours           */
                   hour = (ByTe_4)V;             /* set hours                */
                   FH = V - hour;                /* fractional hours         */
                   V = FH * 60.0;                /* reset input to minutes   */
                case 'M':                        /* input is minutes         */
                   minute = (ByTe_4)V;           /* set minutes              */
                   FM = V - minute;              /* fractional minutes       */
                   V = FM * 60.0;                /* reset input to seconds   */
                case 'S':                        /* input is seconds         */
                   second = (ByTe_4)V;           /* set seconds              */
                   FS = V - second;              /* fractional seconds       */
                   V = FS * 1000.0;              /* reset input to msec      */
                case 'm':                        /* input is seconds         */
                   msec = (ByTe_4)V;             /* set seconds              */
                   Fm = V - msec;                /* fractional msec          */
                   V = Fm * 1000.0;              /* reset input to usec      */
                case 'u':                        /* input is microseconds    */
                   usec = (ByTe_4)V;             /* set microseconds         */
                   Fu = V - usec;                /* fractional usec          */
                   V = Fu * 1000.0;              /* reset input to nsec      */
                case 'n':                        /* input is nanoseconds     */
                   nsec = (ByTe_4)V;             /* set nanosecoonds         */
                   Fn = V - nsec;                /* fractional nsec          */
                   break;
                default:                         /* unknown units            */
                   g_error (name, error3, 0);    /* indicate error           */
                   return (-3.0);                /* return error status      */
            }
         }
         else                                    /* can't find input units!  */
         {
            g_error (name, error2, 0);           /* indicate error           */
            return (-2.0);                       /* return error status      */
         }

         usec += nsec / 1000;                    /* ovrflw in nsec to usec   */
         nsec = nsec % 1000;                     /* reset nsec               */
         msec += usec / 1000;                    /* ovrflw in usec to msec   */
         usec = usec % 1000;                     /* reset nsec               */
         second += msec / 1000;                  /* ovrflw in msec to sec    */
         msec = msec % 1000;                     /* reset msec               */
         minute += second / 60;                  /* ovrflw in sec to min     */
         second = second % 60;                   /* reset sec                */
         hour += minute / 60;                    /* ovrflw in min to hour    */
         minute = minute % 60;                   /* reset min                */
         day += hour / 24;                       /* ovrflw in hour to day    */
         hour = hour % 24;                       /* reset hour               */
         year += day / 365;                      /* ovrflw in day to year    */
         day = day % 365;                        /* reset day                */
        
         text[0] = 0;                            /* initialize output str    */
         while (*c1 != 0 && *c1 != '/')          /* loop over format         */
         {
            c2 = text + strlen (text);           /* ptr to end of string     */
            switch (*c1)                         /* format depends on char   */
            {
               case 'Y':                         /* year                     */
                  sprintf (c2, "%4d", year);     /* put in year              */
                  F = FY;                        /* fraction to frac of year */
                  ++c1;                          /* next format character    */
                  break;                         /* leave switch             */
               case 'D':                         /* day                      */
                  sprintf (c2, "%3d", day);      /* put in day               */
                  F = FD;                        /* fraction to frac of day  */
                  ++c1;                          /* next format character    */
                  break;                         /* leave switch             */
               case 'H':                         /* day                      */
                  sprintf (c2, "%02d", hour);    /* put in hours             */
                  F = FH;                        /* fraction to frac of hr   */
                  ++c1;                          /* next format character    */
                  break;                         /* leave switch             */
               case 'M':                         /* day                      */
                  sprintf (c2, "%02d", minute);  /* put in minutes           */
                  F = FM;                        /* fraction to frac of mn   */
                  ++c1;                          /* next format character    */
                  break;                         /* leave switch             */
               case 'S':                         /* day                      */
                  sprintf (c2, "%02d", second);  /* put in seconds           */
                  F = FS;                        /* fraction to frac of sec  */
                  ++c1;                          /* next format character    */
                  break;                         /* leave switch             */
               case 'm':                         /* day                      */
                  sprintf (c2, "%03d", msec);    /* put in msec              */
                  F = Fm;                        /* fraction to frac of msec */
                  ++c1;                          /* next format character    */
                  break;                         /* leave switch             */
               case 'u':                         /* day                      */
                  sprintf (c2, "%d", usec);      /* put in usec              */
                  F = Fu;                        /* fraction to frac of usec */
                  ++c1;                          /* next format character    */
                  break;                         /* leave switch             */
               case 'n':                         /* day                      */
                  sprintf (c2, "%d", nsec);      /* put in nsec              */
                  F = Fn;                        /* fraction to frac of nsec */
                  ++c1;                          /* next format character    */
                  break;                         /* leave switch             */
               case '.':                         /* nanosecond               */
                  c3 = newfmt;                   /* ptr to fmt string        */
                  *c3++ = '%';                   /* begin with %             */
                  while ((*c1 != 0) && (*c1 != '/')) /* pick up float format */
                     *c3++ = *c1++;              /* xfer format              */
                  *c3++ = 'f';                   /* its float                */
                  *c3 = 0;                       /* terminate format         */
                  sprintf (hold, newfmt, F);     /* put in fraction          */
                  sprintf (c2, "%s", hold+1);    /* fraction w/o leading 0   */
                  break;                         /* leave switch             */
               default:                          /* spacing character        */
                  *c2++ = *c1++;                 /* insert a colon           */
                  *c2++ = 0;                     /* insert str terminator    */
                  break;                         /* out of switch            */
            }
         }

         nchr = strlen (text);                   /* output string length     */
         break;                                  /* out of switch            */
         
  }

   /**************************************************************************/
   /*                                                E                       */
   /*  If there was an exponent crated of the form 10  then add in the       */
   /*  number of characters it represents.  Note that the exponent (E) is    */
   /*  output in a smaller font than the 10 which in essence reduces the     */
   /*  characters it represents - characters are all taken to be of the      */
   /*  size of the 10.                                                       */
   /**************************************************************************/

   if (((pfmt == 1) || (pfmt == 3)) && (X < 999)) /* did we use an exponent  */
   {
      sprintf (newfmt, "%d", X);                 /* exponent to str          */
      nchr -= strlen(newfmt);                    /* reduce chars in exponent */
      if (parm.font < 2)                         /* large font to be used?   */
         nchr += strlen(newfmt) * 20.0 / 32.0;   /* reduce chars in exponent */
      else                                       /* using small font         */
         nchr += strlen(newfmt) * 14.0 / 32.0;   /* reduce chars in exponent */
   }

   /**************************************************************************/
   /*  Make some fine adjustments.  The text is not output as a proportional */
   /*  font so '.', '1' and ':' take up less room.  Try to adjust the string */
   /*  size accordingly                                                      */
   /**************************************************************************/

     c1 = text;                                  /* pointer to output str    */
     while (*c1 != '\0')                         /* loop over string         */
     {
	if (*c1 == '.' || *c1 == '1' || *c1 == ':')  /* narrow character?    */
	   nchr -= .5;                               /* yes - reduce char #  */
        ++c1;                                    /* next character           */
     }

     return (nchr);                              /* return number of char    */
}
