#include <stdlib.h>
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: plotnm.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 plotnm (ByTe_1 gn, ByTe_1 *str, ByTe_1 fnd)
{
   extern struct config   parm;
   extern struct memory   minfo;
   extern struct init_val ival;
   struct graph   *gf, *gf_end;
   struct labels  *lb;
   struct numbers *nm;
   struct window  *wn;

   register ByTe_2 pos;
   ByTe_4  bytes;
   ByTe_4  sz_win,sz_graf,sz_num,sz_lab;
   ByTe_2 free_wn = -1;

   if (parm.gf_num == gn)
   {
       parm.win = parm.grf->gwn;
       parm.wn_num = parm.grf->window;
       return (parm.win->open);
   }

   if (fnd)
   {
      if (minfo.mgraf == NOMEM)
         return (-1);

      gf = (struct graph *)minfo.mgraf;
      gf_end = gf + ival.graphs;
      for ( ; gf < gf_end; ++gf)
          if (gf->plotnm == gn)
	  {
	     parm.grf = gf; 
	     parm.win = gf->gwn;
	     parm.gf_num = gf->plotnm;
	     parm.wn_num = gf->window;
             return (gf->gwn->open);
          }
      return (-1);
   }

   sz_graf = sizeof (struct graph);
   sz_num  = sizeof (struct numbers);
   sz_lab  = sizeof (struct labels);
   sz_win  = sizeof (struct window);

   if (minfo.mgraf == NOMEM)
   {
      bytes = ival.graphs * sz_graf;
      if ((minfo.mgraf = malloc (bytes)) == NOMEM)
         g_error (str,"CANNOT ALLOC MEMORY FOR GRAPH INFO STRUCTURE",1);

      bytes = ival.graphs * sz_num;
      if ((minfo.mnum = malloc (bytes)) == NOMEM)
         g_error (str,"CANNOT ALLOC MEMORY FOR NUMBER INFO STRUCTURE",1);

      bytes = ival.graphs * sz_lab;
      if ((minfo.mlab = malloc (bytes)) == NOMEM)
         g_error (str,"CANNOT ALLOC MEMORY FOR NUMBER INFO STRUCTURE",1);

      bytes = ival.graphs * sz_win;
      if ((minfo.mgwin = malloc (bytes)) == NOMEM)
         g_error (str,"CANNOT ALLOC MEMORY FOR GRAPHICS WINDOWS",1);

      gf = (struct graph *)minfo.mgraf;
      nm = (struct numbers *)minfo.mnum;
      lb = (struct labels *)minfo.mlab;
      wn = (struct window *)minfo.mgwin;
      gf_end = gf + ival.graphs;

      for ( ; gf < gf_end; ++gf)
      {
	 gf->num = nm++;
	 gf->lab = lb++;
	 gf->gwn = wn++;
	 parm.grf = gf++;
	 init_gf(-1);
      }

   }

   gf = (struct graph *)minfo.mgraf;
   gf_end = gf + ival.graphs;

   for (pos = 0; gf < gf_end; ++gf, ++pos)
   {
      if (gf->plotnm == gn)
      {
         parm.grf   = gf;
         parm.gf_num = gn;
	 return (gf->defsca);
      }
      else
	 if (gf->plotnm == -1)
	    free_wn = pos;
   }

   if (free_wn >= 0)
       parm.grf = (struct graph *)minfo.mgraf + free_wn;
   else
   {
      bytes = ++ival.graphs * sz_graf + 4;
      if ((minfo.mgraf = realloc (minfo.mgraf,bytes)) == NOMEM)
	  g_error (str,"CANNOT EXPAND GRAPH ARRAY",1);
      parm.grf = (struct graph *)minfo.mgraf + ival.graphs - 1;

      bytes = ival.graphs * sz_num + 4;
      if ((minfo.mnum = realloc (minfo.mnum,bytes)) == NOMEM)
	  g_error (str,"CANNOT EXPAND NUMBER ARRAY",1);

      bytes = ival.graphs * sz_lab + 4;
      if ((minfo.mlab = realloc (minfo.mlab,bytes)) == NOMEM)
	  g_error (str,"CANNOT EXPAND LABEL ARRAY",1);

      bytes = ival.graphs * sz_win + 4;
      if ((minfo.mgwin = realloc (minfo.mgwin,bytes)) == NOMEM)
	  g_error (str,"CANNOT EXPAND LABEL ARRAY",1);

      gf = (struct graph *)minfo.mgraf;
      nm = (struct numbers *)minfo.mnum;
      lb = (struct labels *)minfo.mlab;
      wn = (struct window *)minfo.mgwin;
      gf_end = gf + ival.graphs;

      for ( ; gf < gf_end; ++gf)
      {
	 gf->num = nm++;
	 gf->lab = lb++;
	 gf->gwn = wn++;
      }
      init_gf(-1);
   }

   parm.grf->plotnm = gn;
   parm.gf_num = gn;
   parm.grf->gwn->viewport = -gn - 1;

   return (parm.grf->defsca);
}
