#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: plot_3d.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

/*********************************************************************
*                                                                    *
*                      PLOT_3D  SUBROUTINE                           *
*                                                                    * 
*  DESCRIPTION                                                       * 
*                                                                    * 
*  INPUT VARIABLES                                                   * 
*     fmt[0] - strip direction                                       *
*           'x' - along x                                            *
*           'y' - along y                                            *
*           'z' - along z                                            *
*     fmt[1] - plot type ('0'-'5')                                   *
*                                                                    * 
*  USAGE                                                             * 
*                                                                    * 
*  NECESSARY SUBPROGRAMS                                             * 
*                                                                    * 
*  EXTERNAL VARIABLES                                                * 
*                                                                    * 
*  INTERNAL VARIABLES                                                * 
*                                                                    * 
*  BUGS                                                              * 
*                                                                    * 
*********************************************************************/

ByTe_4 plot_3d( ByTe_1 pn, ByTe_1 ax, ByTe_1 ay, ByTe_1 az, ReaL_4 *x, 
              ReaL_4 *y, ReaL_4 *z, ReaL_4 *v, ReaL_4 *E, ByTe_4 beg, 
              ByTe_4 end, ByTe_1 *fmt, ReaL_4 *ctbl, ByTe_1 cts)
{
   extern struct config parm; 
   struct window *wn; 
   struct graph  *gf; 
   register ReaL_4 *f_end;
   register ReaL_4 *fa, *fb;
   register ReaL_4 *fu, *fl, *fv;
   ReaL_4 mid;
   ReaL_4 w[6];
   ReaL_4 uppery, lowery;
   ByTe_4  pmax, inc;
   ByTe_4 (*_drw) (ByTe_1, ReaL_4, ReaL_4, ReaL_4, ReaL_4, ReaL_4, ReaL_4);
   ByTe_4 (*_color) (ByTe_1, ByTe_2);
   ByTe_2 sav_fcolor, sav_lcolor;
   ByTe_2 old_color, new_color = -1000;
   ByTe_2 cmax;
   ByTe_1  *c1,*c2;
   ByTe_1  sav_lstyle;
   ByTe_1  vp,sav_clip,axis[3];
   ByTe_1  type, axs, ntype;
   ByTe_1  same,sav_fill, IsPlot, Ec;
  
/*********************************************************************/
/*  Determine the maximum accessible color                           */
/*********************************************************************/

   pmax =   parm.drv->dev->ctl / parm.drv->ctb->c_scale  + .05;
   cmax = (parm.drv->ctb->c_scale * pmax - 1.0)/parm.drv->ctb->c_scale; 

/*********************************************************************/
/*  Check plotting universe.  If carteographic then there is no      */
/*  plot.  We are plotting directly to a window and pn is the window */
/*  number.                                                          */
/*********************************************************************/

   IsPlot = (parm.univ > 7) ? 0 : 1;

/*********************************************************************/
/* Check all error conditions                                        */
/*   1. plot number has been defined and initialized                 */
/*   2. there's more than one data point                             */
/*   3. valid defined plot axis                                      */
/*   4. valid plot format                                            */
/*   5. beginning position is >= 0                                   */
/*   6. format is 1 or 2 with both end points passed                 */
/*********************************************************************/

   if (IsPlot)
   {
      if (plotnm (pn,"PLOT_3D",1) != 1 )
      {
         g_error ("PLOT_3D","REQUESTED PLOT HAS NOT BEEN DEFINED",0);
         return (0);
      }
   }
   else
   {
      Ec = (pn != parm.wn_num) ? window (pn,"PLOT_3D") : parm.win->open;
      if (Ec <= 0)
      {
         g_error ("PLOT_3D","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
         return (0);
      }
   }

   if (end < 0)
   {
      g_error ("PLOT_3D","END POINT LESS THAN ZERO",0);
      return (0);
   }

   axs = fmt[0] - 'x';
   if (axs < 0 || axs > 2)
   {
      g_error ("PLOT_3D","ILLEGAL DIRECTION",0);
      return (0);
   }

   type  = (fmt[1] == 0) ? 0 : fmt[1] - '0';
   ntype = type % 3;

   if (ntype < 0 || ntype > 3) 
      g_error ("PLOT_3D","BAD FMT[0] -- SET TO 0",0);

   if (beg < 0)
      beg = 0;

   if ((ntype == 1 || ntype == 2) && (end - beg < 2))
   {
      g_error ("PLOT_3D","NPTS < 2 WITH FMT[1] == 1 OR 2",0);
      return (0);
   }

   if ((ntype == 1 || ntype == 2) && (E != 0))
   {
      g_error ("PLOT_3D","TYPE 1 or 2 WITH END PNTS; TYPE SET TO 0",0);
      type = 0;
      ntype = 0;
   }

/*********************************************************************/
/*  Save current plotting state so that it can be reset when we are  */
/*  through plotting                                                 */
/*********************************************************************/

   if (IsPlot)
   {
      gf = parm.grf;
      vp = gf->window;
      c2 = gf->axis;
      for (c1 = axis; c1 < axis + 3;)
         *c1++ = *c2++; 

      same = set_axis (pn,ax,ay,az);
   }
   else
      vp = pn;

   wn = parm.win;
   sav_fcolor = parm.f_color;
   sav_lcolor = parm.l_color;
   sav_lstyle = parm.lstyle;
   sav_fill = parm.fill;
   sav_clip = wn->clip;
   clip (vp,1);


/*********************************************************************/
/*  Depending on the direction we are plotting.  Each case statement */
/*  does the same thing.  Note that the array w holds the (xyz)      */
/*  start and end points for the current segment.  Each segment      */
/*  varies only in one direction and is fixed in the other two which */
/*  may have width.  The procedure is for 'x'                        */
/*  1.  set fv to w                                                  */
/*  2.  set fa first w[0]                                            */
/*  3.  set w[1] to 1st y locations                                  */
/*  4.  set w[2] to 1st z locations                                  */
/*  5.  set fb w[1]                                                  */
/*  6.  set w[4] to 2nd y location if not drawn as line otherwise    */
/*          set it to 1st.                                           */
/*  7.  set w[5] to 2nd z location if not drawn as line otherwise    */
/*         set it to 1st.                                            */
/*  8.  find the upper and lower limits of the axis along which the  */
/*         plot is varying                                           */ 
/*  9.  determine if the varying position array which is increasing  */
/*       or decreasing.  In either case                              */
/*    a. set fu to the location of the maximum value in array        */
/*    b. set fl to the location of the minimum value in array        */
/*    c. set fv to the data corresponding to fl                      */
/*    d. set the location of the end of the array                    */
/*    e. determine how to increment through the array                */
/*********************************************************************/

   switch (fmt[0])
   {
      case 'x':
         fv = w;
         fa = fv++;
         *fv++ = *y;
         *fv++ = *z;
         fb = fv++;
         *fv++ = (type/3 == 1) ? *y : *(y+1); 
         *fv   = (type/3 == 1) ? *z : *(z+1); 
 
         if (parm.univ >= 8 && parm.univ <= 16)
         {
            uppery = 360.0;
            lowery = -360.0;
         }
         else
         {
            if (wn->plot[3] > wn->plot[0])
            {
               uppery = wn->plot[3];
               lowery = wn->plot[0];
            }
            else
            {
               uppery = wn->plot[0];
               lowery = wn->plot[3];
            }
         }
 
         if (x[beg] > x[beg+1])
         {
            if (E == 0)
            {
               fl = x + end + 1;
               fu = x + end;
            }
            else
            {
               fl = x + end;
               fu = E + end; 
            }
            fv    = v + end;
            f_end = v + beg;
            inc   = -1;
         }
         else
         {
            fl    = x + beg;
            fu    = (E == 0) ? x + beg + 1 : E + beg; 
            fv    = v + beg;
            f_end = v + end;
            inc   = 1;
         }
         break;

      case 'y':

         fv = w;
         *fv++ = *x;
         fa = fv++;
         *fv++ = *z;
         *fv++ = (type/3 == 1) ? *x : *(x+1); 
         fb = fv++;
         *fv = (type/3 == 1) ? *z : *(z+1); 

         if (parm.univ >= 8 && parm.univ <= 16)
         {
            uppery = 90.0;
            lowery = -90.0;
         }
         else
         {
            if (wn->plot[4] > wn->plot[1])
            {
               uppery = wn->plot[4];
               lowery = wn->plot[1];
            }
            else
            {
               uppery = wn->plot[1];
               lowery = wn->plot[4];
            }
         }
 
         if (y[beg] > y[beg+1])
         {
            if (E == 0)
            {
               fl = y + end + 1;
               fu = y + end;
            }
            else
            {
               fl = y + end;
               fu = E + end; 
            }
            fv    = v + end;
            f_end = v + beg;
            inc   = -1;
         }
         else
         {
            fl    = y + beg;
            fu    = (E == 0) ? y + beg + 1 : E + beg; 
            fv    = v + beg;
            f_end = v + end;
            inc   = 1;
         }
       
         break;

      case 'z':

         fv = w;
         *fv++ = *x;
         *fv++ = *y;
         fa = fv++;
         *fv++ = (type/3 == 1) ? *x : *(x+1); 
         *fv++ = (type/3 == 1) ? *y : *(y+1); 
         fb = fv;
 
         if (wn->plot[5] > wn->plot[2])
         {
            uppery = wn->plot[5];
            lowery = wn->plot[2];
         }
         else
         {
            uppery = wn->plot[2];
            lowery = wn->plot[5];
         }
 
         if (z[beg] > z[beg+1])
         {
            if (E == 0)
            {
               fl = z + end + 1;
               fu = z + end;
            }
            else
            {
               fl = z + end;
               fu = E + end; 
            }
            fl    = z + end;
            fu    = (E == 0) ? z + end - 1 : E + end; 
            fv    = v + end;
            f_end = v + beg;
            inc   = -1;
         }
         else
         {
            fl    = z + beg;
            fu    = (E == 0) ? z + beg + 1 : E + beg; 
            fv    = v + beg;
            f_end = v + end;
            inc   = 1;
         }
        
         break;
   }


/*********************************************************************/
/*  Get to the first data point which falls within the plot          */
/*********************************************************************/

   while (*fu < lowery && fv != f_end)
   {
      fu += inc;
      fl += inc;
      fv += inc;
    }
      
/*********************************************************************/
/*  No plotable data so set type to -1 to avoid switches             */ 
/*********************************************************************/

   if (fv == f_end)
    {
      type = -1;
      ntype = -1;
    }

/*********************************************************************/
/*  Set up pointers to output routine and color routine depending on */
/*  whether we are drawing lines or rectangles                       */
/*********************************************************************/

   switch (type)
   {
      case 0:
      case 1:
      case 2:
         _drw = box;
         _color = fill;
         break;
      case 3:
      case 4:
      case 5:
         _drw = line;
         _color = plt_color;
         break;
   }

/*********************************************************************/
/*  This is the output switch.                                       */
/*********************************************************************/

   switch (ntype)
   {
      case 0:
         f_end += inc;
         if (E == 0)
         {
            old_color = spec_color(*fv,ctbl,cts,cmax);
            *fa = *fl; 
            *fb = *fu; 

            fu += inc;
            fl += inc;
            fv += inc;
            while (*fl <= uppery && fv != f_end)
            {
               new_color = spec_color(*fv,ctbl,cts,cmax);
               if (old_color != new_color)
               {
                  _color (0,old_color);
                  _drw (vp, w[0], w[1], w[2], w[3], w[4], w[5]);
                  *fa = *fl; 
                  *fb = *fu; 
                  old_color = new_color;
               }
               else
                  *fb = *fu;

               fu += inc;
               fl += inc;
               fv += inc;
            }

            _color (0,old_color);
            _drw (vp, w[0], w[1], w[2], w[3], w[4], w[5]);
         }
         else
         {
            while (*fl <= uppery && fv != f_end)
            {
               new_color = spec_color(*fv,ctbl,cts,cmax);
               *fa = *fl;
               *fb = *fu;
               _color (0,new_color);
               _drw (vp, w[0], w[1], w[2], w[3], w[4], w[5]);
               fu += inc;
               fl += inc;
               fv += inc;
            }
         }
         break;

      case 1:
      case 2:

         mid = (*fu - *fl)/2.0;
         _color (0,spec_color(*fv,ctbl,cts,cmax));
         *fa = (type == 2) ? *fl - mid : *fl;
         *fb = *fl + mid;
         _drw (vp, w[0], w[1], w[2], w[3], w[4], w[5]);
         fl += inc;
         fu += inc;
         fv += inc;

         while (*fl <= uppery && fv < f_end)
         {
            mid = (*fu - *fl)/2.0 ;
            _color (0,spec_color(*fv,ctbl,cts,cmax));
            *fa = *fl - mid;
            *fb = *fl + mid;
            _drw (vp, w[0], w[1], w[2], w[3], w[4], w[5]);
            fl += inc;
            fu += inc;
            fv += inc;
         }

         mid = (*fu - *fl)/2.0;
         _color (0,spec_color(*fv,ctbl,cts,cmax));
         *fa = *fl - mid;
         *fb = (type == 2) ? *fl + mid : *fl;
         _drw (vp, w[0], w[1], w[2], w[3], w[4], w[5]);

         break;
   }

/*********************************************************************/
/*  Reset graphics to state it was in before we came into this       */
/*  routine                                                          */
/*********************************************************************/

   clip (vp,sav_clip);
   fill (sav_fill,sav_fcolor);
   plt_color (sav_lstyle,sav_lcolor);

   if (!same && IsPlot)
      same = set_axis (pn,axis[0],axis[1],axis[2]);

   return (1);
}

#include <math.h>

ByTe_2 spec_color(ReaL_4 val,ReaL_4 *ctbl, ByTe_1 cts, ByTe_2 cmax)
{
    register ReaL_4 *f1;
    ReaL_4 tc, fmax;
    ByTe_2 color;

    fmax = cmax;

    if (cts < 0)
       tc = val;
    else
    {
       f1 = ctbl;
       if (cts == 1) 
          tc = (val > 0.0) ? *f1 * log10(val) + *(f1+1) : 0.0;
       else
          tc = *f1 * val + *(f1+1);
    }

    color = (tc > fmax) ? cmax : (tc < 0.0) ? 0 : tc;

    return (color);
}
