#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: place_plot.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

void place_plot (ByTe_1 gn, ByTe_1 w, ReaL_4 x1, ReaL_4 y1, ReaL_4 z1, 
                 ReaL_4 x2, ReaL_4 y2, ReaL_4 z2, ByTe_1 mode)
{
   extern struct config parm;
   struct graph  *gf;

   plotnm (gn,"PLACE_PLOT",0);

   gf = parm.grf;
   gf->baswin = w;
   
   if (mode < 0 || mode > 8)
      g_error ("PLACE_PLOT","UNKNOWN MODE VALUE -- LEFT UNCHANGED",0);
   else
      gf->mode = mode;
  
   if ((mode % 4 == 1) && (x2 < 0.0 || y2 < 0.0 || z2 < 0.0))
      g_error ("PLACE_PLOT","NEGATIVE LENGTH WITH MODE 1",1);
         
   gf->loc[0] = x1;
   gf->loc[1] = y1;
   gf->loc[2] = z1;
   gf->loc[3] = x2;
   gf->loc[4] = y2;
   gf->loc[5] = z2;
}
