#include <string.h>
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: num_lab.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 num_lab (ByTe_1 gn, ByTe_1 axis, ReaL_4 pos, ByTe_2 level, 
                ByTe_1 *nlabel, ByTe_1 *fmt, ByTe_1 hv, ByTe_1 io, ReaL_4 phi, 
                ReaL_4 rot, ByTe_2 color)
{
   extern struct config parm;
   extern struct memory minfo;
   struct window   *wn;
   struct graph    *gf;
   struct labels   *lb;
   struct numbers  *nm;
   ByTe_1 sav_font;
   ByTe_1 base,vp;
   register ByTe_2 i,j;
   register ReaL_4 *fpt;
   ReaL_4 tmp,plt[6],clen,tic_majs;
   ReaL_4 ch_sz[2],offset,taxis,spacing,labelbase;
   ReaL_4 T[3],tic_sep,lev[10],sgn;
   ByTe_2 first,last, labs_up, labs_dn, lab_off;
   ByTe_2 prnt,sav_csize,just = 0,sx,nx,rx;
   ReaL_4 max_ch,c_len;
   ByTe_2 skp,row,length;
   ReaL_4 str_size;
   ByTe_1 *label, save[3];
   ByTe_1 off[2],sav_clip;
   ReaL_4 st,ct,up_dn[2];
   ReaL_4 r,ANG,ang_inc=0.0;
   ReaL_4 ang, xx, yy;
   ByTe_1 intlv;
   ByTe_1 err_code;
   ByTe_1 zc;
 
   plotnm (gn,"NUM_LAB",0);                          /* assign plt structure  */
 
   gf = parm.grf;                                    /* pntr to plot struct   */
   lb = gf->lab;                                     /* pntr to label struct  */
   nm = gf->num;                                     /* pntr to num struct    */
 
   if (!gf->plot && gf->format == 1 && gf->tstyle < 2)   /* If the axis is a  */
   {                                                 /* cross hair format and */
     if (axis/4 == 0)                                /* to be labeled along   */
     {                                               /* the axes & the axis   */
        if (gf->mx_sca[2] * gf->mn_sca[2] > 0.0)     /* to be labeled is not  */
           return (0);                               /* displayed on the      */
     }                                               /* screen then don't     */
     else                                            /* label it              */
     {
        if (gf->mx_sca[0] * gf->mn_sca[0] > 0.0)
           return (0);
     }
  }

  if (level < 0 || level > 9)                        /* check requested level */
  {                                                  /* and set to 1 if out   */
     g_error ("NUM_LAB","BAD LEVEL; SET TO 1",0);    /* range                 */
     level = 1;
  }

/*** check to see if graph has a valid window assigned to it ***/
/*** and if so then save the window number                   ***/

  vp = gf->window;
  err_code =  (vp != parm.wn_num) ? window (vp,"NUM_LAB") : parm.win->open;
  if (!err_code)
  {
     g_error ("NUM_LAB","REQUESTED PLOT HAS NOT BEEN DEFINED",0);
     return (0);
  }
  wn = parm.win;

  rx = axis/4;
  nx = axis%4;
  sx = axis/2;

  sav_clip = wn->clip;
  sav_font = parm.font;
  sav_csize = parm.csize;

  clip (vp,0);
  font (nm->font[sx]);
  chr_size (nm->size[sx]);

  off[0] = lb->base_set[(ByTe_2)axis]%2;
  off[1] = lb->base_set[(ByTe_2)axis]/2;

/*** save the current window scaling                        ***/

  if (!gf->plot)
  {
     for (i=0,j=3; i<3; ++i,++j) 
     {
        save[i]     = wn->axis[i];
        wn->axis[i] = 0;
        plt[i]      = wn->plot[i];
        plt[j]      = wn->plot[j];
        wn->plot[i] = 0.0;
        wn->plot[j] = 1.0;
     }
     wn->axis[rx]   = gf->scale[sx];
     wn->plot[rx]   = gf->mn_sca[sx];
     wn->plot[rx+3] = gf->mx_sca[sx];
     scale_win (2);
  }

  if (gf->format == 1 && gf->tstyle < 2)
     zc = ((gf->mn_sca[sx] <= 0.0 && gf->mx_sca[sx] >= 0.0) ||
             (gf->mn_sca[sx] >= 0.0 && gf->mx_sca[sx] <= 0.0)) ? 1 : 0;
  else
     zc = 0;

/*** get current character scaling ***/

  base = (rx == 1) ? 0 : 1;
  get_chsz (ch_sz);
  clen = ch_sz[(ByTe_2)base];

  T[2] = 0.0;

  lab_off = auto_tic (gn,axis,up_dn);
  if (gf->plot && up_dn[0] > up_dn[1]) up_dn[0] -= 360;
  if (up_dn[0] > up_dn[1])
  {
     tmp = up_dn[0];
     up_dn[0] = up_dn[1];
     up_dn[1] = tmp;
  }

  intlv = (gf->plot && rx == 1) ? 1 : nm->interleave[sx];
  if (gf->plot)
  {
     ang_inc = gf->mx_sca[2] - gf->mn_sca[2];
     if (ang_inc  < 0)
        ang_inc += 360.0;
     ang_inc = ang_inc / gf->mj_tcs[2] * (1 + nm->skip[2]);
  }

/**********************************************************************/
/*    Select number justification depending on the axis -- horizontal */
/*    axis are center justified (default setting) while vertical      */
/*    axis are left or right justified depending on whether the test  */
/*    is to the right or left respectively                            */
/**********************************************************************/

  if (wn->dimen == 2)
  {
     if (hv == 0)
     {
        if (rx == 1)
           just = (nx < 2) ? 1 : -1;
     }
     else
     {
        if (rx == 1)
           just = 0;
        else
           just = (nx < 2) ? -1 : 1;
     }
  }
  else
  {
     if (rx != 1)
        just = (nx/2) ? -1 : 1;
  }

  spacing = nm->spacing[sx] * clen;
  offset = (rx != 1 ) ? (.5 + nm->offset[sx]) * clen : nm->offset[sx] * clen;

  sgn = ((io && nx/2) || (!io && !(nx/2))) ? 1 : -1;
  if (gf->plot && rx == 1)
     sgn = -sgn;
  
  taxis  = (io) ? nm->obase[(ByTe_2)axis] : nm->ibase[(ByTe_2)axis];

  for (fpt = lev, j = 0; j < 10; ++j)
      *fpt++ = taxis + sgn * (offset + j * (spacing + clen));

/**********************************************************************/
/*            Begin auto labeling portion of code                     */
/**********************************************************************/

  if (*nlabel == '\0') {

/**********************************************************************/
/*    Compute the total number of labels to be put along the axis     */
/**********************************************************************/

     if (gf->scale[sx])
        tic_sep = 1.0;
     else {
        tic_majs = (up_dn[1] - up_dn[0])/gf->mj_tcs[sx];
        tic_sep = tic_majs;
     }
     if (tic_sep < 0)
	tic_sep = -tic_sep;

     label = (ByTe_1 *)minfo.mxyz + parm.cl_ofst - lab_off * 50;
     max_ch = 0;
     T[rx] = (zc == 1) ? 0.0 : up_dn[0];

     labs_up = 0;
     while (labs_up < lab_off) {
        if ((c_len = pr_fmt (fmt,label,T[rx])) < 0) {
           RestoreSet (save, plt, sav_clip, sav_font, sav_csize);
           return (0);
        }

        if (c_len > max_ch)
           max_ch = c_len;

        label += 50;

        ++labs_up;
        T[rx] = (gf->scale[sx]) ? T[rx]*10. : T[rx] + tic_majs;
     }

     if (zc == 1) {
        T[rx] = 0.0;
        labs_dn = 0;
        while (T[rx] >= up_dn[0]) {
           if ((c_len = pr_fmt (fmt,label,T[rx])) < 0) {
               RestoreSet (save, plt, sav_clip, sav_font, sav_csize);
               return (0);
           }

           if (c_len > max_ch)
              max_ch = c_len;

           label += 50;

           ++labs_dn;
           T[rx] = T[rx] - tic_majs;
        }
     }

/**********************************************************************/
/*    Compute the pixel length of the largest output numerical        */
/*    label and use that to compute when labels should be             */
/*    interleaved (skip)                                              */
/**********************************************************************/

     if (wn->dimen == 2)
        c_len = (rx == 0) ? max_ch : 1;
     else
        c_len = (rx == 1) ? max_ch : 1;

     str_size = ch_sz[rx] * (c_len + nm->gap[sx]/2.0);
     skp = str_size / (tic_sep * (nm->skip[sx] + 1)) + 1.0;

     if ((io && !off[1]) || (!io && !off[0]))
     {
        fpt = (io) ? &lb->obase[(ByTe_2)axis] : &lb->ibase[(ByTe_2)axis];
        if (wn->dimen == 2)
        {
           if (rx == 0 || gf->plot)
	   {
              *fpt  = (intlv) ? lev[skp +level - 1] : lev[level];
	      *fpt += sgn * .5 * clen;
           }
           else
              *fpt = sgn * max_ch * clen + lev[level];
        }
        else
        { 
           if (rx == 1)
	   {
              *fpt  = (intlv) ? lev[skp +level - 1] : lev[level];
	      *fpt += sgn * .5 * clen;
           }
           else
              *fpt = sgn * max_ch * clen + lev[0];
        }
     }

     if (gf->plot)
        ANG = (rx==1 || (rx==0 && 
             !(gf->mn_sca[2] <= 0.0 && gf->mx_sca[2] >= 0.0))) ? 
                              gf->mn_sca[2] : 0.0;
     else
        ANG = 0.0;
     
     last = labs_up;
     first = 0;
     T[rx] = up_dn[0];
     label = (ByTe_1 *)minfo.mxyz + parm.cl_ofst - lab_off * 50;
     switch (nm->ends[sx])
     {
        case 0:
           break;
        case 1:
           last = labs_up - 1;
           break;
        case 2:
           first = 1;
           ANG += ang_inc;
           break;
        case 3:
           first = 1;
           last = labs_up - 1;
           ANG += ang_inc;
           break;
     }

     tmp = up_dn[0];
     if (zc == 1)
     {
        first = 1;
        T[rx] = tic_majs;
        tmp = 0.0;
        label += 50;
     }
     else
     {
        if (first)
        { 
           T[rx] = (gf->scale[sx]) ? T[rx] * 10 : up_dn[0] + tic_majs;
           label += 50;
        }
     }

     for (j = first, i = 0; j < last; ++j, ++i) 
     {
/*
         if (T[rx] > up_dn[1])
            continue;
*/

         row  = i%skp;
         prnt = i%(nm->skip[sx] + 1);

         if ((row == 0 || intlv) && prnt == 0) 
         {
            T[(ByTe_2)base] = lev [level + row]; 
            if (gf->plot)
            {
               if (rx == 1)
               {
	          xx = T[(ByTe_2)base] * cosin(ANG);
 	          yy = T[(ByTe_2)base] * sine(ANG);
                  sprintf(label,fmt,ANG);
                  ang = (ANG >= 0. && ANG<= 180.) ? ANG - 90. : ANG + 90. ;
                  chr_dspl (vp,xx,yy,0.0,ang,0.0,rot,hv,0,label,-1,color);
                  ANG += ang_inc;
               }
               else
               {
	          xx = T[rx] * cosin(ANG) + T[(ByTe_2)base] * cosin(ANG + 90.0);
 	          yy = T[rx] * sine(ANG) + T[(ByTe_2)base] * sine(ANG + 90.0);  
                  phi = gf->mn_sca[2];
                  chr_dspl (vp,xx,yy,0.,phi,0.0,rot,hv,just,label,-1,color);
               }
            }
            else
               chr_dspl (vp,T[0],T[1],T[2],phi,0.0,rot,hv,just,label,-1,color);
        }

        T[rx] = (gf->scale[sx]) ? T[rx] * 10 : tmp + (j+1)*tic_majs;
        label += 50;
     } 

     if (zc == 1)
     {
        T[rx] = -tic_majs;
        label += 50;

        for (j=first,i=0; j<last; ++j,++i) 
        {
           if (T[rx] < up_dn[0])
                 continue;

           row  = i%skp;
           prnt = i%(nm->skip[sx] + 1);

           if ((row == 0 || intlv) && prnt == 0) 
           {
              T[(ByTe_2)base] = lev [level + row]; 

              chr_dspl (vp,T[0],T[1],T[2],phi,0.0,rot,hv,just, label,-1,color);
           }

           T[rx] = tmp - (j+1)*tic_majs;
           label += 50;
        }
     }
  }
  else 
  {
     length = strlen(nlabel);
     offset = length * clen;
     labelbase = lev[level] + sgn*offset;
     fpt = (io) ? &lb->obase[(ByTe_2)axis] : &lb->ibase[(ByTe_2)axis];

     if ((io && !off[1]) || (!io && !off[0]))
     {
        if (wn->dimen == 2) 
        {
           if (rx == 1 || gf->plot)
           {
              if ((io && axis == 7) || (!io && axis == 4)) 
              {
                  if (lb->obase[(ByTe_2)axis] < labelbase)
                     lb->obase[(ByTe_2)axis] = labelbase;
              }
              else
              {
                 if (lb->ibase[(ByTe_2)axis] > labelbase)
                    lb->ibase[(ByTe_2)axis] = labelbase;
              }
           }
           else
              *fpt = lev[level+1] - sgn * spacing;
        }
        else
        {
           if (rx != 1)
           {
              if ((io && nx/2) || (!io && !(nx/2)))
              {
                 if (lb->obase[(ByTe_2)axis] < labelbase)
                    lb->obase[(ByTe_2)axis] = labelbase;
              }
              else
              {
                 if (lb->ibase[(ByTe_2)axis] > labelbase)
                     lb->ibase[(ByTe_2)axis] = labelbase;
              }
           }
           else
              *fpt = lev[level+1] - sgn * spacing;
        }
     }

     T[(ByTe_2)base] = lev[level];
     T[rx] = pos;       

     if (T[rx] <= gf->mx_sca[sx])
     {
        if (gf->plot && rx == 1)
        {
           r = T[(ByTe_2)base];
           st = sine(pos);
           ct = cosin(pos);
           if (axis==4)
           {
              if (pos>=0 && pos<=180)
              {
                  chr_dspl(vp,r*ct,r*st,0.0,pos-90,0.0,
                          rot,hv,0,nlabel,-1,color);
              }
              else
              {
                  chr_dspl(vp,r*ct,r*st,0.0,pos+90,0.0,
                          rot,hv,0,nlabel,-1,color);
              }
           }
           else
              chr_dspl(vp,r*ct,r*st,0.0,0.0,0.0,rot,hv,
                          0,nlabel,-1,color);
        }
        else
           chr_dspl (vp, T[0], T[1], T[2],phi,0.0,rot,hv,just,
                                nlabel,-1,color);
     }
  }

  RestoreSet (save, plt, sav_clip, sav_font, sav_csize);
  return (1);
}
