/**************************************************************/
/*  Draw tick marks along the axis                            */
/**************************************************************/

#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: dr_tic.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 dr_tic (ByTe_1 gn, ByTe_1 axis, ByTe_1 mjmntic, ReaL_4 pos)
{
   extern struct config parm;
   struct graph    *gf;
   ByTe_4   rval;
   ByTe_1   sav_clip;
   ByTe_1   pwin;
   ByTe_1   err_code;
 
   plotnm (gn,"DR_TIC",0);                         /* graphics win opened?  */

   gf = parm.grf;                                  /* ptr to graph struct   */
   pwin = gf->window;                              /* plot window number    */

     /**************************************************************/
     /*   check to see if the plotting window has been opened      */
     /**************************************************************/

   err_code = (pwin != parm.wn_num) ? window (pwin,"DR_TIC") : parm.win->open;
   if (!err_code)
   {
      g_error ("DR_TIC","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
   }

   sav_clip = parm.win->clip;                      /* save cur clip info    */
   clip (pwin,0);                                  /* turn clipping off     */

   if (gf->plot == 0)
   {
      if (gf->format == 1 && gf->tstyle < 2)
      {
         if (axis/4 == 0)
         {
            if (gf->mx_sca[2] * gf->mn_sca[2] > 0.0)
               return (0);
         }
         else
         {
            if (gf->mx_sca[0] * gf->mn_sca[0] > 0.0)
               return (0);
         }

         rval =  dr_tic3 (gn, axis, mjmntic, pos);
      }
      else
         rval =  dr_tic1 (gn, axis, mjmntic, pos);
   }
   else
      rval =  dr_tic2 (gn, axis, mjmntic, pos);

   clip (pwin,sav_clip);
   return (rval);
} 
