#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: dr_axis.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 dr_axis (ByTe_1 gn)
{
  extern struct config parm;
  struct graph  *gf;
  struct window *wn;
  ByTe_1 vp,sav_clip;
  ReaL_4 x1,y1,z1,x2,y2,z2;
  ByTe_2 side;

  if (plotnm (gn,"DR_AXIS",1) != 1 )
  {
      g_error ("DR_AXIS","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return (0);
  }
     
  gf = parm.grf;
  wn = parm.win;
  vp = gf->window;

  sav_clip = wn->clip;
  clip (vp,0);
  
  side = gf->axis[0]/2;
  x1 = gf->mn_sca[side];
  x2 = gf->mx_sca[side];
  side = gf->axis[1]/2;
  y1 = gf->mn_sca[side];
  y2 = gf->mx_sca[side];
  side = gf->axis[2]/2;
  z1 = gf->mn_sca[side];
  z2 = gf->mx_sca[side];

  if (gf->plot)
  {
    if (y1 > y2) 
       y1 -= 360;
    switch (gf->format) 
    {
      case 0:
      case 1:
         if (gf->dr_axis[4])
            arc (vp,0.0,0.0,0.0,x2,y1,y2,1.0,0);
         if (gf->dr_axis[0] && y1<=0 && y2>=0)
            line (vp,x1,0.0,0.0,x2,0.0,0.0);
         break;
    }
  }   
  else
  {
    switch (gf->format) 
    {
      case 0:
         if (gf->dr_axis[0]) 
            line (vp,x1,y1,z1,x2,y1,z1);
         if (gf->dr_axis[3]) 
            line (vp,x1,y2,z1,x2,y2,z1);
         if (gf->dr_axis[4])
            line (vp,x1,y1,z1,x1,y2,z1);
         if (gf->dr_axis[7])
            line (vp,x2,y1,z1,x2,y2,z1);

        if (wn->dimen == 3) 
        {
           if (gf->dr_axis[1]) 
              line (vp,x1,y1,z2,x2,y1,z2);
           if (gf->dr_axis[2]) 
              line (vp,x1,y2,z2,x2,y2,z2);
  
           if (gf->dr_axis[5]) 
              line (vp,x1,y1,z2,x1,y2,z2);
           if (gf->dr_axis[6]) 
              line (vp,x2,y1,z2,x2,y2,z2);

           if (gf->dr_axis[8]) 
              line (vp,x2,y1,z1,x2,y1,z2);
           if (gf->dr_axis[9]) 
              line (vp,x1,y1,z1,x1,y1,z2);
           if (gf->dr_axis[10])
              line (vp,x1,y2,z1,x1,y2,z2);
           if (gf->dr_axis[11])
              line (vp,x2,y2,z1,x2,y2,z2);

        }
        break;
      
        case 1:
           clip (vp, 2);
           if (gf->dr_axis[0])
              line (vp,x1,0.0,0.0,x2,0.0,0.0);
           if (gf->dr_axis[4])
              line (vp,0.0,y1,0.0,0.0,y2,0.0);
           if (gf->dr_axis[8] && wn->dimen==3)
              line (vp,0.0,0.0,z1,0.0,0.0,z2);
        break;
    }
  }
  clip (vp,sav_clip);
  return (1);
}        
