#include "gph_str.h"
#include "gph_ansi.h"
#include <math.h>

static ByTe_1 rcsid[] = "$Id: color_scale.c,v 1.1 1999/11/21 07:58:17 chris.gurgiolo.b2r Stab chrisg $";

void color_scale (ByTe_1 sca, ReaL_4 mn, ReaL_4 mx, ReaL_4 *col)
{
   extern struct config parm;
   struct color    *ct;
   struct scr_info *dv;
   register ByTe_2 i;
   register u_ByTe_1 *cl;
   ByTe_4  min_cl, max_cl = 2;
   ReaL_4 ryl, ryh;
   ByTe_2 first;


   if ((mx <= 0.0 || mn <= 0.0) && sca == 1) 
   {
      g_error ("COLOR_SCALE","MAX/MIN <= 0 AND LOG SCALING -- SET TO LINEAR",0);
      sca = 0;
   }

   dv = parm.drv->dev;
   ct = parm.drv->ctb;

 /* if this is a color device then find the first loaded position in the */
 /* color table beginning from 0 and then the number of sequential       */
 /* color loaded                                                         */

     first = 0;
     cl = (u_ByTe_1 *)ct->wcp;
     while (*cl == 0 || *cl == 255)
     {
        ++cl;
        ++first;
     }
     max_cl = first;
     for (i=first; i<dv->ctl; ++i,++cl)
     {
        if (*cl > 0 && *cl != 255)
           ++max_cl;
        else
           break;
     } 

     if (max_cl < 2)
        max_cl = 2;

     max_cl = max_cl / ct->c_scale - 1;
     min_cl = first /ct->c_scale;

     switch (sca)
     {
        case 0:
           *col = (max_cl - min_cl) / (mx - mn) ;
           *(col+1) = min_cl - mn * *col;
           break;
        case 1:
           ryh = log10(mx);
           ryl = log10(mn);
           *col = (max_cl - min_cl) / (ryh - ryl) ;
           *(col+1) = min_cl - ryl * *col;
           break;
     }

}
