/*****************************************************************/
/*                        AUTO_TIC                               */
/*                                                               */
/*  This is an ancellery routine which for a given plot (gn) and */
/*  a given axis on that plot (axis) returns the number of major */
/*  tick marks needed (through the routine call) as well as the  */
/*  value of the first and last tick mark (value)                */
/*                                                               */
/*  Note that when the axis is linear scale the number of tick   */
/*  marks needed is that specified by the user but for log       */
/*  scaled axis, there is 1 tick mark per decade.                */
/*****************************************************************/

#include "gph_str.h"
#include "gph_ansi.h"
#include <math.h>
#define abs(a) (a > 0) ? a : -a

static ByTe_1 rcsid[] = "$Id: auto_tic.c,v 1.1 1999/11/21 07:58:16 chris.gurgiolo.b2r Stab chrisg $";

ByTe_2 auto_tic (ByTe_1 gn, ByTe_1 axis, ReaL_4 *value)
{
   extern struct config parm;
   struct graph *gf;

   register ReaL_8 *d1;
   register ReaL_4 *f1;
   register ByTe_2 i;

   ReaL_8 D[2], tmpD;

   ReaL_4 base, maxv, minv;

   ByTe_4 aexp, pwr[2];

   ByTe_2 ntics, side;

   plotnm (gn,"AUTO_TIC",0);

   gf = parm.grf;

   side = axis/2;
   d1   = D;
   f1   = value;

   if (gf->scale[side])
   {
      if (gf->mn_sca[side] > gf->mx_sca[side])
      {
         minv = gf->mx_sca[side];
         maxv = gf->mn_sca[side];
      }
      else
      {
         minv = gf->mn_sca[side];
         maxv = gf->mx_sca[side];
      }

        /*** get log of the minimum data value ***/

      base = log10((ReaL_8)minv);
      *d1 = 1.0;

        /*** find pwr of minimum data value ***/
      
      if (base < 0.0)
         pwr[0] = base - 0.0005;
      else
         pwr[0] = base + 0.9995;

        /*** compute new minimum value   ***/

      i = 0;
      aexp = abs(pwr[0]);
      while (i++ < aexp) 
         *d1 *= 10.0;
      if (pwr[0] < 0)
         *d1 = 1.0 / *d1;

        /*** get log of the maximum data value ***/

      base = log10((ReaL_8)maxv);
      *(++d1) = 1.0; 

        /*** find pwr of maximum data value ***/
      
      if (base < 0.0)
         pwr[1] = base - 0.9995;
      else
         pwr[1] = base + 0.0005;

        /*** compute new maximum value   ***/

      i = 0;
      aexp = abs(pwr[1]);
      while (i++ < aexp) 
         *d1 *= 10.0;
      if (pwr[1] < 0)
         *d1 = 1.0 / *d1;

        /*** conpute the number of major tics along axis ***/

      ntics = pwr[1] - pwr[0] + 1;

      if (gf->mn_sca[side] > gf->mx_sca[side])
      {
         tmpD = D[0];
         D[0] = D[1];
         D[1] = tmpD;
      }

      *f1++  = D[0]; 
      *f1    = D[1]; 
   }
   else
   {
      *f1++  = gf->mn_tc_pos[side]; 
      *f1    = gf->mx_tc_pos[side]; 

      ntics = gf->mj_tcs[side] + 1;
   }

   return (ntics);
}
