/*  0 - Simple rectangular projection  */
/*  1 - Mercator projection            */
/*  2 - Sinusoidal projection          */
/*  3 - Mollweide projection           */
/*  4 - Eckert sinusoidal projection   */
/*  5 - Eckert ellipsoidal projection  */
/*  6 - Polar projection               */
/*  7 - Azimuthal projections          */
/*  8 - Conic projections              */

#include <stdio.h>
#include <stdlib.h>
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: maplines.c,v 1.1 1999/11/21 08:01:45 chris.gurgiolo.b2r Stab chrisg $";

void maplines (ByTe_1 wn, ByTe_4 proj, ByTe_1 *mapname, u_ByTe_4 item, 
               ByTe_4 res)
{
   extern struct config parm;
   register ReaL_4 *f1, *f2, *fend;

   ByTe_4   fp;
   ByTe_4   pairs, B = 0, Bget;
   u_ByTe_4 id;
   ReaL_4   *x, *y, z = 0.0;
   ByTe_1   svuniv;
   void     *DaTa = 0;

   if ((fp = open(mapname,0)) < 0)
   {
      g_error ("maplines", "MAPFILE NOT FOUND", 0);
      return;
   }
#ifdef _CyGnUsC
   setmode (fp, O_BINARY);
#endif 

   svuniv = parm.univ;
   parm.univ = proj + 8;

   while (read(fp, &pairs, parm.SSize.Lsize) > 0) {

      read(fp ,&id, parm.SSize.Lsize);
      Bget =  2 * parm.SSize.Fsize * pairs;
      if (Bget > B) {
         if ((DaTa = realloc (DaTa, Bget)) == NOMEM)
            g_error ("MAPLINES","CANNOT EXPAND MAP ARRAY",1);
         x = (ReaL_4 *)DaTa;
         y = x + pairs;
      }

      read (fp, x,  pairs * parm.SSize.Fsize);
      read (fp, y,  pairs * parm.SSize.Fsize);

      if ((item & id) > 0) 
      {
         pairs = reduce_map_res (x, y, pairs, res);

         f1 = x;
         f2 = y;
         fend = x + pairs;
         mv_n_drw (wn, *f1++, *f2++, z, 0, 0);
         for ( ; f1 < fend; )
             mv_n_drw (wn, *f1++, *f2++, z, 1, 0);
         mv_n_drw (wn, 0.0, 0.0, 0.0, 0, 2);
      }
   }

   close (fp);
   if (B > 0)
      free (DaTa);
   parm.univ = svuniv;
}
