/*  0 - simple rectangular projection  */
/*  1 - mercator projection            */
/*  2 - sinusoidal  projection         */
/*  3 - Mollweide  projection          */

#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: mapgrid.c,v 1.1 1999/11/21 08:01:45 chris.gurgiolo.b2r Stab chrisg $";

void mapgrid (ByTe_1 wn, ByTe_4 proj)
{
   extern struct mapinfo map;
   extern struct config parm;

   ReaL_4 lat, longi;
   ReaL_4 tmp;
   ReaL_4 xmin, xmax, ymin, ymax;
   ReaL_4 tlong;
   ByTe_1 pen = 0;
   ByTe_1 svuniv;

   xmin = -180.0;
   xmax = 180.0;
   ymin = -90.0;
   ymax = 90.0;
   svuniv = parm.univ;
   parm.univ = proj + 8;

   switch (proj)
   {
      case 0:
      case 1:
         for (lat = ymin; lat <= ymax; lat += map.dlat)
         {
             tmp = xmax - 90.0;
             for (tlong = xmin; tlong <= tmp; tlong += 90.0)
                 line (wn, tlong, lat, 0.0, tlong + 90.0, lat, 0.0);
         }

         line (wn, xmin-map.rotlong, ymin, 0.0, xmin-map.rotlong, ymax, 0.0);
         line (wn, xmax-map.rotlong, ymin, 0.0, xmax-map.rotlong, ymax, 0.0);

         ymin = map.Slastlat;
         ymax = map.Nlastlat;

         for (longi = xmin; longi <= xmax; longi += map.dlong)
             line (wn, longi, ymin, 0.0, longi, ymax, 0.0);
         break;

      case 2:
      case 3:
      case 4:
      case 5:
         for (lat = ymin; lat <= ymax; lat += map.dlat)
         {
             tmp = xmax - 90.0;
             for (tlong = xmin; tlong <= tmp; tlong += 90.0)
                 line (wn, tlong, lat, 0.0, tlong + 90.0, lat, 0.0);
         }

        tmp = xmin - map.rotlong; 
         mv_n_drw (wn,tmp,ymin,0.0,0,0);
         for (lat = ymin + 1.0; lat <= ymax; lat += 1.0)
            mv_n_drw (wn,tmp,lat,0.0,1,0);
         mv_n_drw (wn,0.0,0.0,0.0,0,2);

        tmp = xmax - map.rotlong; 
         mv_n_drw (wn,tmp,ymin,0.0,0,0);
         for (lat = ymin + 1; lat <= ymax; lat += 1.0)
            mv_n_drw (wn,tmp,lat,0.0,1,0);
         mv_n_drw (wn,0.0,0.0,0.0,0,2);

         for (longi = xmin; longi <= xmax; longi += map.dlong)
         {
            mv_n_drw (wn,longi,map.Slastlat,0.0,pen,0);
            pen = 0;
            for (lat = map.Slastlat + 1.0; lat <= map.Nlastlat; lat += 1.0)
               mv_n_drw (wn,longi,lat,0.0,1,0);
            mv_n_drw (wn,0.0,0.0,0.0,0,2);
         }
         break;

      case 6:
         ymin = map.Slastlat;
         ymax = map.Nlastlat;

         for (lat = ymin; lat <= ymax; lat += map.dlat)
            circle (wn, 0.0, 90.0, 0.0, lat, 0.5, 0);

         for (longi = 0.0; longi < 360.0; longi += map.dlong)
             line (wn, longi, ymin, 0.0, longi, ymax, 0.0);
         break;

      case 7:
         parm.univ = 0;
         circle (wn, 0.0, 0.0, 0.0, 1.0, 0.5, 0);
         parm.univ = 15;

         for (longi = -180.0; longi <= 180.0; longi += map.dlong)
         {
            lat = map.Slastlat;
            mv_n_drw (wn,longi,lat,0.0,0,0);
            lat += 0.25;
            do
            {
               mv_n_drw (wn,longi,lat,0.0,1,0);
               lat += 0.25;
            } while (lat <= map.Nlastlat);

            mv_n_drw (wn,0.0,0.0,0.0,0,2);
         }

         for (lat = map.Slastlat; lat <= map.Nlastlat; lat += map.dlat)
         {
            longi = -180.0;
            mv_n_drw (wn,longi,lat,0.0,0,0);
            longi += 0.25;
            do
            {
               mv_n_drw (wn,longi,lat,0.0,1,0);
               longi += 0.25;
            } while (longi <= xmax);

            mv_n_drw (wn,0.0,0.0,0.0,0,2);
         }

         break;
      case 8:
         if (map.center >= 0.0)
         {
            ymin = -map.dlat;
            ymax = map.Nlastlat;
            tmp = 90.0;
         }
         else
         {
            ymin = map.Slastlat;
            ymax = map.dlat;
            tmp = -90.0;
         }

         for (lat = ymin; lat <= ymax; lat += map.dlat)
            circle (wn, 0.0, tmp, 0.0, lat, 0.5, 0);

         if (tmp > 0.0)
         {
            ymin = -map.dlat;
            ymax = map.Nlastlat;
         }
         else
         {
            ymin = map.Slastlat;
            ymax = map.dlat;
         }

         for (longi = 0.0; longi <= 360.0; longi += map.dlong)
             line (wn, longi, ymin, 0.0, longi, ymax, 0.0);
         break;
   }

   parm.univ = svuniv;
}
