#ifndef GPHSTR_H
#define GPHSTR_H

#include <stdio.h>
#include "gph_def.h"
#include "map_str.h"
#include "gph_typedefs.h"


struct memory
{
   void  *cmd;
   void  *ras;
   void  *mwin;
   void  *mgwin;
   void  *mgraf;
   void  *mseg;
   void  *mdev;
   void  *mdrv;
   void  *mcol;
   void  *mnum;
   void  *mlab;
   void  *mxyz;
   void  *mxy;
};

struct init_val
{
   ByTe_1 windows;
   ByTe_1 graphs;
   ByTe_1 segments;
   ByTe_1 devices;
   ByTe_2 points;
};

struct color
{
   void   *wcp;
   ByTe_2 def_pos[8];
   ReaL_4 c_scale;
   ByTe_2 c_len;
};

struct segment 
{
    ByTe_4   cur_len;
    u_ByTe_4 mx_len;
    ByTe_4   lst_out_len;
    void     *mpt;
    ByTe_1   *wpt;
    ByTe_1   type;
    ByTe_1   def;
    ByTe_1   seg_num;
    ByTe_1   free_ch; 
}; 

/*** DEFINITIONS OF SOME WINDOW VARIABLES                               ***/

/*** type : 1 if base window and rectangular                            ***/
/*** type : 2 if base window and square                                 ***/
/*** type : 3 if relative rectangular window and base is rectangular    ***/
/*** type : 4 if relative square window and base is rectangular         ***/
/*** type : 5 if relative rectangular window and base is square         ***/
/*** type : 6 if relative square window and base is square              ***/

struct window 
{
   ByTe_1  viewport;
   ByTe_1  dimen;
   ByTe_1  open;
   ByTe_1  clip;
   ByTe_1  hid_ln;
   ByTe_1  type;
   ByTe_1  dis_fmt;
   ByTe_1  pos_fmt;
   ByTe_1  cor_fmt;
   ByTe_1  skew;
   ReaL_4  real[6];
   ReaL_4  plot[6];
   ReaL_4  slope[2];
   ReaL_4  sk_cos[3];
   ReaL_4  sk_sin[3];
   ReaL_4  trig[6]; 
   ReaL_4  e_mat[16];
   ReaL_4  eye[8];
   ReaL_4  light[6];
   ByTe_2  inten[2];
   ByTe_1  axis[3];
   ByTe_1  flip[6];
   ByTe_1  rot_ord[3];
   ByTe_2  ang[3];
   ByTe_2  skew_ang[3];
   ReaL_4  r[2];
};

struct SysSizes
{
   ByTe_4 Lsize;                                /* side of a long           */
   ByTe_4 Ssize;                                /* side of a short          */
   ByTe_4 Csize;                                /* side of a char           */
   ByTe_4 Fsize;                                /* side of a ReaL_4          */
   ByTe_4 Dsize;                                /* side of a double         */
};

struct config 
{
   FILE             *error;      /* Pointer to error file                 */
   struct dev_graph *drv;        /* Pointer to device driver structure    */
   struct window    *win;        /* Pointer to current window structure   */
   struct segment   *seg;        /* Pointer to current segment structure  */
   struct graph     *grf;        /* Pointer to current plot structure     */
   struct window    *awin;       /* Pointer to alternate window structure */
   struct graph_kbd *gkbd;       /* Pointer to keyboard structure         */
   struct SysSizes  SSize;       /* System word sizes                     */
   ByTe_4           cl_ofst;
   ByTe_1           univ;
   ByTe_1           ostyle;      /* output style 0: landscape; 1: portrait */
   ByTe_1           wn_num;
   ByTe_1           gf_num;
   ByTe_1           sg_num;
   ByTe_1           page;
   ByTe_1           fill;
   ByTe_1           a_curs;
   ByTe_1           g_curs;
   ByTe_2           au_color;
   ByTe_2           gu_color;
   ReaL_4           acr[2];
   ReaL_4           gcr[2];
   ByTe_1           font;
   ByTe_1           cstyle;
   ByTe_1           c_win;
   ByTe_2           csize;
   ByTe_2           c_color;
   ByTe_1           alt_out;
   ByTe_1           alt_win;
   ByTe_1           lstyle;
   ByTe_1           lends;
   ByTe_2           lend_size;
   ByTe_2           d3pts;
   ByTe_2           d2pts;
   ByTe_2           f_color;
   ByTe_2           l_color;
   ByTe_2           b_color;
   ByTe_2           white;
   ByTe_2           red;
   ByTe_2           yellow;
   ByTe_2           green;
   ByTe_2           cyan;
   ByTe_2           blue;
   ByTe_2           purple;
   ByTe_2           black;
}; 

struct graph 
{
   struct window  *gwn;
   struct numbers *num;
   struct labels  *lab;
   ByTe_1   plotnm;
   ByTe_1   plot;
   ByTe_1   format;
   ByTe_1   window;
   ByTe_1   baswin;
   ByTe_1   defsca;
   ByTe_1   mode;
   ByTe_1   bad_data[3];
   ByTe_1   tstyle;
   ByTe_1   t_win;
   ByTe_1   axis[3];
   ByTe_1   scale[6];
   ByTe_1   dr_axis[12];
   ByTe_1   mj_tc_fmt[6];
   ByTe_1   mn_tc_fmt[6];
   u_ByTe_1 mj_tcs[6];
   u_ByTe_1 mn_tcs[6];
   ByTe_2   mj_tc_len[6];
   ByTe_2   mn_tc_len[6];
   ReaL_4   exclude[3];
   ReaL_4   mx_tc_pos[6];
   ReaL_4   mn_tc_pos[6];
   ReaL_4   loc[6];
   ReaL_4   mx_sca[6];
   ReaL_4   mn_sca[6];
};

struct dev_graph 
{
   ByTe_1          open;
   int             fd;
   struct scr_info *dev;
   struct color    *ctb;
   void            *w_cmd;
   void            *m_cmd;
   ByTe_4 (*_arc)    (ReaL_4, ReaL_4, ReaL_4, ReaL_4, ReaL_4, ReaL_4);      
   ByTe_4 (*_clseg)  (void);      
   ByTe_4 (*_cltx)   (ReaL_4, ReaL_4, ReaL_4, ReaL_4);      
   ByTe_4 (*_curctrl)(void);      
   ByTe_4 (*_dpseg)  (ByTe_1, ByTe_1);      
   ByTe_4 (*_end)    (void);      
   ByTe_4 (*_exinpt) (void);      
   ByTe_4 (*_filcol) (void);      
   ByTe_4 (*_filpat) (void);      
   ByTe_4 (*_gtln)   (ReaL_4, ReaL_4, ByTe_2 , ByTe_1 *);      
   ByTe_4 (*_kybd)   (void);      
   ByTe_4 (*_hdfont) (ReaL_4, ReaL_4, ReaL_4, ReaL_4, ReaL_4, ByTe_1, ByTe_1, 
                     ByTe_1 *, ByTe_2 , ByTe_2 );      
   ByTe_4 (*_init)   (void);      
   ByTe_4 (*_ldcm)   (FILE *, ByTe_2 );      
   ByTe_4 (*_ldcol)  (ByTe_2 , ByTe_2 , ByTe_2 , ByTe_2 );      
   ByTe_4 (*_line)   (ByTe_2 , ByTe_1);      
   ByTe_4 (*_lstyle) (void);      
   ByTe_4 (*_mvac)   (ReaL_4 *, ReaL_4 *, ByTe_1);      
   ByTe_4 (*_nwscr)  (void);
   ByTe_4 (*_opseg)  (ByTe_1, ByTe_4, ByTe_1, ByTe_1);      
   ByTe_4 (*_pltcol) (void);      
   ByTe_4 (*_poly)   (ByTe_2 );      
   ByTe_4 (*_scrcol) (void);      
};

struct scr_info 
{
   ByTe_2 num;
   ByTe_2 drv_num;
   ByTe_1 name[40];
   ByTe_1 dev[20];
   ByTe_1 type;
   ByTe_1 lock;
   ByTe_1 opened;
   ByTe_1 ecflg;
   ByTe_1 endcmd[40];
   ByTe_4 sleep;
   ReaL_4 s_dimen[2];
   ReaL_4 p_dimen[2];
   ReaL_4 pix_sz[2];
   ReaL_4 p_conv[4];
   ReaL_4 mk_sq[2];
   ReaL_4 hf_sz[2];
   ByTe_4 seg_inc;
   ByTe_4 m_len;
   ByTe_2 ctl;
   ByTe_2 attri;
   ByTe_2 col;
   ByTe_2 row;
}; 

struct labels 
{
   ByTe_1 font;
   ByTe_1 base_set[12];
   ByTe_2 size;
   ReaL_4 spacing;
   ReaL_4 obase[12];
   ReaL_4 ibase[12];
   ReaL_4 offset;
};

struct numbers 
{
   ByTe_2  size[6];
   ReaL_4  spacing[6];
   ReaL_4  offset[6];
   ReaL_4  gap[6];
   ReaL_4  obase[12];
   ReaL_4  ibase[12];
   ByTe_1  font[6];
   ByTe_1  interleave[6];
   ByTe_1  skip[6];
   ByTe_1  ends[6];
   ByTe_1  base_set[12];
};

#endif
