#ifndef CONTSTR_H
#define CONTSTR_H

#include "gph_typedefs.h"

struct cont_info
{
   ByTe_2 dev;        /* output device number */
   ByTe_2 init_dev;   /* menu device number */
   ByTe_4 N;          /* Number of points in the entire set of data */
   ByTe_4 nr;         /* number of rows in contour grid (Y) */
   ByTe_4 nc;         /* number of columns in contour grid (X) */
   ByTe_4 gridsize;   /* (nr * nc) --- number of pts in whole grid */
   ByTe_4 numseg;     /* number of segments in gridding */
   ByTe_1 cyclic;     /* is the data cyclic or not (1/0) */
   ByTe_1 plot_fmt;   /* type of cartesian, carteographic */
   ByTe_1 data_type;  /* type of data -- ordered, random, pregridded (0,1,2) */
   ByTe_1 MinRFmt;    /* Minumum distance format A(bsolute) G(rid) */
   ByTe_4 numlevels;  /* number of contour levels inclusive */
   ReaL_4 wgt;        /* exponent of denominator in weighting */
   ReaL_4 stepsize;   /* step size of contour levels */
   ReaL_4 Ubeg;       /* user beginning value of contour levels */
   ReaL_4 Ufin;       /* user ending value of contour levels */
   ReaL_4 begin;      /* program beginning value of contour levels */
   ReaL_4 finish;     /* program ending value of contour levels */
   ByTe_1 NFmt;       /* neighbors, 0=triangle, 1=diamond, 2=square, 3=all */ 
   ByTe_1 FillFmt;    /* Fill Bad Data: 0-Remove Them 1-Sink Them */
   ByTe_2 Norder;     /* order with neighbor accumulation format */
   ByTe_4 NbegX;      /* begining x position for neighbor accumulation */
   ByTe_4 NbegY;      /* begining y position for neighbor accumulation */
   ByTe_4 NlenX;      /* accumulate neighbors this far in X */
   ByTe_4 NlenY;      /* accumulate neighbors this far in X */
   ByTe_4 Nbors;      /* number of neighbors for least sq (random only) */
   ByTe_2 NQuads;     /* min number of filled quadrands  (random only) */
   ByTe_2 order;      /* 1=linear, 2=planar, 3=cubic, 4=quadratic, etc. */
   ReaL_4 VMin;       /* minimum intensity in data */
   ReaL_4 VMax;       /* maximum intensity in data */
   ReaL_4 xmin;       /* minimum x value for grid */
   ReaL_4 ymin;       /* minimum y value for grid */
   ReaL_4 xmax;       /* maximum x value for grid */
   ReaL_4 ymax;       /* maximum y value for grid */
   ReaL_4 xstep;      /* size of increments for steps on the grid */
   ReaL_4 ystep;      /* size of increments for steps on the grid */
   ReaL_4 MinR;       /* min distance from point to be included */ 
   ReaL_4 MinCD;      /* min value in cyclic discontinuous */ 
   ReaL_4 MaxCD;      /* max value in cyclic discontinuous */ 
   ReaL_4 CDdis;      /* length across cyclic discontinuous region */ 
   ByTe_2 rank;       /* rank of matrix used in least square interpolation */
   ByTe_2 XYrank;     /* # of independent elements used in least sq inter */
   ByTe_2 X;          /* points along X in data grid - this is number of */
                      /* arms in spiral data                             */ 
   ByTe_2 Y;          /* points along Y in data grid - this is number of */
                      /* circles in spiral data                          */
   ByTe_2 calls;      /* # of calls to recursive, gives # of pts in mr[] */
   ReaL_4 clevel;     /* current level that is being contoured */
   ReaL_4 Ltol;       /* level below which pregridded data won't be included */
   ReaL_4 Utol;       /* level above which pregridded data won't be included */
   ByTe_1 same;       /* Do subsequent sets of data have the same x,y vals */
   ByTe_1 second;     /* Has it been through the program yet? 1-yes 0-no */
   ByTe_1 save_grid;  /* Does user want to save the grid data? 1-yes 0-no */
   ByTe_1 hold_grid;  /* no mesh computation - for mult outputs 1-yes 0-no */
   ByTe_1 three_d;    /* Is the data considered a plane(0) or 3-d(1) */
   ByTe_1 line_stat;  /* status of a drawn contour line: -1=closed, 1=open */ 
   ByTe_1 xgridsca;   /* x grid scaling 0 = Linear; 1 = Log */ 
   ByTe_1 ygridsca;   /* y grid scaling 0 = Linear; 1 = Log */
};
 
struct cont_disp
{
   ByTe_1 cnt_fmt[10];    /* holds the format for the contour line numbers */
   ByTe_1 output;         /* color, lines, color & lines, colored lines */ 
   ByTe_1 Cs;             /* scaling to be used in contour */
   ByTe_1 IgnZero;        /* log scaling: 1 = set bad; 0 - set -60 if <= 0 */
   ReaL_4 colmax;         /* the maximum color value for color_bar */
   ReaL_4 colmin;         /* the minimum color value for color_bar */
   ReaL_4 Xcol[4];        /* the color translation using scale & min and max */
   ByTe_1 show_cbar;      /* draw color bar 1-yes/0-no */
   ByTe_1 sh_dat_fmt[10]; /* flag to show original data pts 1-on/0-off */
   ByTe_1 show_grid;      /* flag to show calculated grid pts 1-on/0-off */
   ByTe_1 window;         /* holds window from gf[0].window after init_plot */
   ByTe_2 times;          /* number of line-numbers for a particular line */
   ByTe_2 lin_inc;        /* what amt to increment by when printing line-nums */
   ByTe_2 LnSz;           /* line number sizes */
   ByTe_2 grid_color;     /* color to output grid */
   ByTe_2 data_color;     /* color to output data */
   ByTe_2 clab_color;     /* color to output data */
   ByTe_2 smooth;         /* resolut. fact -- ^2 gives # of boxes per gridpt */
   ByTe_1 num_on;         /* flag for recursive.c to know whether to show num */
   ByTe_2 normal;         /* the color to use for lines on output device.*/
   ByTe_2 data_size;      /* size of displayed input data */
};

struct cont_alloc
{
   ByTe_4 totbytes;  /* Number of bytes used in allocing necess arrays */
   void   *initmem;  /* Unnormalized starting address necessary arrays */
   ByTe_4 totsave;   /* Number of bytes used in save array */
   void   *remem;    /* Unnormalized starting address realloc'd arrays */
   ReaL_4 *z;        /* Starting address for val array - word boundary */
   ReaL_4 *Mx;       /* Holds x values for near neighb. Used in mk_matrix */
   ReaL_4 *My;       /* Holds y values for near neighb. Used in mk_matrix */
   ReaL_4 *Mz;       /* Holds z values for near neighb (three_d). Mk_matrix */
   ReaL_4 *PlAng;    /* Holds angles of data planes/cones (only in three_d) */
   ReaL_4 *Mv;       /* Holds v values for near neighb. Used in mk_matrix */
   ReaL_4 *weight;   /* Holds weightings for near neighb. Used in mk_matrix */
   ReaL_4 *d;        /* Holds distances to near neighbs. Used to find weight */
   ReaL_4 *sA;       /* holds angles to display all nums for given line */
   ReaL_4 *sX;       /* holds x-vals for mdpts of all nums for a line */
   ReaL_4 *sY;       /* holds y-vals for mdpts of all nums for a line */
   ReaL_4 *sL;       /* holds the contour level of the label */ 
   ReaL_4 *X;        /* holds the X grid steps */ 
   ReaL_4 *Y;        /* holds the Y grid steps */ 
   ReaL_8 *Velem;    /* Used in mk_matrix */
   ReaL_8 *XYelem;   /* Used in mk_matrix */
   ReaL_8 *Mat;      /* Used in mk_matrix */
   ByTe_4 *id;       /* Temp array used in randm to hold indices of near nb */
   ByTe_4 *save;     /* saved data for successive plots with same (x,y) vals */
   ByTe_1 *seg;      /* Starting address for seg array - word boundary */
   ByTe_1 *bad;      /* 1 - grid pts are outside range of data */
   ByTe_1 *dQ;       /* data quality, 0 - bad 1 = good */
};

struct three_d_cut
{
   ReaL_4 Phi;       /* rotation about z axis -- between 0 and 360.0 deg */
   ReaL_4 Theta;     /* rotation about y axis -- between 0 and 180.0 deg */
   ReaL_4 Rho;       /* rotation about x axis -- between 0 and 360.0 deg */
   ReaL_4 TransX;    /* translation w/ respect to rotated axis           */
   ReaL_4 TransY;    /* translation w/ respect to rotated axis           */
   ReaL_4 TransZ;    /* translation w/ respect to rotated axis           */
   ReaL_4 R[12];     /* rotational and translational matrix              */
};

struct cont_map
{
  ByTe_1   projection;
  ByTe_1   map;
  ByTe_1   dr_map;
  ByTe_1   dr_grid;
  ReaL_4   grid_lat;
  ReaL_4   grid_long;
  ReaL_4   lat_off;
  ReaL_4   long_off;
  ReaL_4   rotation;
  u_ByTe_2 map_res;
  ByTe_2   Gcolor;
  ByTe_2   Mcolor;
};

#endif
