#include "gph_str.h"
#include "gph_ansi.h"
#define   XWINDOWS
#include "gph_ansi_dr.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <stdlib.h>

static ByTe_1 rcsid[] = "$Id: xw_poly.c,v 1.1 1999/11/21 10:30:14 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 xw_poly(ByTe_2 npts)
{
   extern struct config parm;
   extern struct memory minfo;
   extern Display       *theDisplay; 
   extern Window        theWindow; 
   extern GC            theGC;
   extern ByTe_2        theInitCount;
   static ByTe_4        size = 0;
   static ByTe_2        lastInitCount = 0;
   ByTe_4               i, tsize;
   u_ByTe_4             color;
   XPoint               *points, *ptr;   
   register ReaL_4      *f1, *fend;
   register ByTe_2      *pos;
   ByTe_2               *tpos;

  /* Scale points and make sure we have a polygon */   
   if ((npts = scale_pts(npts, 1)) < 3)
      return(0);

  /* Get pointer to where the data is stored */   
   f1 = (ReaL_4 *) minfo.mxyz;
   fend = f1 + 2 * npts;
   pos = (ByTe_2 *) minfo.mxyz;

   for ( ; f1 < fend; )
      *pos++ = *f1++;

  /* Set the correct fill color */
   color = xw_cindex(parm.drv->ctb->c_scale, parm.f_color);

   XSetForeground(theDisplay, theGC, color); 
   
  /* Get pointer to where the data is stored, and a temporary one also */
   pos = (ByTe_2 *)minfo.mxyz;
   tpos = pos;

   if (size == 0 || theInitCount != lastInitCount)
   {
      lastInitCount = theInitCount;

      size = sizeof(XPoint) * npts;
      parm.drv->w_cmd = malloc(size);
   }
   else
   {
      if (size < (tsize = sizeof(XPoint) * npts))
      {
         size = tsize;
         parm.drv->w_cmd = realloc(parm.drv->w_cmd, size);
      }
   }

   ptr = (XPoint *)parm.drv->w_cmd;      
  
  /*  Adjust the x,y coordinates if fill to edge was selected  */
   if (npts == 5 && parm.fill == 1)
   {
      if ( (*(pos+1) == *(pos+3)) && 
           (*(pos+2) == *(pos+4)) && 
           (*(pos+5)== *(pos+7)) )
      {
         *pos++ += 1;
         *pos++ -= 1; *pos++ -= 1; *pos++ -= 1; *pos++ -= 1;
         *pos++ += 1; *pos++ += 1; *pos++ += 1; *pos++ += 1;
         *pos   -= 1;
      }

      pos = tpos;
   }

  /* While there are still points left, get the data points into 
     the structure that X needs them in and draw the polygon */

   points = ptr; 

   for (i = 0; i < npts; i++, ptr++)
   {
      ptr->x = *pos++; 
      ptr->y = *pos++;  
   }   

  /* Draw the polygon and then trace around the outside to make 
     sure we get everything */
   XFillPolygon(theDisplay, theWindow, theGC,
                points, npts,
                Complex, CoordModeOrigin);
   XDrawLines(theDisplay, theWindow, theGC,
              points, npts,
              CoordModeOrigin);

  /* Flush the display so the lines appear */
   XFlush(theDisplay);
  
  /* Set the color back to the plot color */
   color = xw_cindex(parm.drv->ctb->c_scale, parm.l_color);

   XSetForeground(theDisplay, theGC, color);

   return(1);
}
