#include "gph_str.h"
#include "gph_ansi.h"
#define   XWINDOWS
#include "gph_ansi_dr.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>

static ByTe_1 rcsid[] = "$Id: xw_line.c,v 1.1 1999/11/21 10:30:14 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 xw_line(ByTe_2 npts, ByTe_1 c_type)
{
   extern struct config parm;
   extern struct memory minfo;
   extern Display       *theDisplay; 
   extern Window        theWindow; 
   extern GC            theGC;
   ByTe_4               i, npoints;
   ByTe_1               *pp;
   register ReaL_4      *f1, *fend;
   register ByTe_2      *pos;
   XPoint               *xpoints;

  /* Scale points */   
   npts = scale_pts(npts, c_type); 

  /* Get pointer to where the data is stored */   
   f1 = (ReaL_4 *) minfo.mxyz;
   fend = f1 + 2 * npts;
   pos = (ByTe_2 *) minfo.mxyz;

   for ( ; f1 < fend; )
      *pos++ = *f1++;
      
  /* Get pointer to where the data is stored */   
   pos = (ByTe_2 *) minfo.mxyz;

  /* Get pointer to where the pen up/pen down data is stored */
   pp = (ByTe_1 *) minfo.mxyz + parm.cl_ofst;

  /* Draw the set of points */
   for (i = 0 ; i < npts ;)   
   {
/*
   Associate the xpoints variable with the current position in the
   x-y point list.
*/
      xpoints = (XPoint *)pos;

/*
   Search for the end of the current string of draw points, incrementing
   i and pos, and count the number of points in the string.
*/
      for (i++, pos += 2, npoints = 1 ; i < npts && pp[i] == 1 ;
           i++, pos += 2, npoints++);

/*
   Draw the lines.
*/
      XDrawLines(theDisplay, theWindow, theGC,
                 xpoints, npoints, CoordModeOrigin);
   }

  /* Flush the display so the lines appear */
   XFlush(theDisplay);
  
   return(1);
}
