#include "gph_str.h"
#include "gph_ansi.h"
#define   XWINDOWS
#include "gph_ansi_dr.h"
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

static ByTe_1 rcsid[] = "$Id: xw_ldcm.c,v 1.1 1999/11/21 10:30:14 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 xw_ldcm (FILE *map, ByTe_2 size)
{
   extern int            *ColorLookup;
   extern struct config   parm;
   extern struct memory   minfo;
   extern struct init_val ival;
   extern Display         *theDisplay;
   extern Colormap        theColormap;
   extern int             theScreenType;
   extern int             theScreen;
   extern ByTe_2          X_Color_Offset;
   XColor                 theRGBColor;
   struct scr_info        *dv;
   struct color           *cl; 
   ByTe_4                 pos, devpos;
   ByTe_4                 count;
   ByTe_2                 *d, *c, dp_color[8], i, red, green, blue;
   ByTe_1                 noload, nocolor, ok;
   u_ByTe_1               *uc_ptr;
   u_ByTe_2               *ra, *ga, *ba, *po;

   if (theScreenType == StaticGray)             /* B/W device                */
   {                                            /* BEGIN SET DEFAULT COLORS  */
      parm.white = 1;                           /* white is white            */
      parm.red = 1;                             /* red is white              */
      parm.yellow = 1;                          /* yellow is white           */
      parm.green = 1;                           /* green is white            */
      parm.cyan = 1;                            /* cyan is white             */
      parm.blue = 1;                            /* blue is white             */
      parm.purple = 1;                          /* purple is white           */
      parm.black = 0;                           /* but black is black        */
      return(0);                                /* that's all folks          */
   }                                            /* END SET DEFAULT COLORS    */

  /* Get pointers to the appropriate structures */

   dv = parm.drv->dev;
   cl = parm.drv->ctb;
   uc_ptr = (u_ByTe_1 *)cl->wcp;

   count = 0;
   ra = (u_ByTe_2 *) minfo.mxyz;
   ga = (u_ByTe_2 *) minfo.mxyz + ival.points;
   ba = (u_ByTe_2 *) minfo.mxyz + 2*ival.points;
   po = (u_ByTe_2 *) minfo.mxy;

   d = dp_color;
   *d++ = (parm.white >=0)  ? parm.white*cl->c_scale  : -1;
   *d++ = (parm.red >=0)    ? parm.red*cl->c_scale    : -1;
   *d++ = (parm.yellow >=0) ? parm.yellow*cl->c_scale : -1;
   *d++ = (parm.green >=0)  ? parm.green*cl->c_scale  : -1;
   *d++ = (parm.cyan >=0)   ? parm.cyan*cl->c_scale   : -1;
   *d++ = (parm.blue >=0)   ? parm.blue*cl->c_scale   : -1;
   *d++ = (parm.purple >=0) ? parm.purple*cl->c_scale : -1;
   *d = (parm.black >=0)    ? parm.black*cl->c_scale  : -1;

   for (i=0; i<size; ++i) 
   {
      fscanf (map,"%d %hd %hd %hd",&pos, &red, &green, &blue);
      noload = 0;
      ok = 1;
      devpos = pos*cl->c_scale + .001;

      for (c=cl->def_pos,d=dp_color; c<cl->def_pos+8; ++c,++d)
      {
         if (pos == *c)
         {
            ok = 0;
            devpos = *d;
            break;
         }
      }
      
      nocolor = (*(uc_ptr+devpos) == 0 || *(uc_ptr+devpos) == 255) ? 1 : 0;

      if (ok && *(uc_ptr+devpos) == 255)
         noload = 1;
      
      if (!noload && nocolor)
      {
         ++count;
         *(po + devpos) = devpos;
         *(ra + devpos) = red*2;
         *(ga + devpos) = green*2;
         *(ba + devpos) = blue*2;
         *(uc_ptr+devpos) = (*(uc_ptr+devpos) == 0) ? 1 : 254;
      }
   }

   if (theScreenType == TrueColor) 
   {
      ColorLookup = (int *) calloc (sizeof (theRGBColor.pixel), dv->ctl);

      for (i = 0; i < dv->ctl; i++) 
      {
         theRGBColor.red   = *(ra+i);
         theRGBColor.green = *(ga+i);
         theRGBColor.blue  = *(ba+i);
         XAllocColor(theDisplay,theColormap,&theRGBColor);
         ColorLookup [i] = theRGBColor.pixel;
      }
   }

   if (theScreenType == PseudoColor) /* Preserve colors for Window Manager */
   {
       theRGBColor.flags = DoRed | DoGreen | DoBlue;
       for (i=0; i < X_Color_Offset; i++) 
       {
           theRGBColor.pixel = i;
           XQueryColor(theDisplay,
                       DefaultColormap (theDisplay,theScreen),
                       &theRGBColor);
           XStoreColor(theDisplay,
                       theColormap,
                       &theRGBColor);
        }

  /* Load the colors in the table one by one.                              */

      for (i = 0; i < dv->ctl; i++)
      {      
         theRGBColor.pixel = *(po+i) + X_Color_Offset;
         theRGBColor.red   = *(ra+i);
         theRGBColor.green = *(ga+i);
         theRGBColor.blue  = *(ba+i);
         theRGBColor.flags = DoRed | DoGreen | DoBlue;
         XStoreColor(theDisplay, theColormap, &theRGBColor);
      }
   }

   return(1);
}
