#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gph_str.h"
#include "gph_ansi.h"
#define   XWINDOWS
#include "gph_ansi_dr.h"

#define BORDER_WIDTH 0 

Display        *theDisplay = NULL;
int            theScreen;
Window         theWindow;
GC             theGC;
Visual         *theVisual;
Colormap       theColormap; 
int            theDepth;
unsigned long  theBlackPixel,theWhitePixel;
int            theScreenType;
ByTe_4         I, a, b, c, d, XLen, YLen;
ByTe_2         theInitCount = 0;
ByTe_2         X_Color_Offset = 128;
ByTe_1         Close_X_Display = 1;  /* close window only if owner */
ByTe_1         OK = 1;

static ByTe_1 rcsid[] = "$Id: xw_init.c,v 1.1 1999/11/21 10:30:14 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 xw_init(void)
{
   ByTe_4 x,y;
   ByTe_4 SetupX (ByTe_4 *, ByTe_4 *, ByTe_1 *, ByTe_1 *);
   ByTe_4 SetupGraphics (void);
   ByTe_1 Wname[50], Iname[50];
   Window openWindow(int, int, int, int, ByTe_1 *, ByTe_1 *, int, GC *);

  /* Establish a connection to the X server if one is needed     */
  /* Increment theInitCount every time that openWindow is called */

  if (theDisplay == NULL)
    {
      SetupX(&x, &y, Wname, Iname);
      theWindow = openWindow(x, y, XLen, YLen, Wname, Iname, 0, &theGC);
    }
  theInitCount++;

  SetupGraphics();

  return(1);
}

ByTe_4 SetupX(ByTe_4 *x, ByTe_4 *y, ByTe_1 *Wname, ByTe_1 *Iname)
{
   ByTe_4 dl, dh;
   ReaL_4 lx, ly, ux, uy;
   int    R;
   FILE  *fp;

   if ((theDisplay = XOpenDisplay(NULL)) == NULL)
   {
      fprintf(stderr,"ERROR: Cannot connect to the X server %s\n",
                      XDisplayName(NULL));
      exit(0);
   }

   /*  Specify the screen; define black and white pixels;  */
   /*  load the default colormap; set up the cursor        */

   theScreen     = DefaultScreen(theDisplay);
   theDepth      = DefaultDepth(theDisplay,theScreen);
   theBlackPixel = BlackPixel(theDisplay,theScreen);
   theWhitePixel = WhitePixel(theDisplay,theScreen);

   /*  See if the file 'data.X' exists and if it does,     */ 
   /*  get window information from there                   */

   if ((fp = fopen("data.X", "r")) != NULL) 
   {
      R = fscanf(fp, "%f %f %f %f", &lx, &ly, &ux, &uy);
      if ((R < 4) || (lx >= ux) || (ly >= uy) || (lx < 0.0) || (ly < 0.0) || 
                                (ux > 1.0) || (uy > 1.0))
      {
         lx = .1;
         ly = .1;
         ux = .9;
         uy = .9;
      }

      R = fscanf(fp, "%s %s", Wname, Iname);
      if (Wname[0] == 0 || R < 1)
         strcpy (Wname, "B2R GRAPHICS");
      if (Iname[0] == 0 || R < 2)
         strcpy (Iname, "B2R-GPHS");

      fclose(fp);
   }
   else
   {
      lx = .1;
      ly = .1;
      ux = .9;
      uy = .9;
      strcpy (Wname, "B2R GRAPHICS");
      strcpy (Iname, "B2R-GPHS");
   }

   /* Translate from 0.0 - 1.0 coordinates entered into pixels */

   dl = DisplayWidth(theDisplay, theScreen);
   dh = DisplayHeight(theDisplay, theScreen);
   XLen = (ux - lx) * dl;
   YLen = (uy - ly) * dh;
   
   /*  Set the x & y coordinates of the window to correspond  */
   /*  to the way X wants it                                  */

   *x = lx * dl; 
   *y = dh - (uy * dh);
   if ((*y + YLen) == dh)
       YLen -= 30;
   if ((*x + XLen) == dl)
       XLen -= 10;
 
   return(1);
}

ByTe_4 SetupGraphics(void)
{
   extern struct config  parm;
   struct scr_info       *dv;
   ReaL_4 xx, yy, pratio;
      
   dv = parm.drv->dev;                          /* ptr to device info struct */

   xx = XLen;                                   /* window X length           */
   yy = YLen;                                   /* window Y length           */

   dv->s_dimen[0] = xx - 1.0;                   /* max window X (beg at 0)   */
   dv->s_dimen[1] = yy - 1.0;                   /* max window Y (beg at 0)   */

   dv->pix_sz[0]    = 32768.0 / xx;             /* 32768 pixs in 1 X win pix */
   dv->pix_sz[1]    = 32768.0 / yy;             /* 32768 pixs in 1 Y win pix */
 
   dv->p_conv[0] = xx / 32768.0;                /* conv 32768 pix to win pix */
   dv->p_conv[1] = yy / -32768.0;               /* conv 32768 pix to win pix */
   dv->p_conv[2] = 0.0;                         /* X offset                  */
   dv->p_conv[3] = yy - .00000001;              /* Y offset                  */

   pratio = dv->p_dimen[1] / dv->p_dimen[0];    /* ratio of pixel len to wid */
   if (dv->s_dimen[1] > dv->s_dimen[0])         /* Y longer than X           */
   {                                            /* BEGIN SQUARE UP X         */
      dv->mk_sq[0] = (yy / xx) * pratio;        /* X conver for square win   */
      dv->mk_sq[1] = 1.0;                       /* unit conversion for Y     */
   }                                            /* END SQUARE UP X           */
   else                                         /* X longer than Y or X == Y */
   {                                            /* BEGIN SQUARE UP Y         */
      dv->mk_sq[0] = 1.0;                       /* unit conversion for X     */
      dv->mk_sq[1] = (xx / yy) / pratio;        /* Y conver for square win   */
   }                                            /* END SQUARE UP Y           */
  
   dv->attri = 0;                               /* no special attributes     */

/*
   dv->ctl = theVisual->map_entries;
*/

   dv->ctl = 256;
   if (theScreenType != StaticGray)             /* multiple entry colormap   */
      dv->ctl -= X_Color_Offset;                /* correct for reserve       */
   else                                         /* B/W only                  */
      X_Color_Offset = 0;                       /* never a reserve           */

   return(1);                                   /* return A-OK!              */
} 

#include <stdlib.h>

Window openWindow(ByTe_4 x, ByTe_4 y, ByTe_4 width, ByTe_4 height, 
                     ByTe_1 *Wname, ByTe_1 *Iname, ByTe_4 flag, GC *theNewGC)
{
   XSetWindowAttributes  theWindowAttributes;
   XSizeHints            theSizeHints;
   u_ByTe_4              theWindowMask;
   Window                theNewWindow;
   XWMHints              theWMHints;
   XVisualInfo           vTemplate, *visualList; 
   ByTe_4                visualsMatched = 0;
   ByTe_4                createGC(Window, GC *);
   void                  *tmp_mem; 
   int                   Class[6], AloCate;

   Class[0] = PseudoColor;                          
   Class[1] = DirectColor; 
   Class[2] = TrueColor; 
   Class[3] = GrayScale; 
   Class[4] = StaticColor; 
   Class[5] = StaticGray; 

   /* Set the window attributes that we will want to set */

   theWindowAttributes.border_pixel = theBlackPixel;      /* black edges     */
   theWindowAttributes.background_pixel = theBlackPixel;  /* bkgnd is black  */
   theWindowAttributes.override_redirect = False;
   theWindowAttributes.backing_store = Always;
   theWindowAttributes.backing_planes = (u_ByTe_4) 255;

   /* Set up a mask that will describe the parameters we will be */
   /*  setting in the new window structure                        */

   theWindowMask = CWBackPixel | CWBorderPixel | CWOverrideRedirect |
                   CWBackingStore | CWBackingPlanes;

   /* Set up the mask for the color visual and try to get it */

   vTemplate.screen = theScreen; 
   vTemplate.depth  = theDepth;   
   I = 0;
   while (visualsMatched == 0 && I < 6)
   {
       theScreenType = Class[I];
       AloCate = (I == 2 || I > 3) ? AllocNone : AllocAll;
       vTemplate.class = Class[I++];
       visualList      = XGetVisualInfo(theDisplay,VisualScreenMask | 
                         VisualDepthMask | VisualClassMask, 
                         &vTemplate, &visualsMatched); 
   }    

   if (visualsMatched == 0)
   {
      if ((tmp_mem = malloc(sizeof(XVisualInfo))) == 0)
          g_error ("XW_INIT","MALLOC ERROR", 1);

       visualList = (XVisualInfo *) tmp_mem;
       visualList->visual = DefaultVisual(theDisplay,theScreen);
       theScreenType = StaticGray;
   }

   #ifdef __cplusplus
   #define VisualClass  c_class
   #else
   #define VisualClass class
   #endif

   theVisual = DefaultVisual(theDisplay,theScreen);
   if (theVisual->map_entries > (X_Color_Offset + 256))
      theVisual->map_entries = 256;
   theScreenType = theVisual->VisualClass;

   #undef VisualClass

   theNewWindow = XCreateWindow(theDisplay,
                                RootWindow(theDisplay,theScreen),
                                x, y,
                                width, height,
                                BORDER_WIDTH,
                                theDepth,
                                InputOutput,
                                theVisual,
                                theWindowMask,
                                &theWindowAttributes);

  /* Set the colormap for the window, and set the number of colors available */
   {
      ByTe_4 OwnWindow = Close_X_Display;
      if ((theScreenType == StaticGray) || (theScreenType == TrueColor)) 
         theColormap = DefaultColormap(theDisplay, theScreen);
       else 
          if (OwnWindow) 
          {
              theColormap = XCreateColormap(theDisplay, theNewWindow, 
				    theVisual, AllocAll);
          }
       if (OwnWindow)
          XSetWindowColormap(theDisplay, theNewWindow, theColormap);
   }

   /* Free the visual                       */

   XFree(visualList); 

   /* Set the 'hints' for the window mananger */     

   theWMHints.flags         = StateHint | InputHint;
   theWMHints.initial_state = NormalState;
   theWMHints.input      = True;

   XSetWMHints(theDisplay, theNewWindow, &theWMHints);

   theSizeHints.flags  = USPosition | USSize | PMinSize | PMaxSize | PResizeInc;
   theSizeHints.x      = x;
   theSizeHints.y      = y;
   theSizeHints.width  = width;
   theSizeHints.height = height;
   theSizeHints.min_width   = width;
   theSizeHints.min_height  = height;
   theSizeHints.max_width   = width;
   theSizeHints.max_height  = height;
   theSizeHints.base_width   = width;
   theSizeHints.base_height  = height;
   theSizeHints.width_inc   = 0;
   theSizeHints.height_inc  = 0;
  

   XSetNormalHints(theDisplay, theNewWindow, &theSizeHints);

   /* Create a graphics context for the window */

   if (createGC(theNewWindow, theNewGC) == 0)
   {
      XDestroyWindow(theDisplay, theNewWindow);
      return((Window) 0);
   }       

   /* Set the window background to black */

    XSetWindowBackground(theDisplay, theNewWindow, theBlackPixel);
  
   /* Get window and icon name. */

   XStoreName(theDisplay, theNewWindow, Wname); 
   XSetIconName(theDisplay, theNewWindow, Iname); 

   /* Map the window to the device */

   XMapWindow(theDisplay, theNewWindow);

   /* from now on we are only interested in kbd, expose, and destroy events */

   XSelectInput(theDisplay, theNewWindow,
                ExposureMask|KeyPressMask|StructureNotifyMask);

    return(theNewWindow);
} 

ByTe_4 createGC(Window theNewWindow, GC *theNewGC)
{
   XGCValues  theGCValues;
    
   /* Create the graphics context for the window */    

   *theNewGC = XCreateGC(theDisplay,
                         theNewWindow,
                         (u_ByTe_4) 0,
                         &theGCValues);
       
   /* Error, none created, return */ 
   if (*theNewGC == 0)
       return(0);
   else
   {
      XSetForeground(theDisplay,
                     *theNewGC,
                     theWhitePixel);
      XSetBackground(theDisplay,
                     *theNewGC,
                     theBlackPixel);
      return(1);
   }
}
