#include <string.h>
#include "gph_str.h"
#include "gph_ansi.h"
#define   XWINDOWS
#include "gph_ansi_dr.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>

static ByTe_1 rcsid[] = "$Id: xw_hdfont.c,v 1.1 1999/11/21 10:30:14 chris.gurgiolo.b2r Stab chrisg $";
   
ByTe_4 xw_hdfont(ReaL_4 x, ReaL_4 y, ReaL_4 phi, ReaL_4 theta, ReaL_4 rot, 
                 ByTe_1 hv, ByTe_1 just, ByTe_1 *string, ByTe_2 len, 
                 ByTe_2 color)
{
   extern struct config  parm;
   extern Display        *theDisplay;
   extern Window         theWindow;
   extern GC             theGC;
   extern ByTe_2         theInitCount;
   struct window         *wn;
   struct scr_info       *dv;
   static ByTe_4         oldpixelsize = -1;       
   static ByTe_2         lastInitCount = 0, flushfont = 0;
   static XFontStruct    *theFontStruct = NULL;   
   ReaL_4                xx, yy, ratio, pixel_size;
   ByTe_4                px, py, tx, ty, string_size;
   u_ByTe_4              textcolor, plotcolor;
   ByTe_1                *pattern, err_code, lastwin;

   if (parm.ostyle == 1)
      phi -= 90.0; 

   if (parm.cstyle == 2)
   {
      lastwin = parm.wn_num;

      err_code = (parm.c_win != parm.wn_num)
               ? window (parm.c_win,"XW_HDFONT") : parm.win->open;

      if (err_code <= 0)
         g_error ("XW_HDFONT","CAN'T OBTAIN ALTERNATE CHARACTER WINDOW",0);
   }

   dv = parm.drv->dev;
   wn = parm.win;
   px = dv->s_dimen[0] * (wn->real[3] - wn->real[0]);
   py = dv->s_dimen[1] * (wn->real[4] - wn->real[1]);

   if (parm.cstyle == 2)
      window (lastwin, "XW_HDFONT");

  /* Figure out the for converting between character size of 1024  
     and the window...  remember, character size of 1024 should    
     fill the current window regardless of how big the window is */
   ratio = (px > py) ? py / 1024.0 : px / 1024.0; 

   /* Figure out how many pixels the character size comes out to,
     divide by 2/3 because the soft font characters only occupy
     2/3 of a cell */
   pixel_size = (parm.csize * ratio)/0.666;

  /* Figure out the appropriate point size, default to the biggest
     one available if too large */
   if (theInitCount != lastInitCount || oldpixelsize != (ByTe_4)pixel_size)
   {
      flushfont = (theInitCount != lastInitCount) ? 0 : flushfont;

      lastInitCount = theInitCount;

      /* Free the font */
      if (flushfont)
         XFreeFont(theDisplay,theFontStruct);

      oldpixelsize = (ByTe_4)pixel_size;

      if (pixel_size < 11) 
         pattern = "-adobe-new century schoolbook-medium-r-normal--8*";
      else if (pixel_size < 13) 
         pattern = "-adobe-new century schoolbook-medium-r-normal--10*";
      else if (pixel_size < 15) 
         pattern = "-adobe-new century schoolbook-medium-r-normal--12*";
      else if (pixel_size < 17) 
         pattern = "-adobe-new century schoolbook-medium-r-normal--14*";
      else if (pixel_size < 21) 
         pattern = "-adobe-new century schoolbook-medium-r-normal--18*";
      else 
         pattern = "-adobe-new century schoolbook-medium-r-normal--24*";
      
      /* See if the font is available and get it if it is, and if not,
         try for the two defaults */
      theFontStruct = XLoadQueryFont(theDisplay,pattern);

      if (theFontStruct == NULL) 
         theFontStruct = XLoadQueryFont(theDisplay,"variable");   
      if (theFontStruct == NULL) 
         theFontStruct = XLoadQueryFont(theDisplay,"9x15");
      if (theFontStruct == NULL) 
         return(0);
   }

  /* Load the font into the graphics context */
   XSetFont(theDisplay,theGC,theFontStruct->fid);
   flushfont = 1;

  /* Determine string length */
   if ( (len < 0) && ((len = strlen(string)) == 0) )
      return(0);

  /* Set text color */
   textcolor = xw_cindex(parm.drv->ctb->c_scale, color);

   XSetForeground(theDisplay, theGC, textcolor);

  /* Get the string size */
   string_size = XTextWidth(theFontStruct, string, len); 

   xx = x; yy = y;
   scale_one (&xx,&yy);
   tx = xx;
   ty = yy + theFontStruct->max_bounds.ascent/2; 

  /* Adjust the coordinates based on string justification */
   switch(just)
   {
      case 0: 
         tx = tx - string_size/2;
         break;
      case 1: 
         tx = tx - string_size;
         break;
      default:
         break;
   }

  /* Put text on screen */
   XDrawString(theDisplay, theWindow, theGC, tx, ty, string, len);
   XFlush(theDisplay);

  /* Reset the foreground color to the plot color */

   plotcolor = xw_cindex(parm.drv->ctb->c_scale, parm.l_color);

   XSetForeground(theDisplay, theGC, plotcolor);

   return(1);
}
