#include <stdio.h>
#include "gph_str.h"
#include "gph_ansi.h"
#define   XWINDOWS
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "gph_ansi_dr.h"

static ByTe_1 rcsid[] = "$Id: xw_gtln.c,v 1.1 1999/11/21 10:30:14 chris.gurgiolo.b2r Stab chrisg $";

/** This is the generic get line which at this point is nothing **/
/** more than a switch which determines whether the input is to **/
/** handled by the system keyboard handler or by a custom       **/
/** keyboard handler.  This is xwindow version                  **/

#define BuffSize 10

ByTe_4 xw_gtln(ReaL_4 x, ReaL_4 y, ByTe_2 len, ByTe_1 *str)
{
  extern struct config parm;
  extern Display       *theDisplay;
  extern Window        theWindow; 
  extern GC            theGC;
  extern ByTe_2        theInitCount;
  extern ByTe_1        Close_X_Display;
  struct window        *wn;
  struct scr_info      *dv;
  XEvent               theEvent;
  KeySym               theKeySym;
  XComposeStatus       theComposeStatus;
  ByTe_1               Buffer[BuffSize], *pattern, *cpt;
  ByTe_4               count, i, begin, px, py, color;
  u_ByTe_4             textcolor;
  ByTe_4               tx, ty; 
  ReaL_4               ratio, pixel_size, xx, yy;
  static ByTe_4        offset = 0, oldpixelsize = -1;
  static ByTe_2        lastInitCount = 0, flushfont = 0;
  static XFontStruct   *theFontStruct = NULL;

  if (!Close_X_Display)
    return(1);
  
  /* set the text color */
   textcolor = xw_cindex(parm.drv->ctb->c_scale, parm.c_color);

   XSetForeground(theDisplay,theGC,textcolor);

  /* Get the window structure, and figure out the number of
     pixels in the current window */
   dv = parm.drv->dev;
   wn = parm.win;
   px = dv->s_dimen[0] * (wn->real[3] - wn->real[0]);
   py = dv->s_dimen[1] * (wn->real[4] - wn->real[1]);

  /* Figure out the for converting between character size of 
     1024 and the window...  remember, character size of 1024
     should fill the current window regardless of how big the
     window is */
   ratio = (px > py) ? py / 1024.0 : px / 1024.0; 

  /* Figure out how many pixels the character size comes out 
     to, divide by 2/3 because the soft font characters only 
     occupy 2/3 of a cell */
   pixel_size = (parm.csize * ratio)/0.666;

  /* Figure out the appropriate point size, default to the 
     biggest one available if too large */
   if (theInitCount != lastInitCount || oldpixelsize != (ByTe_4)pixel_size)
   {
		flushfont = (theInitCount != lastInitCount) ? 0 : flushfont;

		lastInitCount = theInitCount;

      /* Free the font */
      if (flushfont)
         XFreeFont(theDisplay, theFontStruct);

      oldpixelsize = (ByTe_4)pixel_size;

      if (pixel_size < 8) 
      {
         pattern = "-adobe-courier-bold-r-normal--10*";  
         offset  = 6;
      }
      else if (pixel_size < 10) 
      {
         pattern = "-adobe-courier-bold-r-normal--12*";  
         offset  = 8;
      }
      else if (pixel_size < 12) 
      {
         pattern = "-adobe-courier-bold-r-normal--14*";  
         offset  = 10;
      }
      else if (pixel_size < 16) 
      {
         pattern = "-adobe-courier-bold-r-normal--18*";  
         offset  = 12;
      }
      else
      {
         pattern = "-adobe-courier-bold-r-normal--24*";  
         offset  = 16;
      }
   
      /* See if the font is available and get it if it is,
         and if not, try for the two defaults */

      theFontStruct = XLoadQueryFont(theDisplay, pattern);

      if (theFontStruct == NULL) 
      {
         theFontStruct = XLoadQueryFont(theDisplay, "variable");   
         offset = 12;
      }

      if (theFontStruct == NULL) 
      {
         theFontStruct = XLoadQueryFont(theDisplay, "9x15");
         offset = 10;
      }    

      if (theFontStruct == NULL) 
      return(0);
   }

  /* Load the font into the graphics context */

   XSetFont(theDisplay, theGC, theFontStruct->fid);
   flushfont = 1;

  /* scale the coordinates to fit current window */
   xx = x; yy = y;
   scale_one(&xx,&yy);    
   tx = xx; ty = yy;

  /* set the variable begin to the starting x location, 
     this will make sure that we don't go past the begining
     of the line when backspacing */
   begin = tx; 

  /* initialize the string */
   cpt = str; 

  /* initialize the counter */
   i = 0; 

  /* loop forever -- actually we return on a carriage return */
   while(1) 
   {
      /* block until we get a keypress event */
      XMaskEvent(theDisplay, KeyPressMask, &theEvent);
      
      /* check to see if it is a keyboard input and if so deal with it */   
      if (theEvent.type == KeyPress)
      {
     /* get the ascii value of the keyboard input */
         count = XLookupString((XKeyEvent *)&theEvent,Buffer,BuffSize,
                               &theKeySym,&theComposeStatus);

     /* Check to see if the key entered was a backspace or delete
        and if so, take the last character out of the string, erase
        the character from the screen and move back */

         if (((theKeySym == XK_BackSpace) || (theKeySym == XK_Delete)) && 
             (tx > begin) )
         {
            cpt--; i--; 
            tx = tx - offset;
            XClearArea(theDisplay,theWindow, 
                       tx, ty-offset, 
                       offset, offset+5,
                       False);
            continue;
         }

     /* see if the key was an enter (or carriage ret) and if so exit */
         if ( (theKeySym == XK_Return) || 
              (theKeySym == XK_KP_Enter) || 
              (theKeySym == XK_Linefeed) )
         {
         /* Put a null at the end of the string */
            *cpt++ = '\0';
         
         /* Flush the display one more time */
            XFlush(theDisplay);
         
            break;
         }

     /* a valid input key, draw it and concat it to the input */ 
         else if ((i <= len) && 
                  (((theKeySym >= XK_KP_Space) && (theKeySym <= XK_KP_9)) || 
                  ((theKeySym >= XK_space) && (theKeySym <= XK_asciitilde))))
         {
            i++;

#ifdef BS         
         /* Clear in case we are over-writing something */
         XClearArea(theDisplay, theWindow,
          tx, ty-offset,
          offset, offset+5,
          False); 
#endif

         /* Draw the string and flush the display to make sure
            it's displayed */
            XDrawString(theDisplay, theWindow, theGC,
            tx, ty,
            Buffer, 1);
            XFlush(theDisplay);

            *cpt++ = Buffer[0];

         /* increment x location so the letters are not on top
            of each other */
            tx = tx + offset;
         } 
      }
   }

  /* Set the color back to the plot color */
   color = xw_cindex(parm.drv->ctb->c_scale, parm.l_color);

   XSetForeground(theDisplay, theGC, color);

   return(1);
}
