#include "gph_str.h"
#include "gph_ansi.h"
#define   XWINDOWS
#include "gph_ansi_dr.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
int *ColorLookup=0;			/* remaps logical colors to physical */ 

static ByTe_1 rcsid[] = "$Id: xw_cindex.c,v 1.1 1999/11/21 10:30:14 chris.gurgiolo.b2r Stab chrisg $";

u_ByTe_4 xw_cindex(ReaL_4 scale, ByTe_2 color)
{
   extern unsigned long  theWhitePixel;  
   extern unsigned long  theBlackPixel;  
   extern int            theScreenType;  
   extern ByTe_2         X_Color_Offset;

   extern struct config parm;      

   u_ByTe_4 cindex;

   if (theScreenType == StaticGray)
      cindex = (color > X_Color_Offset) ? theWhitePixel : theBlackPixel;
   else
   {
      /*  Get the basic colormap index from the color and scale parameters. */

      cindex = (u_ByTe_4)(scale * (ReaL_4)color);

      /* Set the black and white color indices to the black and white pixel */
      /* values.  If the screen type is 2, then the output is B&W.  Set all */
      /* indices other than black to theWhitePixel.   Otherwise, add 16 to  */
      /* the index value to avoid the default desktop colors.               */

      if (cindex == (ByTe_4)(scale * parm.black)) 
      {
         cindex = theBlackPixel;
      }
      else if (cindex == (ByTe_4)(scale * parm.white))
      {
         cindex = theWhitePixel;
      }
      else
      {
         if (ColorLookup)
            cindex = ColorLookup[cindex];
	 else
	    cindex += X_Color_Offset;
      }
   }

   return (cindex);
}
