#include "gph_str.h"
#include "gph_ansi.h"
#define   XWINDOWS
#include "gph_ansi_dr.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>

static ByTe_1 rcsid[] = "$Id: xw_arc.c,v 1.1 1999/11/21 10:30:14 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 xw_arc (ReaL_4 x, ReaL_4 y, ReaL_4 r, ReaL_4 ang1, ReaL_4 ang2, 
              ReaL_4 res)
{
  extern struct config   parm;      
  extern Display         *theDisplay; 
  extern Window          theWindow; 
  extern GC      theGC;
  ReaL_4          xx, yy, rr;
  ByTe_4         tx, ty;
  ByTe_4         rx, ry, angle1, angle2;
  u_ByTe_4       color;
  u_ByTe_4       width, height; 
  ByTe_4         radx;

  /* Scale the center point of the arc */   
  xx = x; yy = y; 
  scale_one(&xx, &yy);
  tx = xx; ty = yy;

  /* Scale the radius of the arc */
  xx = yy = r;
  scale_one(&xx, &yy);
  rr = xx;

  xx = yy = 0.0; 
  scale_one(&xx,&yy);
  rr -= xx; 

  radx = rr;
      
  /* Figure out location & size of rectangle bounding the arc */
  width = 2*radx; height = 2*radx;
  rx = tx - radx; ry = ty - radx;

  /* Figure out the angles as X wants them (angle * 64) */
  angle1 = ang1 * 64;
  angle2 = (ang2 - ang1) * 64;

  /* Check to see if the arc should be filled and draw it */
  if (parm.fill == -1)
    XDrawArc(theDisplay, theWindow, theGC, 
        rx, ry, 
        width, height,
        angle1, angle2);
  else
    {
      /* Set the fill color */
      color = xw_cindex(parm.drv->ctb->c_scale, parm.f_color);

      XSetForeground(theDisplay, theGC, color);

      /* Draw the filled in arc */
      XFillArc(theDisplay, theWindow, theGC,
          rx, ry, 
          width, height,
          angle1, angle2);

      /* Reset the color back to the plot color */
      color = xw_cindex(parm.drv->ctb->c_scale, parm.l_color);

      XSetForeground(theDisplay, theGC, color);
    }
      
  /* Flush the display so the arc appears */
  XFlush(theDisplay);

  return(1);
}
