#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: soft_arc.c,v 1.1 1999/11/21 08:55:56 chris.gurgiolo.b2r Stab chrisg $";

void soft_arc (ReaL_4 x, ReaL_4 y, ReaL_4 z, ReaL_4 r, ReaL_4 start, 
               ReaL_4 stop, ReaL_4 res, ByTe_1 gen)
{
   extern struct config parm;
   extern struct memory minfo;
   extern struct init_val ival;
   struct window *wn;
   register ReaL_4 *f1, *f_end;
   register ByTe_1 *mv, *c1;
   register ReaL_4 ang;
   register ByTe_2 j;
   ReaL_4 in[3];
   ReaL_4 dang;
   ReaL_4 tmp;
   ByTe_2 cnt = 0,skp;
   ByTe_1 cyrkle = 1,first = 1,go_on; 

   wn = parm.win;

   dang   = stop - start;
   cyrkle = (dang == 360.0) ? 1 : 0;

   if (gen == 1 && wn->type % 2  == 1)
   {
      tmp = dang / (ReaL_4)(ival.points - 10); 
      if (res < tmp)
         res = tmp;

      f1 = (ReaL_4 *)minfo.mxyz + 3 * ival.points;
      *f1++ = x;
      *f1++ = y;
      *f1   = z;
      tmp = (wn->real[3] - wn->real[0])/(wn->real[4] - wn->real[1]);
      if (tmp < 1.0)
         tmp = 1.0;
      r *= parm.drv->dev->mk_sq[1] * tmp;
      parm.alt_out = 3;
   }

   f1 = (ReaL_4 *)minfo.mxyz;
   mv = (ByTe_1 *)minfo.cmd;
   c1 = (ByTe_1 *)minfo.cmd;

   skp = (wn->dimen == 2) ? 0 : 1;

   if (parm.fill >= 0)
   {
      tmp = dang/ (ReaL_4)(ival.points - 10.0);
      if (res < tmp)
         res = tmp;
   }

   if (parm.fill >= 0 && !cyrkle) 
   {
      *f1++ = x;
      *f1++ = y;
      *mv++ = 1;
      f1 += skp;
      ++cnt;
   }

   ang = start;

   do
   {
      go_on = 0;
      do 
      {
         *f1++ = x + r*cosin(ang);
         *f1++ = y + r*sine(ang);
         f1 += skp;
         ang +=  res;
         *mv++ = 1;
         ++cnt;
      } while (ang <= stop && cnt < ival.points - 10);

      if (ang < stop)
      {
	 go_on = 1;
         if (wn->dimen == 3)
         {
            f1 = (ReaL_4 *)minfo.mxyz + 2; 
            f_end = (ReaL_4 *)minfo.mxyz + 3 * cnt;
            for ( ; f1 < f_end; f1 += 3)
	        *f1 = z;
         }
 
	 if (first)
	 {
            *c1 = 0;
	    first = 0;
         }

         to_univcor (cnt,in,1);

         j = 0;
         parm.drv = (struct dev_graph *)minfo.mdrv;
         while (j++ < ival.devices)
         { 
             parm.drv->_line (cnt,0);
             ++parm.drv;
         }
         parm.drv = (struct dev_graph *)minfo.mdrv;
         f1      = (ReaL_4 *)minfo.mxyz;
         mv       = (ByTe_1 *)minfo.cmd;
	 cnt      = 0;
     }
  } while (go_on);

   if (parm.fill >= 0 && !cyrkle) 
   {
      *f1++ = x;
      *f1++ = y;
      f1 += skp;
      *mv++ = 1;
      ++cnt;
   }

   if (wn->dimen == 3)
   {
      f1 = (ReaL_4 *)minfo.mxyz + 2; 
      f_end = (ReaL_4 *)minfo.mxyz + 3 * cnt;
      for ( ; f1 < f_end; f1 += 3)
	  *f1 = z;
   }

   if (first)
      *c1 = 0;

   to_univcor (cnt,in,1);

   j = 0;
   parm.drv = (struct dev_graph *)minfo.mdrv;
   if (parm.fill >= 0)
      while (j++ < ival.devices)
      { 
          parm.drv->_poly (cnt);
          ++parm.drv;
      }
   else
      while (j++ < ival.devices)
      { 
          parm.drv->_line (cnt,0);
          ++parm.drv;
      }

   parm.drv = (struct dev_graph *)minfo.mdrv;
   parm.alt_out = 0;
}
