#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: scale_pts.c,v 1.1 1999/11/21 08:55:56 chris.gurgiolo.b2r Stab chrisg $";

ByTe_2 scale_pts (ByTe_2 npts, ByTe_1 from)
{
   extern struct config parm;
   extern struct memory minfo;
   struct scr_info *dv;
   struct window *wn;
   register ReaL_4 *fx, *f1;
   register ReaL_8 ax, bx, ay, by;
   ReaL_8 X, Y;
   ReaL_4 *end;
   ReaL_4 sca[4];
   ReaL_4 lastx,lasty;
   ByTe_1 cuniv;

   wn = parm.win;
   dv = parm.drv->dev;

   get_wn_sc (sca,0);

   if (from == 0 )
   {
      lastx = *((ReaL_4 *)minfo.mxy + 2 * (npts - 1) );
      lasty = *((ReaL_4 *)minfo.mxy + 2 * (npts - 1) + 1);
   }

   npts = line_clip (npts, from);

   if (from == 0)
   {
      wn->r[0] = lastx;
      wn->r[1] = lasty;
   }

   cuniv = (parm.univ > 7) ? 1 : parm.univ + 1;

   if (cuniv % 4 != 0)
   {
      if ((wn->type == 1 || wn->type == 3) && parm.alt_out == 1)
         kp_slope (npts);
   }

   /****************************************************************/
   /*                                                              */
   /* Scale data here - the scaling equations originally looked as */
   /*                                                              */
   /*  *s1++ = (ax * *f1++ + bx) * dv->p_conv[0] + dv->p_conv[2];  */
   /*  *s1++ = (ay * *f1++ + by) * dv->p_conv[1] + dv->p_conv[3];  */
   /*                                                              */
   /* but were changed to their present from in optimazation       */
   /*                                                              */
   /****************************************************************/

   fx = sca;
   ax = *fx++ * dv->p_conv[0];
   ay = *fx++ * dv->p_conv[1];
   bx = *fx++ * dv->p_conv[0] + dv->p_conv[2];
   by = *fx * dv->p_conv[1] + dv->p_conv[3];

   f1 = (ReaL_4 *) minfo.mxyz;
   fx = (ReaL_4 *) minfo.mxyz;
   end = fx + 2 * npts;
   if (parm.ostyle == 0)
   {
      for ( ; fx < end; )
      {
         X = *fx++;
         Y = *fx++;
         *f1++ = ax * X + bx;
         *f1++ = ay * Y + by;
      }
   }
   else
   {
      for ( ; fx < end; )
      {
         X = *fx++;
         Y = *fx++;
         *f1++ = ay * Y + by;
         *f1++ = ax * X + bx;
      }
   }

   return (npts);
}
