#include "gph_str.h"
#include "gph_ansi.h"
#define POLY 1

ReaL_4  bnd[4];

static ByTe_1 rcsid[] = "$Id: line_clip.c,v 1.1 1999/11/21 08:55:56 chris.gurgiolo.b2r Stab chrisg $";

ByTe_2 line_clip (ByTe_2 npts, ByTe_1 from)
{
   extern struct config parm;
   extern struct memory minfo;

   struct window *wn;

   register ByTe_1 *pp;
   register ByTe_1 *npp;
   register ReaL_4 *f1;
   register ReaL_4 *f2;
   register ReaL_4 *f3;
   register ByTe_2 *s1;

   ReaL_4 *f1_end, *f2_end;
   ReaL_4  pnts1[4], pnts2[4];

   ByTe_2 action;
   ByTe_2 cnt = 0, quad[9], *q, qcnt = 0, end_ok;
   ByTe_2 *s_end;

   ByTe_1 last_pnt = 0, cornerplot = 0;
   ByTe_1 two;

/****************************************************************/
/* Set up intial pointers                                       */
/****************************************************************/

   f1 = (ReaL_4 *)minfo.mxy;
   f2 = (ReaL_4 *)minfo.mxyz;
   pp = (ByTe_1 *)minfo.cmd;
   npp = (ByTe_1 *) minfo.mxyz + parm.cl_ofst;
   wn = parm.win;
   q = &qcnt;
  
/****************************************************************/
/*  Determine clipping limits                                   */
/****************************************************************/

   find_bnd (bnd,1);

/***************************************************************/
/*  take care of case where we are only passed a single point  */
/*  which is a move and not a draw                             */
/***************************************************************/

   if (npts == 1 && *pp == 0)
   {
      f3 = bnd;
      if ((*f1 < *f3 || *f1 > *(f3+2)) || (*(f1+1) < *(f3+1) 
					      || *(f1+1) > *(f3+3)))
	 return (0);
      *npp = 0;
      *f2++ = *f1++;
      *f2   = *f1;
      return (1);
   }

/***************************************************************/
/*   take care of first point if it is a draw and not a move   */
/***************************************************************/

   if (*pp == 1 )
   {
      pnts1[2] = wn->r[0];
      pnts1[3] = wn->r[1];
      two = 1;
      end_ok = 0;
   }
   
/***************************************************************/
/*  begin to process pairs of points, every point except the   */
/*  first and last are looked at as both the beginning and     */
/*  ending point in a line                                     */
/***************************************************************/

   f1_end = (ReaL_4 *)minfo.mxy + 2 * npts;
   while (f1 < f1_end)
   {
      f3 = pnts1;
      if (*pp == 1)
      {
         *f3 = *(f3+2);
         *(f3+1) = *(f3+3);
         *(f3+2) = *f1++;
         *(f3+3) = *f1++; 
         ++pp;
         action = clip_it (pnts1,pnts2,quad,q,two);
         two = 0;
      }
      else
      {
         *(f3+2) = *f1++;
         *(f3+3) = *f1++; 
         end_ok = 0;
         ++pp;
         two = 1;
         continue;
      }

/***************************************************************/
/* If this is the last point and we are drawing a filled       */
/* polygon then if the last point is out make it appear to be  */
/* in to be able to run through the corner check to see it a   */
/* corner point needs to be added to the point array           */
/***************************************************************/

      if ((action < 0) && (f1 >= f1_end) && (from==POLY))        
      {                                                                
         end_ok = 0;                                                   
         action = 0;                                                   
	 last_pnt = 1;
      }                                                                

      if (action >= 0) 
      {
         if (end_ok)
         {
            *f2++ = pnts2[2];
            *f2++ = pnts2[3];
            *npp++ = 1;
            ++cnt;
            end_ok = (action > 1) ? 0 : 1;
         }
         else
         {
            if (qcnt>0 && from==POLY)
            {
               f3 = bnd;
               s_end = quad + qcnt;
               for (s1 = quad; s1 < s_end; )
               {
                  switch (*s1)
                  {
                     case 0:
                     case 2:
                     case 4:
                     case 6:
                        break;
                     case 1:
                        *f2++ = *f3;
                        *f2++ = *(f3+1);
                        *npp++ = 1;
                        ++cnt;
                        break;
                     case 3:
                        *f2++ = *(f3+2);
                        *f2++ = *(f3+1);
                        *npp++ = 1;
                        ++cnt;
                        break;
                     case 5:
                        *f2++ = *(f3+2);
                        *f2++ = *(f3+3);
                        *npp++ = 1;
                        ++cnt;
                        break;
                     case 7:
                        *f2++ = *f3;
                        *f2++ = *(f3+3);
                        *npp++ = 1;
                        ++cnt;
                        break;
                  }
                  *s1++ = -1;
               }
               qcnt=0;
               cornerplot=1;   
            }
            else
               qcnt=0;

            if (!last_pnt)
	    {
               f2_end = pnts2 + 4;
               for (f3 = pnts2; f3 < f2_end; )
                   *f2++ = *f3++;
               if (cornerplot)
               { 
                  *npp++ = 1;
                  cornerplot = 0;
               }
               else
                  *npp++ = 0;
               *npp++ = 1;
               cnt += 2;
               end_ok = (action > 1) ? 0 : 1;
            }
         }
      }
      else
         end_ok = 0;

   }

   if (from == POLY && parm.fill >= 0 && cnt > 2)
   {
      f1 = (ReaL_4 *)minfo.mxyz;
      f3 = f1 + (cnt - 1) * 2;
      if ((*f3 != *f1) || (*(f3 + 1) != *(f1 + 1) ))
      {
         ++cnt;
         *npp++ = 1;
         *f2++ = *f1++;
         *f2 = *f1;
      }
   }

   return (cnt);
} 
