#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: get_sqln.c,v 1.1 1999/11/21 08:55:56 chris.gurgiolo.b2r Stab chrisg $";

ReaL_4 get_sqln (ByTe_1 w, ByTe_1 axis, ReaL_4 len)
{
   extern struct config parm;
   struct scr_info *dv;
   struct window *wn;
   ReaL_4 sqx,sqy;
   ReaL_4 elen,comp;
   ByTe_1 err_code;

   err_code = (w != parm.wn_num) ? window (w,"GET_SQLN") : parm.win->open;
   if (err_code <= 0)
   {
      g_error ("GET_SQLN","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return(0.0);
   }

   dv = parm.drv->dev;
   wn = parm.win;

   if (wn->type == 1 || wn->type == 3 )
   {
      comp = (wn->real[3] - wn->real[0]) / (wn->real[4] - wn->real[1]);

      sqx = dv->mk_sq[0];
      sqy = dv->mk_sq[1] * comp;

      if (axis == 'X' || axis == 'x')
         elen = len / sqy;
      else
         elen = len / sqx;
   }
   else
      elen = len;

   return (elen);
}
