#include <math.h>
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: get_chsz.c,v 1.1 1999/11/21 08:55:56 chris.gurgiolo.b2r Stab chrisg $";

void get_chsz (ReaL_4 *cz)
{
   extern struct config parm;
   extern struct memory minfo;
   extern struct init_val ival;
   struct window *wn,*tw;
   extern ByTe_2  ch_sze[2];
   register ReaL_4 *f1,*f2,*f3,*f4;
   register ByTe_2 *s1;
   register ByTe_1 *c1;
   ReaL_4 *f5,*f6;
   ByTe_2 i;
   ReaL_4 sq1,sq2;
   ReaL_4 ax,ay;
   ReaL_4 cor[2];
   ByTe_1 ta,tb,nsq = 0;
   ByTe_1 tost,vp;
 
   if (parm.font > 0 || parm.drv->dev->hf_sz[0] == 0.0)
   {
      s1 = ch_sze;
      switch (parm.cstyle)
      {
         case 0:
            wn = parm.win;
            f4 = parm.win->slope;
            for (f1 = cz; f1 < cz + 2;)
               *f1++ = parm.csize * *s1++ / *f4++;
            break;
         case 1:
            wn = parm.win;
	    ax = wn->real[3] - wn->real[0];
	    ay = wn->real[4] - wn->real[1];
            nsq = 1;
	    cor[0] = 1.0;
	    cor[1] = 1.0;
	    if (ax > ay)
	       cor[0] = ay / ax;
	    else
	       cor[1] = ax / ay;
            f3 = cor;
            f4 = parm.win->slope;
            for (f1 = cz; f1 < cz + 2;)
               *f1++ = parm.csize * *f3++ * *s1++ / *f4++;
            break;
         case 2:
            tost = parm.alt_out; 
            vp = parm.alt_win;
            set_alt_wn (5,parm.c_win);
            wn = parm.awin;
            tw = parm.win;
            ta = (wn->type == 2 || wn->type > 3) ? 1 : 0;
            tb = (tw->type == 2 || tw->type > 3) ? 1 : 0;
            nsq = (ta && !tb) ? 1 : 0;
            c1 = tw->axis;
            f2 = tw->plot;
            f3 = wn->plot;
            f4 = wn->slope;
            f5 = wn->real;
            f6 = tw->real;
            for (f1 = cz; f1 < cz + 2; ++f1,++f2,++f3,++f5,++f6)
            {
               *f1  = parm.csize * *s1++ / *f4++;
               if (*c1++ == 0)
	          *f1 *= (*(f2 + 3) - *f2) / (*(f3 + 3) - *f3); 
               else
	          *f1 *= (log10(*(f2 + 3)) - log10(*f2)) / (*(f3 + 3) - *f3); 
	       *f1 *= (*(f5 + 3) - *f5) / (*(f6 + 3) - *f6); 
	       if (*f1 < 0)
	          *f1 = -*f1;
            }
            set_alt_wn (tost,vp);
	    break;
      }

      if (nsq)
      {
         for (f1 = cz,i = 1; f1 < cz + 2; ++f1,--i)
         {
            sq1 = parm.drv->dev->mk_sq[i];
            if (ival.devices > 1)
            {
               ++parm.drv;
               sq2 = parm.drv->dev->mk_sq[i];
               if (sq2 < sq1)
                  sq1 = sq2;
               parm.drv = (struct dev_graph *)minfo.mdrv;
            }
            *f1 /= sq1;
         }
      }

      for (f1 = cz; f1 < cz + 2; ++f1)
         if (*f1 < 0)
           *f1 = -*f1;
   }
   else
   {
      wn = parm.win;
      ax = 1.0/(wn->real[3] - wn->real[0]);
      ay = 1.0/(wn->real[4] - wn->real[1]);
      f1 = cz;
      f2 = parm.drv->dev->hf_sz;
      f4 = parm.win->slope;
      *f1++ = *f2++ * 32767.0 * ax / *f4++;
      *f1 = *f2 * 32767.0 * ay  / *f4;
   }
}
