#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: find_bnd.c,v 1.1 1999/11/21 08:55:56 chris.gurgiolo.b2r Stab chrisg $";

void find_bnd (register ReaL_4 *bnd, ByTe_1 ofwin)
{
   extern struct config   parm;
   extern struct memory   minfo;
   struct scr_info *dv;

   register struct window *wn;
   register ReaL_4 *pos;

   ReaL_4 val,ax,ay,bx,by;
   ReaL_4 tax,tay,tbx,tby;
   ReaL_4 sqx, sqy;

   ByTe_1 cuniv;

/****************************************************************/
/*  Set clipping limits -- note that if clipping is not set     */
/*  then set the clipping boundary to be the full screen        */
/****************************************************************/

   wn  = parm.win;
   dv  = parm.drv->dev;
   cuniv = (parm.univ > 7) ? 1 : parm.univ + 1;

   if (cuniv % 4 == 0)   /*** absolute device coordinates ***/
   {
      *bnd     = 0.0;
      *(bnd+1) = 0.0;
      *(bnd+2) = 32768.0;
      *(bnd+3) = 32768.0;
   }
   else
   {
      ax  = wn->real[3] - wn->real[0]; 
      ay  = (wn->real[4] - wn->real[1]); 
      bx  = wn->real[0] * 32768.0;
      by  = wn->real[1] * 32768.0;

      if (parm.alt_out >> 1 == 1)
      {
         tax = ax;
         tay = ay;
         tbx = bx;
         tby = by;
      }

      if (wn->type==2 || wn->type>3 || parm.alt_out >> 1 == 1 
                                                  || parm.alt_out == 1)
      {
         sqx = 1.0 / dv->mk_sq[1];
         sqy = 1.0 / dv->mk_sq[0];
	 if (parm.alt_out >> 1 == 1)
	 {
	    pos = (ReaL_4 *)minfo.mxy + 2 * parm.d2pts;
	    bx += ax * *pos++ * (1.0 - sqx);
	    by += ay * *pos * (1.0 - sqy);
	 }
	 else
            if (wn->type != 4)
            {
               bx = sqx * bx + 32786.0 * (1.0 - sqx)/2.0; 
               by = sqy * by + 32786.0 * (1.0 - sqy)/2.0; 
            }

         ax *=  sqx;
         ay *=  sqy;
      }

      if (wn->clip == 1 || !ofwin)
      {
         val = dv->pix_sz[0] / ax;
         *bnd = val;
         *(bnd+2) =  (!ofwin) ? val : 32768.0 - val;
         val = dv->pix_sz[1] / ay;
         *(bnd+1) = val;
         *(bnd+3) =  (!ofwin) ? val : 32768.0 - val;
      }
      else
      {
         if (wn->clip == 2)
         {
            *bnd     = 0.0;
            *(bnd+1) = 0.0;
            *(bnd+2) = 32768.0;
            *(bnd+3) = 32768.0;
         }
         else
         {
	    *bnd     = -bx / ax;
            *(bnd+1) = -by / ay;
            *(bnd+2) = (32768.0 - bx) / ax;
            *(bnd+3) = (32768.0 - by) / ay;
         }
      }

      if (parm.alt_out >> 1 == 1)
      {
         *bnd     = (tax * *bnd + tbx - bx) / ax;
         *(bnd+1) = (tay * *(bnd+1) + tby - by) / ay;
         *(bnd+2) = (tax * *(bnd+2) + tbx - bx) / ax;
         *(bnd+3) = (tay * *(bnd+3) + tby - by) / ay;
      }
   }

   /*** move slightly inside the outer pixels ***/

   *(bnd+2) -= .000000001;
   *(bnd+3) -= .000000001;
}
