/**********************************************************************/
/*                                                                    */
/*  This routine will return the first device number having which     */
/*  uses the switch location in dev_asgn (passed in) to establish     */
/*  the graphics drivers                                              */
/*                                                                    */
/**********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: dev_number.c,v 1.1 1999/11/21 08:55:56 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 dev_number (ByTe_2 sw_pos)
{
   struct scr_info dv;

   register ByTe_1 cnt;

   ByTe_4 fd = -1, num_dev;
   ByTe_4 bytes;
   ByTe_1 DevFile[80];
   ByTe_1 *Fs = PathSep;
   ByTe_1 done = 0;
   ByTe_1 dnum = -1;
      
   sprintf (DevFile, "%s%sdatafiles%sdevice.bin",getenv("GPH_HOME"), Fs, Fs);

   if (DevFile == NULL)
   {
      printf("\n Please set environment variable GPH_HOME\n");
      printf(" to point to the graphics home directory.\n");
      exit(1);
   }

   if ((fd = open (DevFile,0)) < 0)
   {
      fprintf (stderr, "\nDEV_NUMBER - CANNOT OPEN DEVICE FILE\n");
      exit (-1);
   }
#ifdef _CyGnUsC
   setmode (fd, O_BINARY);
#endif

   bytes = sizeof (struct scr_info);
   read (fd,(ByTe_1*)&num_dev,4);

   cnt = 0;
   while (!done && cnt < num_dev)
   {
       read (fd,(ByTe_1*)&dv,bytes);
       if (dv.drv_num == sw_pos)
       {
          done = 1;
          dnum = cnt;
       }
       else
          ++cnt;
   }

   close (fd);
   return (dnum);
}
