/****************************************************************/
/*  Clip_it takes a line formed from two points and determines  */
/*  if it must be clipped.  If so, it performs the clipping.    */
/*  The input parameters are:                                   */
/*                                                              */
/*     r1    - The input data points (x1,y1,x2,y2)              */
/*     r2    - The possibly clipped output data point in the    */
/*             same format (x1,y1,x2,y2)                        */
/****************************************************************/

#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: clip_it.c,v 1.1 1999/11/21 08:55:56 chris.gurgiolo.b2r Stab chrisg $";

ByTe_2 clip_it (ReaL_4 *r1, ReaL_4 *r2, ByTe_2 *quad, ByTe_2 *qcnt, ByTe_1 two)
{
   extern ReaL_4 bnd[];

   register ReaL_4 *f1;
   register ReaL_4 *f2;
   register ReaL_4 *f_end;

   ByTe_1 left1, right1, up1, down1;
   static ByTe_1 left2, right2, up2, down2;

   ReaL_4 xx,yy,slope,inter;
   ByTe_2 clip_on = 0;

/****************************************************************/
/*  Load the input set of points into the output point array    */
/****************************************************************/

   f_end = r1 + 4;
   for (f1 = r1,f2 = r2; f1 < f_end;)
       *f2++ = *f1++;

/****************************************************************/
/*  Check to see if second data point is within the clipped     */
/*  region.  This is done as 4 separate check.  The x coor.     */
/*  against the left and right x boundaries and the y coor.     */
/*  against the upper and lower y boundaries.  Note that the    */
/*  second point in the pair is always NEW!                     */
/****************************************************************/

   f1 = bnd;
   left2  = (*(r1 + 2) >= *f1++) ? 1 : 0;
   down2  = (*(r1 + 3) >= *f1++) ? 1 : 0;
   right2 = (*(r1 + 2) <= *f1++) ? 1 : 0;
   up2    = (*(r1 + 3) <= *f1) ? 1 : 0;

/****************************************************************/
/*  If the first point in the pair was not already checked as   */
/*  the last point in the previous line (polyline scenario)     */
/*  then check it also just as second point was checked.        */
/****************************************************************/

   if (two)
   {
      f1 = bnd;
      left1  = (*r1 >= *f1++) ? 1 : 0;
      down1  = (*(r1 + 1) >= *f1++) ? 1 : 0;
      right1 = (*r1 <= *f1++) ? 1 : 0;
      up1    = (*(r1 + 1) <= *f1) ? 1 : 0;
   }
   
/****************************************************************/
/*  Now it both points are within the clipping region then      */
/*  we're outta here                                            */
/****************************************************************/

   if (down1 && up1 && left1 && right1 && 
                            down2 && up2 && left2 && right2)
      return (0); 

/****************************************************************/
/*  Now it both points are outside the clipping region then get */
/*  their quadrants and we're outta here                        */
/*                                                              */
/*  I believe that we only need to get their quadrants if they  */
/*  are part of a polygon                                       */
/****************************************************************/

   if ((!left1 && !left2) || (!right1 && !right2) ||
                       (!up1 && !up2) || (!down1 && !down2))
   {
      outside(quad,qcnt,*r1,*(r1+1));
      outside(quad,qcnt,*(r1+2),*(r1+3));
      right1 = right2;
      down1  = down2;
      up1    = up2;
      left1  = left2;
      return (-1);
   }
            
/****************************************************************/
/*  At this point at least one point must lie outside the       */
/*  clipping boundary.                                          */
/*                                                              */
/*  The first check is for the case of vertical lines (the x    */
/*  coordinates are the same.  We need only check the y values  */
/*  since if the x values were out then we would not have got   */
/*  this far.                                                   */
/****************************************************************/

     f1 = bnd;
     if (*r1 == *(r1+2))
     {
        if (!up1)
        {
           *(r2+1) = *(f1+3);
           clip_on = 1;
        }
        else
           if (!down1)
           {
              *(r2+1) = *(f1+1);
              clip_on = 1;
           }

        if (!up2)
        {
           *(r2+3) = *(f1+3);
           clip_on += 2;
        }
        else
           if (!down2)
           {
              *(r2+3) = *(f1+1);
              clip_on += 2;
           }

        right1 = right2;
        down1  = down2;
        up1    = up2;
        left1  = left2;
        return (clip_on);
     } 

     if (*(r1+1) == *(r1+3))
     {
        if (!right1)
        {
           *r2 = *(f1+2);
           clip_on = 1;
        }
        else
           if (!left1)
           {
              *r2 = *f1;
              clip_on = 1;
           }

        if (!right2)
        {
           *(r2+2) = *(f1+2);
           clip_on += 2;
        }
        else
           if (!left2)
           {
              *(r2+2) = *f1;
              clip_on += 2;
           }

        right1 = right2;
        down1  = down2;
        up1    = up2;
        left1  = left2;
        return (clip_on);
     }

/****************************************************************/
/*  we have a diagonal line which exceeds the plot boundaries   */
/*  so first find linear equation for line                      */
/*                                                              */
/*  find slope and intercept of line                            */
/****************************************************************/

     slope = (*(r1+3) - *(r1+1))/(*(r1+2) - *r1);
     inter = *(r1+3) - slope * *(r1+2);

/****************************************************************/
/*  do we have to make any correction to the first set of       */
/*  points                                                      */
/****************************************************************/

     xx = *r1;
     yy = *(r1+1);
     if (!right1)
     {
        fxx (*(f1+2),*(f1+1),*(f1+3),slope,inter,&xx,&yy);
        clip_on = 1;
     }
     else
     {
        if (!left1)
        {
           fxx (*f1,*(f1+1),*(f1+3),slope,inter,&xx,&yy);
           clip_on = 1;
        }
        else
        {
           if (!up1)
           {
              xx =  (*(f1+3) - inter)/slope;
              yy = *(f1+3);
              clip_on = 1;
           }
           else
           {
              if (!down1)
              {
                 xx =  (*(f1+1) - inter)/slope;
                 yy = *(f1+1);
                 clip_on = 1;
              }
           }
        }
     }
     *r2 = xx;
     *(r2+1) = yy;

/****************************************************************/
/*  do we have to make any correction to the second set of      */
/*  points                                                      */
/****************************************************************/

     xx = *(r1+2);
     yy = *(r1+3);
     if (!right2)
     {
        fxx (*(f1+2),*(f1+1),*(f1+3),slope,inter,&xx,&yy);
        clip_on += 2;
     }
     else
     {
        if (!left2)
        {
           fxx (*f1,*(f1+1),*(f1+3),slope,inter,&xx,&yy);
           clip_on += 2;
        }
        else
        {
           if (!up2)
           {
              xx =  (*(f1+3) - inter)/slope;
              yy = *(f1+3);
              clip_on += 2;
           }
           else
           {
              if (!down2)
              {
                 xx = (*(f1+1) - inter)/slope;
                 yy = *(f1+1);
                 clip_on += 2;
              }
           }
        }
     }
     *(r2+2) = xx;
     *(r2+3) = yy;

     if (clip_on == 1)
        outside(quad,qcnt,*r1,*(r1+1));
     else
     {
        if (clip_on == 2)
           outside(quad,qcnt,*(r1+2),*(r1+3));
     }

     right1 = right2;
     down1  = down2;
     up1    = up2;
     left1  = left2;
     return (clip_on);
} 

/**********************************************************************/ 
/*  This function keeps track of the movement of a polygon which is   */
/*  being drawn outside of the current window.  The drawing is        */
/*  tracked by keeping track of the sectors throught which the        */
/*  polygon has passed.  These sectors are defined in the drawing     */
/*  below.                                                            */
/*                                                                    */
/*                         +            +                             */
/*                       7 +      6     + 5                           */
/*                     ++++++++++++++++++++++                         */
/*                         +            +                             */
/*                         +            +                             */
/*                       0 +   window   + 4                           */
/*                         +            +                             */
/*                         +            +                             */
/*                     ++++++++++++++++++++++                         */
/*                       1 +      2     + 3                           */
/*                         +            +                             */
/*                                                                    */
/**********************************************************************/

void outside (ByTe_2 *quad, ByTe_2 *qcnt, ReaL_4 x, ReaL_4 y)
{
   extern ReaL_4 bnd[4];
   register ReaL_4 *f1;
   register ByTe_2 last_quad;

   ByTe_2 i,cnt,temp,loc,t[2],terms,delta,a,b;

   f1 = bnd;
   
   /************************************************************/
   /*  Get the sector of the point (x,y)                       */
   /************************************************************/

   if (x <= *f1)
      loc = (y > *(f1+3)) ?  7 : (y < *(f1+1)) ? 1 : 0;
   else
   {
      if (x >= *(f1+2))
         loc = (y > *(f1+3)) ?  5 : (y < *(f1+1)) ? 3 : 4;
      else
      {
         if (y >= *(f1+3))
            loc = (x > *(f1+2)) ?  5 : (x < *f1) ? 7 : 6;
         else
            loc = (x > *(f1+2)) ?  3 : (x < *f1) ? 1 : 2;
      }
   }
 
   /************************************************************/
   /*                         IF                               */
   /*  this is the first point in the quadrant array then      */
   /*  store this sector location in the first element         */
   /*                        ELSE                              */
   /*  get the location of the last entered element.  Form the */
   /*  the difference between this sector and the last stored  */
   /*                         IF                               */
   /*     the two sectors are the same then no need to         */
   /*     this point                                           */
   /*                        ELSE                              */
   /*     begin the treatment of this point.                   */
   /*                         IF                               */
   /*        the delta is not 1 - that is if the polygon       */
   /*        has passed through more than one sector then      */
   /*        compute the following:                            */
   /*          b: the next counter-clockwise quadrant number   */
   /*          a: the next clockwise quadrant number           */
   /*          temp: the next clockwise quadrant  after a      */
   /*       Now it current quadrant is same as temp then the   */
   /*       polygon has moved clockwise through a to temp and  */
   /*       both the a and temp quadrants must be added to the */
   /*       quadrant array.  Otherwise the polygon had moved   */
   /*       counter-clockwise through b and both b and loc are */
   /*       added to the quandrant array                       */ 
   /*                        ELSE                              */
   /*       the point has moved one quadrant away and that     */
   /*       quadrant is added to the quadrant array            */
   /*                                                          */
   /*    The quandrant array is filled                         */
   /************************************************************/
   
   if (*qcnt == 0)
      quad[(*qcnt)++] = loc;
   else
   {
      cnt = *qcnt - 1;
      last_quad = quad[cnt];
      delta = last_quad - loc;
      if (delta < 0)
	 delta = -delta;

      if (delta != 0)
      {
         if (delta > 1 && delta < 7)
         {
            b = (last_quad + 1) % 8;
            a = (last_quad == 0) ? 7 : last_quad - 1;
            temp = (a == 0) ? 7 : a - 1;
            t[0] = (loc == temp) ? a : b;
            t[1] = loc;
            terms = 2;
         }
         else
         {
            terms = 1;
            t[0] = loc;
         }
         
         for (i=0 ; i<terms ; ++i)
         {
            if ((quad[(*qcnt)-2] == t[i]) && (*qcnt > 1) )
                  quad[(*qcnt)--] = -1;
            else
               quad[(*qcnt)++] = t[i];
         }
      }
   }

   if (*qcnt > 8)
      *qcnt = 8;
}

void fxx (ReaL_4 side, ReaL_4 miny, ReaL_4 maxy, ReaL_4 a, ReaL_4 b, ReaL_4 *x,
          ReaL_4 *y)
{
    *y = a * side + b;
    *x = side;
    if (*y > maxy)
    {
       *x = (maxy - b)/a;
       *y = maxy;
    }
    else
       if (*y < miny)
       {
          *x = (miny - b)/a;
          *y = miny;
       }
}
