#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: chg_coor.c,v 1.1 1999/11/21 08:55:56 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 chg_coor (ByTe_1 w, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, ByTe_1 corsys)
{
   extern struct config parm;
   struct scr_info *dv;
   ReaL_4 ax,bx,ay,by;
   ReaL_4 bd[4];
   ReaL_4 in1[3],sca[4];
   ReaL_4 xx,yy;
   ReaL_4 *f1;
   ByTe_1 err_code;

   err_code = (w != parm.wn_num) ? window (w,"CHG_COOR") : parm.win->open;
   if (err_code <= 0)
   {
      g_error ("CHG_COOR","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return(0);
   }

   if (corsys < 0 || corsys > 3)
   {
      g_error ("CHG_COOR","UNKNOWN COORDINATE SYSTEM",0);
      return(0);
   }
   
 
   in1[0] = *x;
   in1[1] = *y;
   in1[2] = *z;
   to_univcor (1,in1,0);
   f1 = in1;
   xx = *f1++;
   yy = *f1++;

   dv = parm.drv->dev;

   find_bnd (bd,1);
   if ((xx < *bd || xx > *(bd+2)) || (yy < *(bd+1) || yy > *(bd+3)))
      return (0);

   get_wn_sc (sca,0);

   ax = sca[0];
   ay = sca[1];
   bx = sca[2];
   by = sca[3];

   switch (corsys)
   {
      case 0:
         *x = (ax * xx + bx) * dv->p_conv[0] + dv->p_conv[2];
         *y = (ay * yy + by) * dv->p_conv[1] + dv->p_conv[3];
         break;
      case 1:
         *x = ax * xx + bx;
         *y = ay * yy + by;
         break;
      case 2:
         *x = (ax * xx + bx) * dv->s_dimen[0]/32767.0;
         *y = (ay * yy + by) * dv->s_dimen[1]/32767.0;
         break;
   }

   return (1);
}
